/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache_.commons.lang3.Validate;

public final class IndexedKeys {
    private boolean tableInit = false;
    private final AtomicInteger keyIndexCounter = new AtomicInteger();

    public final class Table {
        private final Object[] values;

        public Table() {
            IndexedKeys.this.tableInit = true;
            this.values = new Object[IndexedKeys.this.keyIndexCounter.get()];
        }

        public Table(Table original) {
            IndexedKeys.this.tableInit = true;
            this.values = (Object[])original.values.clone();
        }

        @Nullable
        public <T, I> T getValue(Key<I, T> key, I defaultInitializer) {
            Object result = this.values[((Key)key).index];
            if (result == null) {
                this.values[((Key)key).index] = result = ((Key)key).getDefault(defaultInitializer);
            }
            return (T)result;
        }

        public <T> void setValue(Key<?, T> key, T input) {
            this.values[((Key)key).index] = input;
        }
    }

    public final class Key<I, T> {
        private final int index;
        private final Function<I, ? extends T> toDefault;

        public Key(Function<I, ? extends T> toDefault) {
            Validate.isTrue(!IndexedKeys.this.tableInit, "key must not be initialized after a table has been created", new Object[0]);
            this.toDefault = toDefault;
            this.index = IndexedKeys.this.keyIndexCounter.getAndIncrement();
        }

        @Nullable
        private T getDefault(I input) {
            return this.toDefault.apply(input);
        }
    }
}

