/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache_.commons.lang3.Validate;

public final class IndexedKeysBool {
    private boolean tableInit = false;
    private final AtomicInteger keyIndexCounter = new AtomicInteger();

    public final class Table {
        private final boolean[] values;
        private final boolean[] isSet;

        public Table() {
            IndexedKeysBool.this.tableInit = true;
            this.values = new boolean[IndexedKeysBool.this.keyIndexCounter.get()];
            this.isSet = new boolean[IndexedKeysBool.this.keyIndexCounter.get()];
        }

        public Table(Table original) {
            IndexedKeysBool.this.tableInit = true;
            this.values = (boolean[])original.values.clone();
            this.isSet = (boolean[])original.isSet.clone();
        }

        public <I> boolean getValue(Key<I> key, I defaultInitializer) {
            boolean result = this.values[((Key)key).index];
            if (!this.isSet[((Key)key).index]) {
                this.values[((Key)key).index] = result = ((Key)key).getDefault(defaultInitializer);
            }
            return result;
        }

        public void setValue(Key<?> key, boolean input) {
            this.values[((Key)key).index] = input;
        }
    }

    public final class Key<I> {
        private final int index;
        private final Predicate<I> toDefault;

        public Key(Predicate<I> toDefault) {
            Validate.isTrue(!IndexedKeysBool.this.tableInit, "key must not be initialized after a table has been created", new Object[0]);
            this.toDefault = toDefault;
            this.index = IndexedKeysBool.this.keyIndexCounter.getAndIncrement();
        }

        private boolean getDefault(I input) {
            return this.toDefault.test(input);
        }
    }
}

