/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import org.apache_.commons.lang3.Validate;

public final class IndexedKeysFloat {
    private boolean tableInit = false;
    private final AtomicInteger keyIndexCounter = new AtomicInteger();

    public final class Table {
        private final float[] values;

        public Table() {
            IndexedKeysFloat.this.tableInit = true;
            this.values = new float[IndexedKeysFloat.this.keyIndexCounter.get()];
        }

        public Table(Table original) {
            IndexedKeysFloat.this.tableInit = true;
            this.values = (float[])original.values.clone();
        }

        public <I> double getValue(Key<I> key, I defaultInitializer) {
            double result = this.values[((Key)key).index];
            if (Double.isNaN(result)) {
                result = ((Key)key).getDefault(defaultInitializer);
                this.values[((Key)key).index] = (float)result;
            }
            return result;
        }

        public <T> void setValue(Key<?> key, double input) {
            this.values[((Key)key).index] = (float)input;
        }
    }

    public final class Key<I> {
        private final int index;
        private final ToDoubleFunction<I> toDefault;

        public Key(ToDoubleFunction<I> toDefault) {
            Validate.isTrue(!IndexedKeysFloat.this.tableInit, "key must not be initialized after a table has been created", new Object[0]);
            this.toDefault = toDefault;
            this.index = IndexedKeysFloat.this.keyIndexCounter.getAndIncrement();
        }

        private double getDefault(I input) {
            return this.toDefault.applyAsDouble(input);
        }
    }
}

