/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import org.apache_.commons.lang3.Validate;

public final class IndexedKeysInt {
    private boolean tableInit = false;
    private final AtomicInteger keyIndexCounter = new AtomicInteger();

    public final class Table {
        private final int[] values;

        public Table() {
            IndexedKeysInt.this.tableInit = true;
            this.values = new int[IndexedKeysInt.this.keyIndexCounter.get()];
        }

        public Table(Table original) {
            IndexedKeysInt.this.tableInit = true;
            this.values = (int[])original.values.clone();
        }

        public <I> int getValue(Key<I> key, I defaultInitializer) {
            int result = this.values[((Key)key).index];
            if (result == Integer.MIN_VALUE) {
                this.values[((Key)key).index] = result = ((Key)key).getDefault(defaultInitializer);
            }
            return result;
        }

        public void setValue(Key<?> key, int input) {
            this.values[((Key)key).index] = input;
        }
    }

    public final class Key<I> {
        private final int index;
        private final ToIntFunction<I> toDefault;

        public Key(ToIntFunction<I> toDefault) {
            Validate.isTrue(!IndexedKeysInt.this.tableInit, "key must not be initialized after a table has been created", new Object[0]);
            this.toDefault = toDefault;
            this.index = IndexedKeysInt.this.keyIndexCounter.getAndIncrement();
        }

        private int getDefault(I input) {
            return this.toDefault.applyAsInt(input);
        }
    }
}

