/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.IPlantable;
import org.apache_.commons.lang3.mutable.MutableInt;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class MCHelper {
    public static final int DEFAULT_FLAG = 20;
    public static final boolean DEFAULT_IS_MOVING = false;
    public static final int WATER_HEIGHT = 63;
    public static final Interval VALID_WORLD_HEIGHT = new Interval(1.0, 255.0);
    public static final IntPosInfo<BlockPos> MC_POS_INFO = new IntPosInfo<BlockPos>(){

        @Override
        public int getIntX(BlockPos pos) {
            return pos.func_177958_n();
        }

        @Override
        public int getIntZ(BlockPos pos) {
            return pos.func_177952_p();
        }

        @Override
        public int getLog2Scale() {
            return 0;
        }

        @Override
        public BlockPos build(int x, int z) {
            return new BlockPos(x, 0, z);
        }
    };
    public static final IntPosInfo<ChunkPos> CHUNK_POS_INFO = new IntPosInfo<ChunkPos>(){

        @Override
        public int getIntX(ChunkPos pos) {
            return pos.field_77276_a;
        }

        @Override
        public int getIntZ(ChunkPos pos) {
            return pos.field_77275_b;
        }

        @Override
        public int getLog2Scale() {
            return 4;
        }

        @Override
        public ChunkPos build(int x, int z) {
            return new ChunkPos(x, z);
        }
    };
    public static final List<Direction> NSWE = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST);
    public static final List<Direction> NSWED = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST, (Object)Direction.DOWN);

    private MCHelper() {
    }

    public static void forEachPos(ChunkPos chunkPos, Consumer<BlockPos2D> consumer) {
        BlockPos2D.Mutable lowestPos = new BlockPos2D.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                lowestPos.setPos(chunkPos.func_180334_c() + x, chunkPos.func_180333_d() + z);
                consumer.accept(lowestPos);
            }
        }
    }

    public static boolean isMostlyAir(BlockState block) {
        if (block.func_177230_c().equals(Blocks.field_150433_aE)) {
            return true;
        }
        return !block.func_185904_a().func_76220_a() && block.func_204520_s().func_206888_e();
    }

    public static boolean isMostlyWater(BlockState block) {
        return block.func_177230_c().equals(Blocks.field_150355_j) || !block.func_185904_a().func_76220_a() && !block.func_204520_s().func_206888_e();
    }

    public static void clearVertically(BlockPos pos, IWorld world, Predicate<BlockState> clearable) {
        int minY;
        BlockPos.Mutable mutPos = new BlockPos.Mutable(pos);
        int maxY = MCHelper.getHighestNonAirY(MCHelper.to2D(pos), (IWorldReader)world);
        for (int y = minY = pos.func_177956_o(); y <= maxY; ++y) {
            mutPos.func_185336_p(y);
            BlockState block = world.func_180495_p((BlockPos)mutPos);
            if (!clearable.test(block)) continue;
            world.func_180501_a((BlockPos)mutPos, block.func_204520_s().func_206883_i(), 20);
        }
    }

    public static boolean isPlant(Block block) {
        return block instanceof IPlantable;
    }

    public static boolean isSolid(BlockState block) {
        if (block.func_177230_c().equals(Blocks.field_150433_aE)) {
            return false;
        }
        return block.func_200132_m();
    }

    public static int getHighestSurfaceHeight(BlockPos2D pos, IWorldReader world) {
        return world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.getBlockX(), pos.getBlockZ()) - 1;
    }

    public static int getHighestTerrainHeight(BlockPos2D pos, IWorldReader world) {
        int maxY = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.getBlockX(), pos.getBlockZ()) - 1;
        BlockPos.Mutable mutPos = new BlockPos.Mutable(pos.getBlockX(), 0, pos.getBlockZ());
        for (int y = maxY; y > 1; --y) {
            BlockState block = world.func_180495_p((BlockPos)mutPos);
            if (!MCHelper.isSolid(block)) continue;
            return y;
        }
        return -1;
    }

    public static int getHighestNonAirY(BlockPos2D pos, IWorldReader world) {
        return world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.getBlockX(), pos.getBlockZ()) - 1;
    }

    public static int getHighestY(BlockPos2D pos, IWorldReader world, Predicate<BlockState> predicate) {
        int maxHeight;
        BlockPos.Mutable mutPos = new BlockPos.Mutable(pos.getBlockX(), 0, pos.getBlockZ());
        for (int y = maxHeight = MCHelper.getHighestNonAirY(pos, world); y > 1; --y) {
            mutPos.func_185336_p(y);
            BlockState block = world.func_180495_p((BlockPos)mutPos);
            if (block.func_196958_f() || !predicate.test(block)) continue;
            return y;
        }
        return -1;
    }

    public static BlockPos2D to2D(BlockPos pos) {
        return new BlockPos2D(pos.func_177958_n(), pos.func_177952_p());
    }

    public static BlockPos2D lowestPos(ChunkPos chunkPos) {
        return new BlockPos2D(chunkPos.func_180334_c(), chunkPos.func_180333_d());
    }

    public static double getTreeDensity(InterChunkPos interChunkPos, IWorldReader world, Supplier<Double> onIndeterminate) {
        MutableInt leafCounter = new MutableInt(0);
        MutableInt groundCounter = new MutableInt(0);
        interChunkPos.forEachCenterPos(pos2D -> {
            int leafHeight = MCHelper.getHighestNonAirY(pos2D, world);
            BlockPos leafPos = pos2D.to3D(leafHeight);
            Block leafBlock = world.func_180495_p(leafPos).func_177230_c();
            if (BlockTags.field_206952_E.func_199685_a_((Object)leafBlock)) {
                leafCounter.increment();
                groundCounter.increment();
                return;
            }
            int groundHeight = MCHelper.getHighestSurfaceHeight(pos2D, world);
            BlockPos groundPos = pos2D.to3D(groundHeight);
            BlockState groundBlock = world.func_180495_p(groundPos);
            if (groundBlock.canSustainPlant((IBlockReader)world, leafPos, Direction.DOWN, (IPlantable)Blocks.field_196674_t)) {
                groundCounter.increment();
            }
        });
        if (groundCounter.getValue() <= 50) {
            return onIndeterminate.get();
        }
        return (double)leafCounter.getValue().intValue() / (double)groundCounter.getValue().intValue();
    }

    public static double getPlantDensity(InterChunkPos interChunkPos, IWorldReader world, IPlantable requestedPlantBlock, Supplier<Double> onIndeterminate) {
        MutableInt plantCounter = new MutableInt(0);
        MutableInt groundCounter = new MutableInt(0);
        interChunkPos.forEachCenterPos(p -> {
            int plantHeight = MCHelper.getHighestSurfaceHeight(p, world) + 1;
            BlockPos plantPos = p.to3D(plantHeight);
            Block plantBlock = world.func_180495_p(plantPos).func_177230_c();
            if (plantBlock.equals(requestedPlantBlock)) {
                plantCounter.increment();
                groundCounter.increment();
                return;
            }
            BlockPos groundPos = plantPos.func_177977_b();
            BlockState groundBlock = world.func_180495_p(groundPos);
            if (groundBlock.canSustainPlant((IBlockReader)world, plantPos, Direction.DOWN, requestedPlantBlock)) {
                groundCounter.increment();
            }
        });
        if (groundCounter.getValue() <= 50) {
            return onIndeterminate.get();
        }
        return (double)plantCounter.getValue().intValue() / (double)groundCounter.getValue().intValue();
    }

    public static boolean spawnEntity(Entity entity, BlockPos pos, IWorld world) {
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        Random random = new Random();
        entity.func_70012_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), random.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c(entity);
        return true;
    }
}

