/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.awt.geom.Line2D;
import java.util.Random;
import java.util.function.Function;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class MathHelper {
    public static Interval VALID_FRACTAL_VALUE = new Interval(Math.nextUp(0.0f), Math.nextDown(1.0f));
    public static Interval VALID_SCALE = new Interval(Math.nextUp(0.0f), Double.POSITIVE_INFINITY);

    private MathHelper() {
    }

    public static <T> double getDistance(PosInfo<T> posInfo, T pos1, T pos2) {
        return MathHelper.hypot(posInfo.getX(pos1) - posInfo.getX(pos2), posInfo.getZ(pos1) - posInfo.getZ(pos2));
    }

    public static <T> double getDistanceSq(PosInfo<T> posInfo, T pos1, T pos2) {
        double deltaX = posInfo.getX(pos1) - posInfo.getX(pos2);
        double deltaZ = posInfo.getZ(pos1) - posInfo.getZ(pos2);
        return deltaX * deltaX + deltaZ * deltaZ;
    }

    public static double lerp(double percent, double lowerPercentValue, double upperPercentValue) {
        assert (Interval.PERCENT.contains(percent)) : percent;
        assert (Double.isFinite(lowerPercentValue)) : lowerPercentValue;
        assert (Double.isFinite(upperPercentValue)) : upperPercentValue;
        return lowerPercentValue * (1.0 - percent) + upperPercentValue * percent;
    }

    public static double inverseLerp(double value, double lowerPercentValue, double upperPercentValue) {
        assert (Double.isFinite(value)) : value;
        assert (Double.isFinite(lowerPercentValue)) : lowerPercentValue;
        assert (Double.isFinite(upperPercentValue)) : upperPercentValue;
        return (value - lowerPercentValue) / (upperPercentValue - lowerPercentValue);
    }

    public static double skew(double percent, double skew) {
        assert (Interval.PERCENT.contains(percent));
        assert (Double.isFinite(skew));
        if (skew == 0.0) {
            return percent;
        }
        double a = MathHelper.convertToA(skew);
        return (Math.pow(a, percent) - 1.0) / (a - 1.0);
    }

    private static double convertToA(double value) {
        if (value < 0.0) {
            return -value + 1.0;
        }
        return 1.0 / value + 1.0;
    }

    public static double ease(double percent, double ease) {
        assert (Interval.PERCENT.contains(percent)) : percent;
        assert (Double.isFinite(ease)) : ease;
        if (ease == 0.0) {
            return percent;
        }
        Interval lowerHalf = new Interval(0.0, 0.5);
        Interval upperHalf = new Interval(0.5, 1.0);
        if (lowerHalf.contains(percent)) {
            double lowerHalfPercent = lowerHalf.mapInterval(percent, Interval.PERCENT);
            lowerHalfPercent = MathHelper.skew(lowerHalfPercent, -ease);
            return Interval.PERCENT.mapInterval(lowerHalfPercent, lowerHalf);
        }
        assert (upperHalf.contains(percent));
        double upperHalfPercent = upperHalf.mapInterval(percent, Interval.PERCENT);
        upperHalfPercent = MathHelper.skew(upperHalfPercent, ease);
        return Interval.PERCENT.mapInterval(upperHalfPercent, upperHalf);
    }

    public static boolean randomBool(double percent, Random random) {
        assert (Interval.PERCENT.contains(percent)) : percent;
        if (percent == 0.5) {
            return random.nextBoolean();
        }
        double randomPercent = random.nextFloat();
        return randomPercent < percent;
    }

    public static int randomInt(int min, int maxExclusive, Random random) {
        assert (min < maxExclusive) : min + " " + maxExclusive;
        return random.nextInt(maxExclusive - min) + min;
    }

    public static int randomRound(double value, Random random) {
        assert (Double.isFinite(value)) : value;
        assert (value >= 0.0) : value;
        if (value <= 0.5) {
            if (MathHelper.randomBool(value, random)) {
                return 1;
            }
            return 0;
        }
        int result = 0;
        int fullHalves = (int)(value / 0.5);
        for (int i = 0; i < fullHalves; ++i) {
            if (!MathHelper.randomBool(0.5, random)) continue;
            ++result;
        }
        double remaining = value - (double)((float)fullHalves * 0.5f);
        if (MathHelper.randomBool(remaining, random)) {
            ++result;
        }
        return result;
    }

    public static <I> double getDistanceToVoronoiBorder(I center, PointsProvider<I> pointsProvider, int pointCount) {
        assert (pointCount >= 2) : pointCount;
        PosInfo<I> posInfo = pointsProvider.getPosInfo();
        Object cellCenter = null;
        double distanceToClosestBorder = Double.POSITIVE_INFINITY;
        for (I point : pointsProvider.getClosestPoints(center, pointCount)) {
            if (cellCenter == null) {
                cellCenter = point;
                continue;
            }
            Line border = new Line(posInfo.getX(cellCenter), posInfo.getZ(cellCenter), posInfo.getX(point), posInfo.getZ(point)).rotate90();
            double distanceToBorder = border.getDistanceToPoint(posInfo.getX(center), posInfo.getZ(center));
            if (!(distanceToBorder < distanceToClosestBorder)) continue;
            distanceToClosestBorder = distanceToBorder;
        }
        assert (distanceToClosestBorder != Double.POSITIVE_INFINITY);
        return distanceToClosestBorder;
    }

    public static double fractal(Function<Double, Double> scaleToOutput, Interval interval, double octaves, double peristence, double lacunarity) {
        assert (octaves >= 1.0) : octaves;
        assert (Double.isFinite(octaves)) : octaves;
        assert (VALID_FRACTAL_VALUE.contains(lacunarity)) : lacunarity;
        assert (VALID_FRACTAL_VALUE.contains(peristence)) : peristence;
        double currentScale = 1.0;
        double currentAmp = 1.0;
        double maxValue = interval.getMax();
        double minValue = interval.getMin();
        double cumulativeValue = 0.0;
        for (int i = 0; i < MathHelper.floor(octaves); ++i) {
            cumulativeValue += scaleToOutput.apply(currentScale) * currentAmp;
            currentScale *= lacunarity;
            maxValue += maxValue * (currentAmp *= peristence);
            minValue += minValue * currentAmp;
        }
        double remainingIteration = octaves - Math.floor(octaves);
        maxValue += maxValue * currentAmp * remainingIteration;
        minValue += minValue * currentAmp * remainingIteration;
        return new Interval(minValue, maxValue).mapInterval(cumulativeValue += scaleToOutput.apply(currentScale) * currentAmp * remainingIteration, interval);
    }

    public static double scaleLimitToOctaves(double scale, double scaleLimit, double lacunarity) {
        assert (VALID_SCALE.contains(scaleLimit)) : scaleLimit;
        assert (VALID_SCALE.contains(scale)) : scale;
        assert (VALID_FRACTAL_VALUE.contains(lacunarity)) : lacunarity;
        assert (scale >= scaleLimit) : scale + " " + scaleLimit;
        return Math.log(scaleLimit / scale) / Math.log(lacunarity) + 1.0;
    }

    public static <I> double gradientTowardsPoint(I pos, double radius, PointsProvider<I> clusterCenters) {
        assert (radius >= 0.0) : radius;
        assert (Double.isFinite(radius)) : radius;
        return MathHelper.gradientTowardsPoint(pos, FloatFunc.constFunc(radius), clusterCenters);
    }

    public static <I> double gradientTowardsPoint(I pos, FloatFunc<I> radiusFunc, PointsProvider<I> clusterCenters) {
        PosInfo<I> posInfo = clusterCenters.getPosInfo();
        double result = 0.0;
        double maxSearchDistance = radiusFunc.getOutputInterval().getMax();
        for (I clusterCenter : clusterCenters.getBoundedPoints(pos, maxSearchDistance)) {
            double radius = radiusFunc.getOutput(clusterCenter);
            double distanceFromCenter = MathHelper.getDistance(posInfo, pos, clusterCenter);
            if (distanceFromCenter > radius) continue;
            double percentFromCluster = MathHelper.inverseLerp(distanceFromCenter, radius, 0.0);
            result = Math.max(result, percentFromCluster);
        }
        return result;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int ceil(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static double hypot(double x, double y) {
        int expY;
        if (Double.isInfinite(x) || Double.isInfinite(y)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        int expX = Math.getExponent(x);
        if (expX > (expY = Math.getExponent(y)) + 27) {
            return Math.abs(x);
        }
        if (expY > expX + 27) {
            return Math.abs(y);
        }
        int middleExp = (expX + expY) / 2;
        double scaledX = Math.scalb(x, -middleExp);
        double scaledY = Math.scalb(y, -middleExp);
        double scaledH = Math.sqrt(scaledX * scaledX + scaledY * scaledY);
        return Math.scalb(scaledH, middleExp);
    }

    private static class Line {
        double p1x;
        double p1z;
        double p2x;
        double p2z;

        Line(double p1x, double p1z, double p2x, double p2z) {
            this.p1x = p1x;
            this.p1z = p1z;
            this.p2x = p2x;
            this.p2z = p2z;
        }

        Line rotate90() {
            double midPointX = (this.p1x + this.p2x) / 2.0;
            double midPointZ = (this.p1z + this.p2z) / 2.0;
            double rotatedP1X = -(this.p1z - midPointZ) + midPointX;
            double rotatedP1Z = this.p1x - midPointX + midPointZ;
            double rotatedP2X = -(this.p2z - midPointZ) + midPointX;
            double rotatedP2Z = this.p2x - midPointX + midPointZ;
            return new Line(rotatedP1X, rotatedP1Z, rotatedP2X, rotatedP2Z);
        }

        double getDistanceToPoint(double pointX, double pointZ) {
            return new Line2D.Double(this.p1x, this.p1z, this.p2x, this.p2z).ptLineDist(pointX, pointZ);
        }
    }
}

