/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;

public final class PosModCache<I, O> {
    private final int gridLength;
    private final int gridLengthLog2;
    private final Function<I, O> base;
    private final AtomicReferenceArray<Entry<O>> keyArray;
    private final IntPosInfo<I> posInfo;

    public PosModCache(int gridLength, Function<I, O> base, IntPosInfo<I> posInfo) {
        this.gridLengthLog2 = Log2helper.asLog2(gridLength);
        this.gridLength = gridLength;
        this.base = base;
        this.keyArray = new AtomicReferenceArray(gridLength * gridLength);
        this.posInfo = posInfo;
    }

    public O get(I pos) {
        int posX = this.posInfo.getIntX(pos);
        int posZ = this.posInfo.getIntZ(pos);
        int modX = Log2helper.mod(posX, this.gridLengthLog2);
        int modZ = Log2helper.mod(posZ, this.gridLengthLog2);
        int index = Log2helper.mult(modX, this.gridLengthLog2) + modZ;
        Entry<O> entryAtIndex = this.keyArray.get(index);
        if (entryAtIndex != null && posX == ((Entry)entryAtIndex).x && posZ == ((Entry)entryAtIndex).z) {
            return (O)((Entry)entryAtIndex).value;
        }
        O newValue = this.base.apply(pos);
        this.keyArray.set(index, new Entry(posX, posZ, newValue));
        return newValue;
    }

    private static class Entry<O> {
        private final int x;
        private final int z;
        private final O value;

        private Entry(int x, int z, O value) {
            this.x = x;
            this.z = z;
            this.value = value;
        }
    }
}

