/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.misc;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class ProgressPrinter {
    private AtomicLong iterations = new AtomicLong();
    private final long total;
    private AtomicLong lastPrintTime = new AtomicLong();
    private AtomicBoolean printLock = new AtomicBoolean(false);

    public ProgressPrinter(long total) {
        assert (total > 0L);
        this.total = total;
    }

    public void incrementAndTryPrintProgress() {
        this.iterations.incrementAndGet();
        if (System.currentTimeMillis() < this.lastPrintTime.get() + 1000L) {
            return;
        }
        if (!this.printLock.compareAndSet(false, true)) {
            return;
        }
        this.lastPrintTime.set(System.currentTimeMillis());
        double percent = (double)this.iterations.get() / (double)this.total;
        System.out.printf("%.2f%%\n", percent * 100.0);
        this.printLock.set(false);
    }
}

