/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.pointsprovider;

import java.util.Arrays;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.pointsprovider.GriddedPointsProvider;
import weightedgpa.infinibiome.internal.pos.Grid;

public final class GridLowestPoint<T>
extends GriddedPointsProvider<T> {
    private final int gridLengthLog2;
    private final PosInfo<T> posInfo;

    public GridLowestPoint(int gridLength, PosInfo<T> posInfo) {
        this.gridLengthLog2 = Log2helper.asLog2(gridLength);
        this.posInfo = posInfo;
    }

    @Override
    public PosInfo<T> getPosInfo() {
        return this.posInfo;
    }

    @Override
    public Iterable<T> getOutputFromGrid(Grid<T> grid) {
        T lowest = grid.getLowest();
        return Arrays.asList(lowest);
    }

    @Override
    public int getgridLengthLog2() {
        return this.gridLengthLog2;
    }
}

