/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.pointsprovider;

import java.util.ArrayList;
import java.util.Random;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.floatfunc.IntFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.pointsprovider.GriddedPointsProvider;
import weightedgpa.infinibiome.internal.pos.Grid;

public final class GridRandomPoints<T>
extends GriddedPointsProvider<T> {
    private final RandomGen randomGen;
    private final IntFunc<T> pointsPerGridFunc;
    private final int gridLengthLog2;
    private final PosInfo<T> posInfo;

    public GridRandomPoints(Seed seed, IntFunc<T> pointsPerGridFunc, int gridLength, PosInfo<T> posInfo) {
        seed = seed.newSeed("griddedRandom");
        assert (pointsPerGridFunc.getOutputInterval().getMax() > 0.0);
        this.randomGen = new RandomGen(seed);
        this.pointsPerGridFunc = pointsPerGridFunc;
        this.gridLengthLog2 = Log2helper.asLog2(gridLength);
        this.posInfo = posInfo;
    }

    @Override
    public PosInfo<T> getPosInfo() {
        return this.posInfo;
    }

    @Override
    public Iterable<T> getOutputFromGrid(Grid<T> grid) {
        Random random = this.randomGen.getRandom(grid.getGridX(), grid.getGridZ());
        int pointCount = this.pointsPerGridFunc.getIntOutput(grid.getLowest());
        ArrayList<T> out = new ArrayList<T>(pointCount);
        for (int i = 0; i < pointCount; ++i) {
            out.add(grid.randomPos(random));
        }
        return out;
    }

    @Override
    public int getgridLengthLog2() {
        return this.gridLengthLog2;
    }
}

