/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.pointsprovider;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.pos.Grid;

public abstract class GriddedPointsProvider<T>
implements PointsProvider<T> {
    public abstract Iterable<T> getOutputFromGrid(Grid<T> var1);

    public abstract int getgridLengthLog2();

    @Override
    public Iterable<T> getClosestPoints(T center, int maxCount) {
        return () -> new ClosestIterable(center, maxCount);
    }

    @Override
    public Iterable<T> getBoundedPoints(T center, double maxRadius) {
        return () -> new BoundedIterable(center, maxRadius);
    }

    private final class BoundedIterable
    implements Iterator<T> {
        private int x;
        private int z;
        private final Queue<T> buffer = new ArrayDeque();
        private final T center;
        private final double maxRadiusSq;
        private final Grid<T> currentGrid;
        private final int maxRadiusGrid;

        private BoundedIterable(T center, double maxRadius) {
            this.center = center;
            this.maxRadiusSq = maxRadius * maxRadius;
            this.currentGrid = new Grid(center, GriddedPointsProvider.this.getgridLengthLog2(), GriddedPointsProvider.this.getPosInfo());
            this.maxRadiusGrid = MathHelper.ceil(maxRadius / (double)Log2helper.toNormal(GriddedPointsProvider.this.getgridLengthLog2()));
            this.x = -this.maxRadiusGrid;
            this.z = -this.maxRadiusGrid;
        }

        @Override
        public boolean hasNext() {
            this.tryFillBuffer();
            return !this.buffer.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.buffer.poll();
        }

        private void tryFillBuffer() {
            while (this.buffer.isEmpty() && this.canNextGrid()) {
                this.currentGrid.setOffset(this.x, this.z);
                for (Object point : GriddedPointsProvider.this.getOutputFromGrid(this.currentGrid)) {
                    double distanceSq = MathHelper.getDistanceSq(GriddedPointsProvider.this.getPosInfo(), point, this.center);
                    assert (Double.isFinite(distanceSq));
                    if (distanceSq > this.maxRadiusSq) continue;
                    this.buffer.add(point);
                }
                this.nextGrid();
            }
        }

        private void nextGrid() {
            if (this.x == this.maxRadiusGrid) {
                this.x = -this.maxRadiusGrid;
                ++this.z;
            } else {
                ++this.x;
            }
        }

        private boolean canNextGrid() {
            return this.x <= this.maxRadiusGrid && this.z <= this.maxRadiusGrid;
        }
    }

    static class Pair<T> {
        final T point;
        final double distSq;

        Pair(T point, double distSq) {
            this.point = point;
            this.distSq = distSq;
        }
    }

    private final class ClosestIterable
    implements Iterator<T> {
        int currentRing = 0;
        int count = 0;
        final List<Pair<T>> postponedPoints = new ArrayList();
        final Queue<Pair<T>> buffer = new PriorityQueue<Pair>(16, Comparator.comparing(p -> p.distSq));
        final T center;
        final Grid<T> currentGrid;
        final int maxCount;

        private ClosestIterable(T center, int maxCount) {
            this.center = center;
            this.currentGrid = new Grid(center, GriddedPointsProvider.this.getgridLengthLog2(), GriddedPointsProvider.this.getPosInfo());
            this.maxCount = maxCount;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.maxCount;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.buffer.isEmpty()) {
                double currentMaxDistance = this.currentRing * Log2helper.toNormal(GriddedPointsProvider.this.getgridLengthLog2());
                double currentMaxDistanceSq = Math.pow(currentMaxDistance, 2.0);
                this.loadPostponedPoints(currentMaxDistanceSq);
                this.loadPointsFromCurrentRing(currentMaxDistanceSq);
                ++this.currentRing;
            }
            ++this.count;
            return this.buffer.poll().point;
        }

        private void loadPostponedPoints(double currentMaxRadiusSq) {
            for (int i = 0; i < this.postponedPoints.size(); ++i) {
                Pair output = this.postponedPoints.get(i);
                if (!(output.distSq <= currentMaxRadiusSq)) continue;
                this.buffer.add(output);
                this.postponedPoints.remove(i);
                --i;
            }
        }

        private void loadPointsFromCurrentRing(double currentMaxRadiusSq) {
            for (int x = -this.currentRing; x <= this.currentRing; ++x) {
                for (int z = -this.currentRing; z <= this.currentRing; ++z) {
                    if (Math.abs(x) < this.currentRing && Math.abs(z) < this.currentRing) continue;
                    this.currentGrid.setOffset(x, z);
                    for (Object point : GriddedPointsProvider.this.getOutputFromGrid(this.currentGrid)) {
                        double distSq = MathHelper.getDistanceSq(GriddedPointsProvider.this.getPosInfo(), this.center, point);
                        if (distSq <= currentMaxRadiusSq) {
                            this.buffer.add(new Pair(point, distSq));
                            continue;
                        }
                        this.postponedPoints.add(new Pair(point, distSq));
                    }
                }
            }
        }
    }
}

