/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.pos;

import java.util.Random;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class Grid<I> {
    private final int centerX;
    private final int centerZ;
    private int offsetX = 0;
    private int offsetZ = 0;
    private final int gridLengthLog2;
    private final int gridLength;
    private final PosInfo<I> posInfo;

    public Grid(I pos, int gridLengthLog2, PosInfo<I> posInfo) {
        this.centerX = Log2helper.floorDiv(MathHelper.floor(posInfo.getX(pos)), gridLengthLog2);
        this.centerZ = Log2helper.floorDiv(MathHelper.floor(posInfo.getZ(pos)), gridLengthLog2);
        this.gridLength = Log2helper.toNormal(gridLengthLog2);
        this.gridLengthLog2 = gridLengthLog2;
        this.posInfo = posInfo;
    }

    public int getGridX() {
        return this.centerX + this.offsetX;
    }

    public int getGridZ() {
        return this.centerZ + this.offsetZ;
    }

    public I getLowest() {
        return this.posInfo.build(Log2helper.mult(this.getGridX(), this.gridLengthLog2), Log2helper.mult(this.getGridZ(), this.gridLengthLog2));
    }

    public I randomPos(Random random) {
        int lowestX = Log2helper.mult(this.getGridX(), this.gridLengthLog2);
        int lowestZ = Log2helper.mult(this.getGridZ(), this.gridLengthLog2);
        int highestX = lowestX + this.gridLength;
        int highestZ = lowestZ + this.gridLength;
        int randomX = MathHelper.randomInt(lowestX, highestX, random);
        int randomZ = MathHelper.randomInt(lowestZ, highestZ, random);
        return this.posInfo.build(randomX, randomZ);
    }

    public void setOffset(int x, int z) {
        this.offsetX = x;
        this.offsetZ = z;
    }

    public String toString() {
        return "Grid{gridX=" + this.centerX + ", gridZ=" + this.centerZ + ", offsetX=" + this.offsetX + ", offsetZ=" + this.offsetZ + ", gridLength=" + this.gridLengthLog2 + '}';
    }
}

