/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.block;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import owmii.krate.block.KrateBlock;
import owmii.krate.block.Tier;
import owmii.krate.handler.CompactingHandler;
import owmii.krate.item.FilterItem;
import owmii.krate.item.Itms;
import owmii.krate.item.UpgradeItem;
import owmii.lib.block.AbstractTickableTile;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.inventory.Inventory;
import owmii.lib.logistics.inventory.SidedHopper;
import owmii.lib.registry.IVariant;
import owmii.lib.util.Stack;
import owmii.lib.util.math.Box;

public class KrateTile
extends AbstractTickableTile<Tier, KrateBlock>
implements IInventoryHolder {
    private final Box box = new Box(0.0, 0.0, 4.0, 4.0, 4.0, 4.0, 0.0, 12.0);
    private final SidedHopper hopper;
    public final int exSlots = 6;
    private boolean keepInventory;
    private boolean itemTransfer;
    private boolean collect;
    private boolean compact;
    private boolean compactSleep;
    private boolean smallMatrix;
    private int range = 8;
    @OnlyIn(value=Dist.CLIENT)
    public boolean visualize;

    public KrateTile(Tier tier) {
        super(tier.getType(), (IVariant)tier);
        this.inv.set(tier.getInvSize() + this.exSlots);
        this.hopper = new SidedHopper(this.inv);
    }

    public void copy(KrateTile other) {
        CompoundNBT nbt = new CompoundNBT();
        other.box.write(nbt, "item_collect");
        this.box.read(nbt, "item_collect");
        other.hopper.write(nbt, "item_collect");
        this.hopper.read(nbt, "item_collect");
        this.keepInventory = other.keepInventory;
        this.itemTransfer = other.itemTransfer;
        this.collect = other.collect;
        this.compact = other.compact;
        this.compactSleep = other.compactSleep;
        this.smallMatrix = other.smallMatrix;
        this.range = other.range;
        this.sync();
    }

    protected void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.itemTransfer = nbt.func_74767_n("item_transfer");
        this.collect = nbt.func_74767_n("item_collect");
        this.compact = nbt.func_74767_n("item_compact");
        this.smallMatrix = nbt.func_74767_n("small_matrix");
        this.box.read(nbt, "item_collect");
        this.hopper.read(nbt, "item_transfer");
    }

    protected CompoundNBT writeSync(CompoundNBT nbt) {
        nbt.func_74757_a("item_transfer", this.itemTransfer);
        nbt.func_74757_a("item_collect", this.collect);
        nbt.func_74757_a("item_compact", this.compact);
        nbt.func_74757_a("small_matrix", this.smallMatrix);
        this.box.write(nbt, "item_collect");
        this.hopper.write(nbt, "item_transfer");
        return super.writeSync(nbt);
    }

    public void readStorable(CompoundNBT nbt) {
        this.keepInventory = nbt.func_74767_n("keep_inventory");
        super.readStorable(nbt);
    }

    public CompoundNBT writeStorable(CompoundNBT nbt) {
        nbt.func_74757_a("keep_inventory", this.keepInventory);
        return super.writeStorable(nbt);
    }

    protected int postTick(World world) {
        if (!this.isRemote()) {
            if (this.collect && this.ticks % 20 == 0 && !this.inv.isFull()) {
                List entities = world.func_217357_a(ItemEntity.class, this.box.geAxis(this.func_174877_v()));
                entities.forEach(entity -> {
                    ItemStack stack = entity.func_92059_d();
                    if (!stack.func_190926_b() && this.checkFilter(stack)) {
                        ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)this.inv, (ItemStack)stack, (boolean)false);
                        if (stack1.func_190926_b()) {
                            entity.func_70106_y();
                        } else if (stack1.func_190916_E() < stack.func_190916_E()) {
                            entity.func_92058_a(stack1);
                        }
                    }
                });
            }
            if (this.itemTransfer && this.ticks % 10 == 0) {
                this.hopper.getActiveHoppers().forEach((side, hopper) -> {
                    LazyOptional cap = Inventory.get((World)world, (BlockPos)this.field_174879_c.func_177972_a(side), (Direction)side.func_176734_d());
                    cap.ifPresent(handler -> hopper.transfer(handler, 3, this::checkFilter, this::checkPushFilter, IntStream.range(this.inv.getSlots() - this.exSlots, this.inv.getSlots()).toArray()));
                });
            }
            if (this.compact && !this.compactSleep && this.ticks % 10 == 0) {
                boolean sleep = true;
                block0: for (int i = 0; i < ((Tier)this.variant).getInvSize(); ++i) {
                    int matrix;
                    ItemStack stack = this.inv.getStackInSlot(i);
                    ItemStack res = CompactingHandler.get(world, stack, this.smallMatrix);
                    HashSet<ItemStack> stacks = new HashSet<ItemStack>();
                    int n = matrix = this.smallMatrix ? 4 : 9;
                    if (res.func_190926_b()) continue;
                    int sum = 0;
                    for (int j = 0; j < ((Tier)this.variant).getInvSize(); ++j) {
                        ItemStack stack2 = this.inv.getStackInSlot(j);
                        int count = stack2.func_190916_E();
                        if (!stack2.func_77969_a(stack)) continue;
                        if (count >= matrix) {
                            Iterator itr = stacks.iterator();
                            stack2.func_190918_g(matrix - stacks.stream().mapToInt(ItemStack::func_190916_E).sum());
                            while (itr.hasNext()) {
                                ItemStack toRemove = (ItemStack)itr.next();
                                toRemove.func_190918_g(toRemove.func_190916_E());
                                itr.remove();
                            }
                            ItemHandlerHelper.insertItem((IItemHandler)this.inv, (ItemStack)res.func_77946_l(), (boolean)false);
                            sleep = false;
                            break block0;
                        }
                        int total = sum + count;
                        if (total >= matrix) {
                            Iterator itr = stacks.iterator();
                            stack2.func_190918_g(matrix - stacks.stream().mapToInt(ItemStack::func_190916_E).sum());
                            while (itr.hasNext()) {
                                ItemStack toRemove = (ItemStack)itr.next();
                                toRemove.func_190918_g(toRemove.func_190916_E());
                                itr.remove();
                            }
                            ItemHandlerHelper.insertItem((IItemHandler)this.inv, (ItemStack)res.func_77946_l(), (boolean)false);
                            sleep = false;
                            break block0;
                        }
                        sum += count;
                        stacks.add(stack2);
                    }
                }
                this.compactSleep = sleep;
            }
        }
        return super.postTick(world);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        this.checkUpgrades();
    }

    public void onSlotChanged(int slot) {
        this.checkUpgrades();
    }

    private void checkUpgrades() {
        this.compactSleep = false;
        int size = ((Tier)this.variant).getInvSize();
        boolean itemTransfer = false;
        boolean collect = false;
        boolean keepInv = false;
        boolean compact = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.inv.getStackInSlot(i + size + 2);
            if (stack.func_77973_b() == Itms.HOPPER_UPGRADE) {
                itemTransfer = true;
                continue;
            }
            if (stack.func_77973_b() == Itms.COLLECT_UPGRADE) {
                collect = true;
                continue;
            }
            if (stack.func_77973_b() == Itms.SHULKER_UPGRADE) {
                keepInv = true;
                continue;
            }
            if (stack.func_77973_b() != Itms.COMPACT_UPGRADE) continue;
            compact = true;
        }
        boolean sync = false;
        if (this.itemTransfer != itemTransfer) {
            this.itemTransfer = itemTransfer;
            if (!itemTransfer && this.field_145850_b != null) {
                Stack.drop((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)this.inv.getStackInSlot(size + 1));
                this.inv.setStackInSlot(size + 1, ItemStack.field_190927_a);
            }
            sync = true;
        }
        if (this.collect != collect) {
            this.collect = collect;
            if (!collect) {
                this.box.reset();
                if (this.isRemote()) {
                    this.visualize = false;
                }
            }
            sync = true;
        }
        if (this.keepInventory != keepInv) {
            this.keepInventory = keepInv;
            sync = true;
        }
        if (this.compact != compact) {
            this.compact = compact;
            sync = true;
        }
        if (sync) {
            this.sync();
        }
    }

    public boolean canInsert(int slot, ItemStack stack) {
        int size = ((Tier)this.variant).getInvSize();
        if (slot >= size) {
            if (slot == size || slot == size + 1) {
                return stack.func_77973_b() instanceof FilterItem;
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack stack1 = this.inv.getStackInSlot(i + size + 2);
                if (!stack.func_77969_a(stack1)) continue;
                return false;
            }
            return stack.func_77973_b() instanceof UpgradeItem;
        }
        return this.checkFilter(stack);
    }

    private boolean checkFilter(ItemStack stack) {
        ItemStack filterStack = this.inv.getStackInSlot(((Tier)this.variant).getInvSize());
        if (filterStack.func_77973_b() instanceof FilterItem) {
            FilterItem filter = (FilterItem)filterStack.func_77973_b();
            return filter.getFilter(filterStack).checkStack(stack);
        }
        return true;
    }

    private boolean checkPushFilter(ItemStack stack) {
        ItemStack filterStack = this.inv.getStackInSlot(((Tier)this.variant).getInvSize() + 1);
        if (filterStack.func_77973_b() instanceof FilterItem) {
            FilterItem filter = (FilterItem)filterStack.func_77973_b();
            return filter.getFilter(filterStack).checkStack(stack);
        }
        return true;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return slot < ((Tier)this.variant).getInvSize();
    }

    protected boolean keepInventory() {
        return this.keepInventory;
    }

    public boolean canCollect() {
        return this.collect;
    }

    public boolean canTransferItems() {
        return this.itemTransfer;
    }

    public boolean canCompact() {
        return this.compact;
    }

    public boolean isSmallMatrix() {
        return this.smallMatrix;
    }

    public void switchMatrix() {
        this.smallMatrix = !this.smallMatrix;
        this.compactSleep = false;
    }

    public Box getBox() {
        return this.box;
    }

    public SidedHopper getHopper() {
        return this.hopper;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.visualize ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }
}

