/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.krate.block.KrateTile;
import owmii.lib.network.IPacket;

public class DirectionalRangePacket
implements IPacket<DirectionalRangePacket> {
    private BlockPos pos;
    private int direction;
    private int dist;

    public DirectionalRangePacket(BlockPos pos, int direction, int dist) {
        this.pos = pos;
        this.direction = direction;
        this.dist = dist;
    }

    public DirectionalRangePacket() {
        this(BlockPos.field_177992_a, 0, 0);
    }

    public void encode(DirectionalRangePacket msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.pos);
        buffer.writeInt(msg.direction);
        buffer.writeInt(msg.dist);
    }

    public DirectionalRangePacket decode(PacketBuffer buffer) {
        return new DirectionalRangePacket(buffer.func_179259_c(), buffer.readInt(), buffer.readInt());
    }

    public void handle(DirectionalRangePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world;
            TileEntity tile;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (tile = (world = player.func_130014_f_()).func_175625_s(msg.pos)) instanceof KrateTile) {
                KrateTile krate = (KrateTile)tile;
                krate.getBox().add(Direction.func_82600_a((int)msg.direction), (double)msg.dist);
                krate.sync();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

