/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.krate.item.FilterItem;
import owmii.lib.network.IPacket;

public class FilterPacket
implements IPacket<FilterPacket> {
    private int action;

    public FilterPacket(int action) {
        this.action = action;
    }

    public FilterPacket() {
        this(0);
    }

    public void encode(FilterPacket msg, PacketBuffer buffer) {
        buffer.writeInt(msg.action);
    }

    public FilterPacket decode(PacketBuffer buffer) {
        return new FilterPacket(buffer.readInt());
    }

    public void handle(FilterPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.func_184614_ca()).func_77973_b() instanceof FilterItem) {
                FilterItem filter = (FilterItem)stack.func_77973_b();
                switch (msg.action) {
                    case -1: {
                        filter.getFilter(stack).clear();
                        break;
                    }
                    case 0: {
                        filter.getFilter(stack).switchMode();
                        break;
                    }
                    case 1: {
                        filter.getFilter(stack).switchTag();
                        break;
                    }
                    case 2: {
                        filter.getFilter(stack).switchNBT();
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

