/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import owmii.lib.block.IBlockBase;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;

public class BlockBase
extends Block
implements IBlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final DirectionProperty H_FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockBase(Block.Properties properties) {
        super(properties);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        if (this.waterLoggable()) {
            return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
        }
        return super.func_200123_i(state, reader, pos);
    }

    public IFluidState func_204507_t(BlockState state) {
        if (this.waterLoggable()) {
            return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
        }
        return super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (this.getFacingType().equals((Object)FacingType.HORIZONTAL)) {
            state = !this.playerFacing() ? this.facing(context, false) : (BlockState)this.func_176223_P().func_206870_a((IProperty)H_FACING, (Comparable)context.func_195992_f().func_176734_d());
        } else if (this.getFacingType().equals((Object)FacingType.ALL)) {
            state = !this.playerFacing() ? this.facing(context, true) : (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d());
        }
        if (this.waterLoggable()) {
            IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
            if (state != null) {
                state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
            }
        }
        return state;
    }

    @Nullable
    private BlockState facing(BlockItemUseContext context, boolean b) {
        Direction[] directions;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : directions = context.func_196009_e()) {
            if (!b && !direction.func_176740_k().func_176722_c()) continue;
            Direction direction1 = b ? direction : direction.func_176734_d();
            if (!(blockstate = (BlockState)blockstate.func_206870_a((IProperty)(this.getFacingType().equals((Object)FacingType.ALL) ? FACING : H_FACING), (Comparable)direction1)).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (this.waterLoggable() && ((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (!stateIn.func_196955_c((IWorldReader)world, currentPos)) {
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (!world.func_201670_d() && tileEntity instanceof TileBase) {
                TileBase tile = (TileBase)tileEntity;
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT tag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
                CompoundNBT storable = tile.writeStorable(new CompoundNBT());
                if (!storable.isEmpty() && tile.isNBTStorable()) {
                    tag.func_218657_a("lollipop_Storable_NBT", (INBT)storable);
                    stack.func_77982_d(tag);
                }
                if (tile.hasCustomName()) {
                    stack.func_200302_a(tile.getCustomName());
                }
                BlockBase.func_180635_a((World)((World)world), (BlockPos)currentPos, (ItemStack)stack);
                world.func_175655_b(currentPos, false);
            }
        }
        return super.func_196271_a(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        if (!this.getFacingType().equals((Object)FacingType.NORMAL)) {
            for (Rotation rotation : Rotation.values()) {
                if (rotation.equals((Object)Rotation.NONE) || !this.func_196260_a(super.rotate(state, world, pos, rotation), (IWorldReader)world, pos)) continue;
                return super.rotate(state, world, pos, rotation);
            }
        }
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        if (this.getFacingType().equals((Object)FacingType.HORIZONTAL)) {
            return (BlockState)state.func_206870_a((IProperty)H_FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((IProperty)H_FACING)));
        }
        if (this.getFacingType().equals((Object)FacingType.ALL)) {
            return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (this.getFacingType().equals((Object)FacingType.HORIZONTAL)) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)H_FACING)));
        }
        if (this.getFacingType().equals((Object)FacingType.ALL)) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.getFacingType().equals((Object)FacingType.HORIZONTAL)) {
            builder.func_206894_a(new IProperty[]{H_FACING});
        } else if (this.getFacingType().equals((Object)FacingType.ALL)) {
            builder.func_206894_a(new IProperty[]{FACING});
        }
        if (this.waterLoggable()) {
            builder.func_206894_a(new IProperty[]{WATERLOGGED});
        }
    }

    protected FacingType getFacingType() {
        return FacingType.NORMAL;
    }

    private boolean playerFacing() {
        return false;
    }

    protected boolean waterLoggable() {
        return this instanceof IWaterLoggable;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        INamedContainerProvider provider;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof INamedContainerProvider && (provider = (INamedContainerProvider)tileentity).createMenu(0, player.field_71071_by, player) != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (BlockPos)pos);
            }
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, blockRayTraceResult);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileBase) {
            CompoundNBT tag;
            TileBase tile = (TileBase)tileentity;
            if (stack.func_82837_s()) {
                tile.setCustomName(stack.func_200301_q());
            } else {
                tile.setDefaultName(this.func_149739_a());
            }
            CompoundNBT compoundNBT = tag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
            if (!tag.isEmpty() && this.shouldStoreNBTFromStack(tag)) {
                tile.readStorable(tag.func_74775_l("lollipop_Storable_NBT"));
            }
        }
    }

    protected boolean shouldStoreNBTFromStack(CompoundNBT compound) {
        return true;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileBase tileBase;
        TileEntity tileentity;
        if (!(state.func_177230_c() == newState.func_177230_c() || !((tileentity = worldIn.func_175625_s(pos)) instanceof TileBase) || (tileBase = (TileBase)tileentity).keepInventory() && tileBase.isNBTStorable())) {
            tileBase.getInventory().drop(worldIn, pos);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity tileEntity, ItemStack stack) {
        if (tileEntity instanceof TileBase) {
            TileBase tile = (TileBase)tileEntity;
            ItemStack stack1 = new ItemStack((IItemProvider)this);
            CompoundNBT tag = stack1.func_77978_p() != null ? stack1.func_77978_p() : new CompoundNBT();
            CompoundNBT storable = tile.writeStorable(new CompoundNBT());
            if (!storable.isEmpty() && tile.isNBTStorable()) {
                tag.func_218657_a("lollipop_Storable_NBT", (INBT)storable);
                stack1.func_77982_d(tag);
            }
            if (tile.hasCustomName()) {
                stack1.func_200302_a(tile.getCustomName());
            }
            BlockBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack1);
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
        } else {
            super.func_180657_a(world, player, pos, state, null, stack);
        }
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && tileEntity.func_145842_c(id, param);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.preTooltip(stack, worldIn, tooltip, flagIn);
        this.tooltip(stack, worldIn, tooltip, flagIn);
        this.postTooltip(stack, worldIn, tooltip, flagIn);
    }

    protected void preTooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    protected void tooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    protected void postTooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    protected static enum FacingType {
        HORIZONTAL,
        ALL,
        NORMAL;

    }
}

