/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.BlockBase;
import owmii.lib.inventory.Inventory;

public class TileBase
extends TileEntity
implements INamedContainerProvider {
    protected final Inventory inv = Inventory.createBlank(this);
    private final LazyOptional<Inventory> invHandler = LazyOptional.of(() -> this.inv);
    public boolean isNew = true;
    protected boolean isContainerOpen;
    @Nullable
    public ITextComponent customName;
    public String publicName = "";

    public TileBase(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readSync(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        return this.writeSync(nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSync(pkt.func_148857_g());
    }

    public void readSync(CompoundNBT compound) {
        if (compound.func_150297_b("DefaultName", 8)) {
            this.publicName = compound.func_74779_i("DefaultName");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
        if (!this.keepInventory()) {
            this.inv.deserializeNBT(compound);
        }
        this.readStorable(compound);
        this.isNew = compound.func_74767_n("IsNew");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        if (!this.publicName.isEmpty()) {
            compound.func_74778_a("DefaultName", this.publicName);
        }
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        if (!this.keepInventory()) {
            compound.func_197643_a(this.inv.serializeNBT());
        }
        this.writeStorable(compound);
        compound.func_74757_a("IsNew", this.isNew);
        return compound;
    }

    public void readStorable(CompoundNBT compound) {
        if (this.keepInventory()) {
            this.inv.deserializeNBT(compound);
        }
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        if (this.keepInventory()) {
            compound.func_197643_a(this.inv.serializeNBT());
        }
        return compound;
    }

    public boolean isNBTStorable() {
        return true;
    }

    public void markDirtyAndSync() {
        if (this.field_145850_b != null && this.isServerWorld()) {
            this.func_70296_d();
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isServerWorld() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K;
    }

    public Block getBlock() {
        return this.func_195044_w().func_177230_c();
    }

    public void setContainerOpen(boolean b) {
        this.isContainerOpen = b;
    }

    public boolean isContainerOpen() {
        return this.isContainerOpen;
    }

    public void onSlotChanged(int index) {
    }

    public boolean canInsert(int index, ItemStack stack) {
        return true;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int index) {
        return 64;
    }

    public boolean keepInventory() {
        return false;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public ITextComponent func_145748_c_() {
        return this.getName();
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent(this.publicName, new Object[0]);
    }

    public void setDefaultName(String publicName) {
        this.publicName = publicName;
    }

    @Nullable
    public ITextComponent getCustomName() {
        return this.customName;
    }

    public ITextComponent getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public void setCustomName(ITextComponent displayName) {
        this.customName = displayName;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        if (this.getBlock() instanceof BlockBase) {
            return ((BlockBase)this.getBlock()).getContainer(i, playerInventory, this);
        }
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && !this.inv.isBlank() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class Tickable
    extends TileBase
    implements ITickableTileEntity {
        protected int syncTicks;
        public int ticks;

        public Tickable(TileEntityType<?> type) {
            super(type);
        }

        public void func_73660_a() {
            if (this.field_145850_b == null) {
                return;
            }
            if (this.doTick()) {
                if (this.ticks == 0) {
                    if (this.isNew) {
                        this.absFirstTick();
                    }
                    this.firstTick();
                }
                if (this.postTicks()) {
                    this.func_70296_d();
                    this.sync(this.getSyncTicks());
                }
                ++this.ticks;
                if (this.syncTicks > -1) {
                    --this.syncTicks;
                }
                if (this.syncTicks == 0) {
                    this.markDirtyAndSync();
                }
            }
            if (this.isNew) {
                this.isNew = false;
                this.markDirtyAndSync();
            }
        }

        protected boolean doTick() {
            return true;
        }

        protected void firstTick() {
        }

        protected void absFirstTick() {
        }

        protected boolean postTicks() {
            return false;
        }

        public void resetTicks() {
            this.ticks = 0;
        }

        public void sync(int delay) {
            if (this.syncTicks <= 0) {
                this.syncTicks = delay;
            }
        }

        public int getSyncTicks() {
            return this.isContainerOpen() ? 4 : 40;
        }
    }
}

