/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.particle.Effects;
import owmii.lib.client.util.ColorUtil;
import owmii.lib.util.math.V3d;

@OnlyIn(value=Dist.CLIENT)
public class Effect
extends Particle {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected Texture texture = GLOW_SMALL;
    protected int textureID;
    protected V3d origin = this.origin();
    protected V3d to = this.origin();
    protected boolean blend;
    protected boolean noDepth;
    protected boolean bright;
    protected boolean dynamicColor;
    protected int color0;
    protected int color1;
    protected double speed;
    protected int alphaMode;
    protected int scaleMode;
    protected float scaleFactor;
    public static final Texture GLOW_SMALL = new Texture("glow_small");
    public static final Texture GLOW_MID = new Texture("glow_mid");
    public static final Texture GLOW_DENS = new Texture("glow_dens");
    public static final Texture SQUARE = new Texture("square");
    public static final Texture STAR = new Texture("star");

    public Effect(Texture texture, World world, V3d origin) {
        this(world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
    }

    public Effect(World world, V3d origin) {
        this(world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
    }

    public Effect(Texture texture, World world, BlockPos origin) {
        this(world, origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public Effect(World world, BlockPos origin) {
        this(world, origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public Effect(Texture texture, World world, double x, double y, double z) {
        this(world, x, y, z);
    }

    public Effect(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_190017_n = false;
        this.field_82339_as = 0.0f;
        this.noDepth = true;
        this.color(0xFFFFFF);
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.render(partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void render(float partialTicks, double rotX, double rotZ, double rotYZ, double rotXY, double rotXZ) {
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap;
        if (this.render(partialTicks, x, y, z)) {
            this.render(partialTicks, x, y, z, rotX, rotZ, rotYZ, rotXY, rotXZ);
        }
    }

    public void render(float partialTicks, double x, double y, double z, double rotX, double rotZ, double rotYZ, double rotXY, double rotXZ) {
        double d0 = 0.1f * this.scaleFactor;
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] posVec = new Vec3d[]{new Vec3d(-rotX * d0 - rotXY * d0, -rotZ * d0, -rotYZ * d0 - rotXZ * d0), new Vec3d(-rotX * d0 + rotXY * d0, rotZ * d0, -rotYZ * d0 + rotXZ * d0), new Vec3d(rotX * d0 + rotXY * d0, rotZ * d0, rotYZ * d0 + rotXZ * d0), new Vec3d(rotX * d0 - rotXY * d0, -rotZ * d0, rotYZ * d0 - rotXZ * d0)};
        if (this.field_190014_F != 0.0f) {
            ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double d4 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            double d5 = MathHelper.func_76134_b((float)((float)(d4 * 0.5)));
            double d6 = (double)MathHelper.func_76126_a((float)((float)(d4 * 0.5))) * renderInfo.func_216785_c().field_72450_a;
            double d7 = (double)MathHelper.func_76126_a((float)((float)(d4 * 0.5))) * renderInfo.func_216785_c().field_72448_b;
            double d8 = (double)MathHelper.func_76126_a((float)((float)(d4 * 0.5))) * renderInfo.func_216785_c().field_72449_c;
            Vec3d vec3d = new Vec3d(d6, d7, d8);
            for (int l = 0; l < 4; ++l) {
                posVec[l] = vec3d.func_186678_a(2.0 * posVec[l].func_72430_b(vec3d)).func_178787_e(posVec[l].func_186678_a(d5 * d5 - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(posVec[l]).func_186678_a(2.0 * d5));
            }
        }
        String textureSuffix = this.texture.frames > 1 ? "" + this.textureID : "";
        this.mc.func_110434_K().func_110577_a(new ResourceLocation("lollipop", "textures/particles/" + this.texture.name + textureSuffix + ".png"));
        if (this.blend) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        bufferbuilder.func_181662_b(x + posVec[0].field_72450_a, y + posVec[0].field_72448_b, z + posVec[0].field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        bufferbuilder.func_181662_b(x + posVec[1].field_72450_a, y + posVec[1].field_72448_b, z + posVec[1].field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        bufferbuilder.func_181662_b(x + posVec[2].field_72450_a, y + posVec[2].field_72448_b, z + posVec[2].field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        bufferbuilder.func_181662_b(x + posVec[3].field_72450_a, y + posVec[3].field_72448_b, z + posVec[3].field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        tessellator.func_78381_a();
        if (this.blend) {
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }

    public boolean render(float partialTicks, double x, double y, double z) {
        return true;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.texture.frames > 1 && !this.texture.randomize) {
            this.textureID = this.field_70546_d * this.texture.frames / this.field_70547_e;
        }
        float f0 = (float)this.field_70546_d / (float)this.field_70547_e;
        if (this.dynamicColor) {
            this.color(ColorUtil.blend(this.color0, this.color1, f0));
        }
        float f = this.field_82339_as = this.alphaMode == 1 ? 1.0f - f0 : this.field_82339_as;
        if (this.scaleMode == 3) {
            this.scaleFactor = MathHelper.func_76126_a((float)((float)((double)f0 * Math.PI)));
        } else if (this.scaleMode == 2) {
            this.scaleFactor *= this.scaleFactor;
        } else if (this.scaleMode == 1) {
            this.scaleFactor = 1.0f - f0;
        }
        if (!this.origin.equals((Object)this.to)) {
            this.field_187129_i = (this.to.field_72450_a - this.field_187126_f) * this.speed;
            this.field_187130_j = (this.to.field_72448_b - this.field_187127_g) * this.speed;
            this.field_187131_k = (this.to.field_72449_c - this.field_187128_h) * this.speed;
        }
        if ((double)this.field_70545_g != 0.0) {
            this.field_187130_j = -this.field_70545_g;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_70546_d++ > this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public V3d origin() {
        return new V3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public Effect color(int color) {
        this.field_70552_h = (float)(color >> 16) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
        return this;
    }

    public Effect color(int from, int to) {
        this.dynamicColor = true;
        this.color0 = from;
        this.color1 = to;
        return this.color(from);
    }

    public Effect maxAge(int maxAge) {
        this.field_70547_e = maxAge;
        return this;
    }

    public Effect to(V3d to) {
        this.to = to;
        return this;
    }

    public Effect speed(double speed) {
        this.speed = speed;
        return this;
    }

    public Effect alpha(float alpha) {
        return this.alpha(alpha, 0);
    }

    public Effect alpha(float alpha, int mode) {
        this.field_82339_as = alpha;
        this.alphaMode = mode;
        return this;
    }

    public Effect scale(float scale, int mode, float scaleFactor) {
        this.scaleFactor = mode == 3 ? 0.0f : scale;
        this.scaleMode = mode;
        this.scaleFactor = scaleFactor;
        return this;
    }

    public Effect blend() {
        this.blend = true;
        return this;
    }

    public Effect depth() {
        this.noDepth = false;
        return this;
    }

    public Effect collide() {
        this.field_190017_n = true;
        return this;
    }

    public Effect gravity(float gravity) {
        this.field_70545_g = gravity;
        return this;
    }

    public boolean shouldDisableDepth() {
        return this.noDepth;
    }

    public void spawn() {
        this.spawn(1);
    }

    public void spawn(int count) {
        for (int i = 0; i < count; ++i) {
            Effects.INSTANCE.spawn(this);
        }
    }

    public int func_189214_a(float partialTick) {
        return this.bright ? 0xF000F0 : super.func_189214_a(partialTick);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }

    public static class Texture {
        public final String name;
        public final int frames;
        public final boolean randomize;

        public Texture(String name) {
            this(name, 0, false);
        }

        public Texture(String name, int frames) {
            this(name, frames, false);
        }

        public Texture(String name, int frames, boolean randomize) {
            this.name = name;
            this.frames = frames;
            this.randomize = randomize;
        }
    }
}

