/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class Energy {
    public static int receive(ItemStack stack, int energy, boolean simulate) {
        int[] i = new int[]{0};
        Energy.getForgeEnergy(stack).ifPresent(iEnergyStorage -> {
            i[0] = iEnergyStorage.receiveEnergy(energy, simulate);
        });
        return i[0];
    }

    public static int extract(ItemStack stack, int energy, boolean simulate) {
        int[] i = new int[]{0};
        Energy.getForgeEnergy(stack).ifPresent(iEnergyStorage -> {
            i[0] = iEnergyStorage.extractEnergy(energy, simulate);
        });
        return i[0];
    }

    public static int getStored(ItemStack stack) {
        int[] i = new int[]{0};
        Energy.getForgeEnergy(stack).ifPresent(iEnergyStorage -> {
            i[0] = iEnergyStorage.getEnergyStored();
        });
        return i[0];
    }

    public static int receive(@Nullable TileEntity tile, Direction direction, int energy, boolean simulate) {
        int[] i = new int[]{0};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(iEnergyStorage -> {
                i[0] = iEnergyStorage.receiveEnergy(energy, simulate);
            });
        }
        return i[0];
    }

    public static int extract(@Nullable TileEntity tile, Direction direction, int energy, boolean simulate) {
        int[] i = new int[]{0};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(iEnergyStorage -> {
                i[0] = iEnergyStorage.extractEnergy(energy, simulate);
            });
        }
        return i[0];
    }

    public static boolean isPresent(ItemStack stack) {
        return Energy.getForgeEnergy(stack).isPresent();
    }

    public static LazyOptional<IEnergyStorage> getForgeEnergy(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    public static boolean isPresent(@Nullable TileEntity tile, @Nullable Direction direction) {
        return Energy.getForgeEnergy(tile, direction).isPresent();
    }

    public static boolean canExtract(@Nullable TileEntity tile, @Nullable Direction direction) {
        boolean[] flag = new boolean[]{false};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(storage -> {
                flag[0] = storage.canExtract();
            });
        }
        return flag[0];
    }

    public static boolean canReceive(@Nullable TileEntity tile, @Nullable Direction direction) {
        boolean[] flag = new boolean[]{false};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(storage -> {
                flag[0] = storage.canReceive();
            });
        }
        return flag[0];
    }

    public static int maxExtract(@Nullable TileEntity tile, @Nullable Direction direction) {
        int[] i = new int[]{0};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(storage -> {
                i[0] = storage.extractEnergy(Integer.MAX_VALUE, true);
            });
        }
        return i[0];
    }

    public static int maxReceive(@Nullable TileEntity tile, @Nullable Direction direction) {
        int[] i = new int[]{0};
        if (tile != null) {
            Energy.getForgeEnergy(tile, direction).ifPresent(storage -> {
                i[0] = storage.receiveEnergy(Integer.MAX_VALUE, true);
            });
        }
        return i[0];
    }

    public static LazyOptional<IEnergyStorage> getForgeEnergy(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile == null ? LazyOptional.empty() : tile.getCapability(CapabilityEnergy.ENERGY, direction != null ? direction.func_176734_d() : null);
    }
}

