/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import java.text.NumberFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Text {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String numFormat(long value) {
        if (value == Long.MIN_VALUE) {
            return Text.numFormat(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Text.numFormat(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String addCommas(long value) {
        return NumberFormat.getInstance().format(value);
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "B");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

