/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import net.minecraft.nbt.CompoundNBT;

public class Ticker {
    private double max;
    private double ticks;

    public Ticker(double max) {
        this.max = max;
    }

    public static Ticker empty() {
        return new Ticker(0.0);
    }

    public boolean isEmpty() {
        return this.ticks <= 0.0;
    }

    public boolean ended() {
        return this.ticks >= this.max;
    }

    public void add(double ticks) {
        this.ticks = Math.min(Math.max(0.0, this.ticks + ticks), this.max);
    }

    public void onward() {
        if (this.ticks < this.max) {
            this.ticks += 1.0;
        }
    }

    public void back() {
        if (this.ticks > 0.0) {
            this.ticks -= 1.0;
        }
    }

    public void back(double value) {
        if (this.ticks > 0.0) {
            this.ticks -= Math.min(this.ticks, value);
        }
    }

    public void reset() {
        this.ticks = 0.0;
    }

    public static boolean delayed(double delay) {
        return (double)System.currentTimeMillis() % (delay * 5.0) == 0.0;
    }

    public void read(CompoundNBT compound, String key) {
        this.ticks = compound.func_74769_h(key + "Ticks");
        this.max = compound.func_74769_h(key + "Max");
    }

    public void write(CompoundNBT compound, String key) {
        compound.func_74780_a(key + "Ticks", this.ticks);
        compound.func_74780_a(key + "Max", this.max);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getTicks() {
        return this.ticks;
    }

    public void setTicks(double ticks) {
        this.ticks = ticks;
    }

    public void setAll(double ticks) {
        this.max = ticks;
        this.ticks = ticks;
    }
}

