/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class V3d
extends Vec3d {
    public static final V3d ZERO = new V3d(0.0, 0.0, 0.0);

    public V3d(double x, double y, double z) {
        super(x, y, z);
    }

    public V3d(Vec3d vector) {
        this(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public V3d(Vec3i vector) {
        super(vector);
    }

    public static V3d from(Vec3d vector) {
        return new V3d(vector);
    }

    public static V3d from(Vec3i vector) {
        return new V3d(vector);
    }

    public float distance(Vec3i vec3i) {
        return this.distance(new Vec3d(vec3i));
    }

    public float distance(Vec3d vec3d) {
        float f = (float)(this.field_72450_a - vec3d.field_72450_a);
        float f1 = (float)(this.field_72448_b - vec3d.field_72448_b);
        float f2 = (float)(this.field_72449_c - vec3d.field_72449_c);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public V3d up() {
        return this.up(1.0);
    }

    public V3d up(double factor) {
        return this.add(0.0, factor, 0.0);
    }

    public V3d down() {
        return this.down(1.0);
    }

    public V3d down(double factor) {
        return this.add(0.0, -factor, 0.0);
    }

    public V3d north() {
        return this.north(1.0);
    }

    public V3d north(double factor) {
        return this.add(0.0, 0.0, -factor);
    }

    public V3d south() {
        return this.south(1.0);
    }

    public V3d south(double factor) {
        return this.add(0.0, 0.0, factor);
    }

    public V3d east() {
        return this.east(1.0);
    }

    public V3d east(double factor) {
        return this.add(factor, 0.0, 0.0);
    }

    public V3d west() {
        return this.west(1.0);
    }

    public V3d west(double factor) {
        return this.add(-factor, 0.0, 0.0);
    }

    public V3d center() {
        return new V3d((double)((int)this.field_72450_a) + 0.5, (double)((int)this.field_72448_b) + 0.5, (double)((int)this.field_72449_c) + 0.5);
    }

    public V3d center(AxisAlignedBB bb) {
        return new V3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * 0.5, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * 0.5, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * 0.5);
    }

    public V3d centerU() {
        return this.center().up(0.5);
    }

    public V3d centerD() {
        return this.center().down(0.5);
    }

    public V3d centerN() {
        return this.center().north(0.5);
    }

    public V3d centerS() {
        return this.center().south(0.5);
    }

    public V3d centerE() {
        return this.center().east(0.5);
    }

    public V3d centerW() {
        return this.center().west(0.5);
    }

    public V3d random(double dist) {
        double d0 = Math.random() < 0.5 ? -dist : dist;
        double d1 = Math.random() < 0.5 ? -dist : dist;
        double d2 = Math.random() < 0.5 ? -dist : dist;
        return this.add(Math.random() * d0, Math.random() * d1, Math.random() * d2);
    }

    public V3d add(Vec3d vec) {
        return this.add(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public V3d add(double x, double y, double z) {
        return new V3d(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z);
    }

    public double hMagSqrt() {
        return MathHelper.func_76133_a((double)this.hMag());
    }

    public double hMag() {
        return this.field_72450_a * this.field_72450_a + this.field_72449_c * this.field_72449_c;
    }

    public double magSqrt() {
        return MathHelper.func_76133_a((double)this.mag());
    }

    public double mag() {
        return this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c;
    }

    public List<V3d> circled(int count, double radius) {
        return this.circled(count, radius, 0, 0.0);
    }

    public List<V3d> circled(int count, double radius, int ticks, double speed) {
        ArrayList<V3d> list = new ArrayList<V3d>();
        for (int i = 0; i < count; ++i) {
            double slice = Math.PI * 2 / (double)count;
            double angle = slice * (double)i;
            double x = radius * Math.cos(angle + (double)ticks * speed);
            double z = radius * Math.sin(angle + (double)ticks * speed);
            list.add(this.add(x, 0.0, z));
        }
        return list;
    }

    public V3d toOrigin() {
        return new V3d((int)this.field_72450_a, (int)this.field_72448_b, (int)this.field_72449_c);
    }

    public V3d zero() {
        return ZERO;
    }

    public BlockPos toPos() {
        return new BlockPos((Vec3d)this);
    }
}

