/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.block.TileBase;
import owmii.lib.util.lambda.Checker;

public class Inventory
extends ItemStackHandler {
    @Nullable
    private final TileBase tile;

    public Inventory(int size) {
        this(size, null);
    }

    Inventory(int size, @Nullable TileBase tile) {
        super(size);
        this.tile = tile;
    }

    public static Inventory create(int size, @Nullable TileBase tile) {
        return new Inventory(size, tile);
    }

    public static Inventory createBlank(@Nullable TileBase tile) {
        return new Inventory(0, tile);
    }

    public static Inventory create(int size) {
        return new Inventory(size, null);
    }

    public static Inventory createBlank() {
        return new Inventory(0, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.isBlank()) {
            return;
        }
        nbt.func_74768_a("Size", this.getSlots());
        super.deserializeNBT(nbt);
    }

    public CompoundNBT serializeNBT() {
        return this.isBlank() ? new CompoundNBT() : super.serializeNBT();
    }

    public Inventory set(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.onContentsChanged(0);
        return this;
    }

    public Inventory add(int size) {
        this.stacks = NonNullList.func_191197_a((int)(size + this.stacks.size()), (Object)ItemStack.field_190927_a);
        return this;
    }

    public int getSlotLimit(int slot) {
        if (this.tile != null) {
            return this.tile.getSlotLimit(slot);
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canInsert(slot, stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.canExtract(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canExtract(slot, stack);
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        if (this.tile != null) {
            this.tile.onSlotChanged(slot);
        }
    }

    @Nullable
    public TileBase getTile() {
        return this.tile;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (ItemStack stack : this.stacks) {
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotEmpty(int slot) {
        return ((ItemStack)this.stacks.get(slot)).func_190926_b();
    }

    public ItemStack setSlotEmpty(int slot) {
        ItemStack stack = (ItemStack)this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        this.onContentsChanged(slot);
        return stack;
    }

    public ItemStack setStack(int slot, ItemStack stack) {
        ItemStack stack1 = (ItemStack)this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
        return stack1;
    }

    public void clear() {
        this.set(this.getSlots());
    }

    public boolean isBlank() {
        return this.stacks.size() <= 0;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public List<ItemStack> getNonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        stacks.removeIf(ItemStack::func_190926_b);
        return stacks;
    }

    public ItemStack addNext(ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            this.insertItem(i, stack.func_77946_l(), false);
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeNext() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.setSlotEmpty(i);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public Pair<Integer, ItemStack> firstNonEmpty() {
        return this.firstNonEmpty(stack -> true);
    }

    public Pair<Integer, ItemStack> lastNonEmpty() {
        return this.lastNonEmpty(stack -> true);
    }

    public Pair<Integer, ItemStack> firstNonEmpty(Checker<ItemStack> filter) {
        return this.firstNonEmpty(filter, i -> true);
    }

    public Pair<Integer, ItemStack> firstNonEmptySlot(Checker<Integer> index) {
        return this.firstNonEmpty(stack -> true, index);
    }

    public Pair<Integer, ItemStack> firstNonEmpty(Checker<ItemStack> filter, Checker<Integer> index) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b() || !filter.check(stack) || !index.check(i)) continue;
            return Pair.of((Object)i, (Object)stack);
        }
        return Pair.of((Object)0, (Object)ItemStack.field_190927_a);
    }

    public Pair<Integer, ItemStack> lastNonEmpty(Checker<ItemStack> filter) {
        return this.lastNonEmpty(filter, i -> true);
    }

    public Pair<Integer, ItemStack> lastNonEmptySlot(Checker<Integer> index) {
        return this.lastNonEmpty(stack -> true, index);
    }

    public Pair<Integer, ItemStack> lastNonEmpty(Checker<ItemStack> filter, Checker<Integer> index) {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b() || !filter.check(stack) || !index.check(i)) continue;
            return Pair.of((Object)i, (Object)stack);
        }
        return Pair.of((Object)0, (Object)ItemStack.field_190927_a);
    }

    public void drop(World world, BlockPos pos) {
        this.stacks.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        this.clear();
    }

    public void drop(int index, World world, BlockPos pos) {
        ItemStack stack = this.getStackInSlot(index);
        if (!stack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            this.setStack(index, ItemStack.field_190927_a);
        }
    }

    public static Inventory from(final IItemHandler handler) {
        Inventory inventory = new Inventory(handler.getSlots()){

            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, true);
            }

            @Override
            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }
        };
        return inventory;
    }

    public static NonNullList<ItemStack> toList(IItemHandler handler) {
        NonNullList stacks = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.set(i, (Object)handler.getStackInSlot(i));
        }
        return stacks;
    }

    public static LazyOptional<IItemHandler> get(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null ? te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : LazyOptional.empty();
    }
}

