/*
 * Decompiled with CFR 0.152.
 */
package com.github.trhod177.lootbagmod;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;

public class LootBagConfig {
    public static final String MOB_DROPS = "Mob Drops";
    public static final String BLACK_WHITE_LISTS = "Black And White Lists";
    public static final String MISC = "Misc";
    private static List<String> BlackListList = Lists.newArrayList((Object[])new String[]{"minecraft:air", "minecraft:command_block", "minecraft:structure_block", "minecraft:knowledge_book", "minecraft:chain_command_block", "minecraft:repeating_command_block", "minecraft:barrier", "minecraft:enchanted_book", "minecraft:written_book", "minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:spawn_egg", "minecraft:structure_void", "minecraft:mob_spawner", "minecraft:bedrock"});
    private static List<String> WhiteListList = Lists.newArrayList((Object[])new String[]{"minecraft:stone"});
    private static List<String> TagList = Lists.newArrayList();
    private static List<String> MobListList = Lists.newArrayList((Object[])new String[]{"minecraft:blaze", "minecraft:cave_spider", "minecraft:creeper", "minecraft:drowned", "minecraft:elder_guardian", "minecraft:enderman", "minecraft:endermite", "minecraft:evoker"});
    private static List<String> ModNames = Lists.newArrayList((Object[])new String[]{"tconstruct"});
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> BlackList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> WhiteList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> TagsList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> MobList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ModName;
    public static ForgeConfigSpec.BooleanValue enablewhitelist;
    public static ForgeConfigSpec.BooleanValue debugmode;
    public static ForgeConfigSpec.IntValue stacksize;
    public static ForgeConfigSpec.IntValue drops;
    public static ForgeConfigSpec.IntValue dropchance;

    public static void init(ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder client) {
        client.push(MISC);
        stacksize = client.comment("Stack Size").defineInRange("stacksize", 15, 1, 64);
        drops = client.comment("How many items drop when a loot bag is used").defineInRange("dropamount", 10, 1, 1000);
        debugmode = client.comment("Enable debug mode").define("debugmode", false);
        client.pop();
        client.push(BLACK_WHITE_LISTS);
        BlackList = client.comment("BlackList (Syntax \"minecraft or modid : item or block name\"; example \"minecraft:air\" or \"lootbagmod:lootbag\")").define("blacklist", BlackListList);
        enablewhitelist = client.comment("Use the whitelist").define("enablewhitelist", false);
        WhiteList = client.comment("WhiteList Syntax \"minecraft or modid : item or block name\"; example minecraft:air or lootbagmod:lootbag)").define("whitelist", WhiteListList);
        TagsList = client.comment("TagList (Syntax \"minecraft, forge or modid : tag name\"; example \"minecraft:planks\" or \"forge:planks\")").define("taglist", TagList);
        ModName = client.comment("Mod black/whitelist (Syntax \" modid \")").define("modlist", ModNames);
        client.pop();
        client.push(MOB_DROPS);
        MobList = client.comment("Mob drops list (Syntax \" minecraft or modname : mobregistryname \")").define("mobdropslist", MobListList);
        dropchance = client.comment("Loot Bag drop chance from mobs (the higher the number the more common they are)").defineInRange("dropchance", 10, 1, 100);
        client.pop();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
    }
}

