/*
 * Decompiled with CFR 0.152.
 */
package com.github.trhod177.lootbagmod;

import com.github.trhod177.lootbagmod.ConfigManager;
import com.github.trhod177.lootbagmod.ItemBasicRewardBag;
import com.github.trhod177.lootbagmod.LootBagConfig;
import com.github.trhod177.lootbagmod.LootHandler;
import com.github.trhod177.lootbagmod.Registration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lootbagmod")
public class LootBagMod {
    public static LootBagMod instance;
    public static final String Version = "1.6.4";
    public static final String MODID = "lootbagmod";
    public static final Logger logger;

    public LootBagMod() {
        Registration.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigManager.CLIENT);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ConfigManager.loadConfig(ConfigManager.CLIENT, FMLPaths.CONFIGDIR.get().resolve("lootbagmod-client.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        String name;
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        ArrayList modnames = new ArrayList((Collection)LootBagConfig.ModName.get());
        for (Object item : ForgeRegistries.ITEMS) {
            name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)item)).toString();
            ItemBasicRewardBag.Droppables.add(name);
        }
        if (!((Boolean)LootBagConfig.enablewhitelist.get()).booleanValue()) {
            ArrayList<String> stringList = new ArrayList<String>((Collection)LootBagConfig.BlackList.get());
            for (String drops : ItemBasicRewardBag.Droppables) {
                for (int i = 0; i < modnames.size(); ++i) {
                    if (!drops.contains((CharSequence)modnames.get(i))) continue;
                    stringList.add(drops);
                    System.out.print(drops);
                }
            }
            ItemBasicRewardBag.Droppables.removeAll(stringList);
        } else if (((Boolean)LootBagConfig.enablewhitelist.get()).booleanValue()) {
            ArrayList whitelist = new ArrayList((Collection)LootBagConfig.WhiteList.get());
            for (int i = 0; i < whitelist.size(); ++i) {
                name = (String)((List)LootBagConfig.WhiteList.get()).get(i);
                ItemBasicRewardBag.DroppablesWhiteList.add(name.toString());
            }
            ArrayList<String> stringList = new ArrayList<String>();
            for (String drops : ItemBasicRewardBag.Droppables) {
                for (int i = 0; i < modnames.size(); ++i) {
                    if (!drops.contains((CharSequence)modnames.get(i))) continue;
                    stringList.add(drops);
                    System.out.print(drops);
                }
            }
            ItemBasicRewardBag.DroppablesWhiteList.addAll(stringList);
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartedEvent event) {
    }

    public static void blackListPrint() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-blacklisteditems-final.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            for (String item : ItemBasicRewardBag.Droppables) {
                outstream.write(item);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file blacklisteditems.txt");
            e.printStackTrace();
        }
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-droppableitems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            Iterator<String> iterator = ItemBasicRewardBag.Droppables.iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = iterator.next();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file droppableitems.txt");
            e.printStackTrace();
        }
    }

    public static void blackListItems(ArrayList<String> list) {
        BufferedWriter outstream = null;
        File itemlist = new File("config/lootbagmod-blacklisteditems.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String item;
                String name = item = iterator.next();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error: Could not write file blacklisteditems.txt");
            e.printStackTrace();
        }
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

