/*
 * Decompiled with CFR 0.152.
 */
package com.github.trhod177.lootbagmod;

import com.github.trhod177.lootbagmod.DebugUtils;
import com.github.trhod177.lootbagmod.LootBagConfig;
import com.github.trhod177.lootbagmod.Registration;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lootbagmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LootHandler {
    private static final Random rand = new Random();

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "stronghold_crossing": 
                case "stronghold_library": 
                case "stronghold_corridor": {
                    evt.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootHandler.getInjectEntry(entryName)).name("lootbagmod_inject").func_216044_b();
    }

    private static LootEntry.Builder getInjectEntry(String name) {
        ResourceLocation table = new ResourceLocation("lootbagmod", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMobDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            System.out.print("testing");
            String entityName = event.getEntity().func_200600_R().getRegistryName().toString();
            int dropchance = rand.nextInt(100);
            int testchance = (Integer)LootBagConfig.dropchance.get();
            if (((List)LootBagConfig.MobList.get()).contains(entityName)) {
                if (((Boolean)LootBagConfig.debugmode.get()).booleanValue()) {
                    DebugUtils.debugMessage(entityName);
                    DebugUtils.debugMessage(" " + dropchance + "   " + testchance);
                    DebugUtils.debugMessage("Mob was selected from list");
                }
                if (event.getLootingLevel() != 0) {
                    if (dropchance <= testchance * event.getLootingLevel() / 2) {
                        event.getDrops().add(new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70142_S, event.getEntityLiving().field_70137_T, event.getEntityLiving().field_70136_U, new ItemStack((IItemProvider)Registration.lootbag.get())));
                    }
                } else if (dropchance <= testchance) {
                    event.getDrops().add(new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70142_S, event.getEntityLiving().field_70137_T, event.getEntityLiving().field_70136_U, new ItemStack((IItemProvider)Registration.lootbag.get())));
                }
            } else if (((Boolean)LootBagConfig.debugmode.get()).booleanValue()) {
                DebugUtils.debugMessage(entityName);
                DebugUtils.debugMessage(" " + dropchance + "   " + testchance);
                DebugUtils.debugMessage("Mob wasnt selected from list");
            }
        }
    }
}

