/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lotr.common.entity.npc.LOTREntityNPC;

public class LOTRSpeechClient {
    private static Map<UUID, TimedSpeech> npcSpeeches = new HashMap<UUID, TimedSpeech>();
    private static int DISPLAY_TIME = 200;

    public static void update() {
        HashMap<UUID, TimedSpeech> newMap = new HashMap<UUID, TimedSpeech>();
        for (Map.Entry<UUID, TimedSpeech> e : npcSpeeches.entrySet()) {
            UUID key = e.getKey();
            TimedSpeech speech = e.getValue();
            speech.time--;
            if (speech.time <= 0) continue;
            newMap.put(key, speech);
        }
        npcSpeeches = newMap;
    }

    public static void receiveSpeech(LOTREntityNPC npc, String speech) {
        npcSpeeches.put(npc.func_110124_au(), new TimedSpeech(speech, DISPLAY_TIME));
    }

    public static void removeSpeech(LOTREntityNPC npc) {
        npcSpeeches.remove(npc.func_110124_au());
    }

    public static TimedSpeech getSpeechFor(LOTREntityNPC npc) {
        UUID key = npc.func_110124_au();
        if (npcSpeeches.containsKey(key)) {
            return npcSpeeches.get(key);
        }
        return null;
    }

    public static boolean hasSpeech(LOTREntityNPC npc) {
        return LOTRSpeechClient.getSpeechFor(npc) != null;
    }

    public static void clearAll() {
        npcSpeeches.clear();
    }

    public static class TimedSpeech {
        private String speech;
        private int time;

        private TimedSpeech(String s, int i) {
            this.speech = s;
            this.time = i;
        }

        public String getSpeech() {
            return this.speech;
        }

        public float getAge() {
            return (float)this.time / (float)DISPLAY_TIME;
        }
    }
}

