/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.client.gui.LOTRGuiButtonRedBook;
import lotr.client.gui.LOTRGuiMap;
import lotr.client.gui.LOTRGuiRendererMap;
import lotr.common.world.map.LOTRWaypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class LOTRGuiMainMenu
extends GuiMainMenu {
    private static final ResourceLocation titleTexture = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation vignetteTexture = new ResourceLocation("textures/misc/vignette.png");
    private static final ResourceLocation menuOverlay = new ResourceLocation("lotr:gui/menu_overlay.png");
    private LOTRGuiMap mapGui;
    private static LOTRGuiRendererMap mapRenderer;
    private static int tickCounter;
    private static Random rand;
    private boolean fadeIn = isFirstMenu;
    private static boolean isFirstMenu;
    private long firstRenderTime;
    private static List<LOTRWaypoint> waypointRoute;
    private static int currentWPIndex;
    private static boolean randomWPStart;
    private static float mapSpeed;
    private static float mapVelX;
    private static float mapVelY;
    private static final float wpChangeDistance = 12.0f;
    private static final float mapSpeedMax = 0.8f;
    private static final float mapSpeedIncr = 0.01f;
    private static final float mapAccel = 0.02f;
    private static final float zoomBase = -0.1f;
    private static final float zoomOscilSpeed = 0.003f;
    private static final float zoomOscilMax = 0.8f;

    public LOTRGuiMainMenu() {
        isFirstMenu = false;
        this.mapGui = new LOTRGuiMap();
        mapRenderer = new LOTRGuiRendererMap();
        mapRenderer.setSepia(false);
        if (waypointRoute.isEmpty()) {
            LOTRGuiMainMenu.setupWaypoints();
            currentWPIndex = randomWPStart ? rand.nextInt(waypointRoute.size()) : 0;
        }
        LOTRWaypoint wp = waypointRoute.get(currentWPIndex);
        LOTRGuiMainMenu.mapRenderer.prevMapX = LOTRGuiMainMenu.mapRenderer.mapX = (float)wp.getX();
        LOTRGuiMainMenu.mapRenderer.prevMapY = LOTRGuiMainMenu.mapRenderer.mapY = (float)wp.getY();
    }

    private static void setupWaypoints() {
        waypointRoute.clear();
        waypointRoute.add(LOTRWaypoint.HOBBITON);
        waypointRoute.add(LOTRWaypoint.BRANDYWINE_BRIDGE);
        waypointRoute.add(LOTRWaypoint.BUCKLEBURY);
        waypointRoute.add(LOTRWaypoint.WITHYWINDLE_VALLEY);
        waypointRoute.add(LOTRWaypoint.BREE);
        waypointRoute.add(LOTRWaypoint.WEATHERTOP);
        waypointRoute.add(LOTRWaypoint.RIVENDELL);
        waypointRoute.add(LOTRWaypoint.WEST_GATE);
        waypointRoute.add(LOTRWaypoint.DIMRILL_DALE);
        waypointRoute.add(LOTRWaypoint.CERIN_AMROTH);
        waypointRoute.add(LOTRWaypoint.CARAS_GALADHON);
        waypointRoute.add(LOTRWaypoint.NORTH_UNDEEP);
        waypointRoute.add(LOTRWaypoint.SOUTH_UNDEEP);
        waypointRoute.add(LOTRWaypoint.ARGONATH);
        waypointRoute.add(LOTRWaypoint.RAUROS);
        waypointRoute.add(LOTRWaypoint.EDORAS);
        waypointRoute.add(LOTRWaypoint.HELMS_DEEP);
        waypointRoute.add(LOTRWaypoint.ISENGARD);
        waypointRoute.add(LOTRWaypoint.DUNHARROW);
        waypointRoute.add(LOTRWaypoint.ERECH);
        waypointRoute.add(LOTRWaypoint.MINAS_TIRITH);
        waypointRoute.add(LOTRWaypoint.MINAS_MORGUL);
        waypointRoute.add(LOTRWaypoint.MOUNT_DOOM);
        waypointRoute.add(LOTRWaypoint.MORANNON);
        waypointRoute.add(LOTRWaypoint.EAST_RHOVANION_ROAD);
        waypointRoute.add(LOTRWaypoint.OLD_RHOVANION);
        waypointRoute.add(LOTRWaypoint.RUNNING_FORD);
        waypointRoute.add(LOTRWaypoint.DALE_CITY);
        waypointRoute.add(LOTRWaypoint.THRANDUIL_HALLS);
        waypointRoute.add(LOTRWaypoint.ENCHANTED_RIVER);
        waypointRoute.add(LOTRWaypoint.FOREST_GATE);
        waypointRoute.add(LOTRWaypoint.BEORN);
        waypointRoute.add(LOTRWaypoint.EAGLES_EYRIE);
        waypointRoute.add(LOTRWaypoint.GOBLIN_TOWN);
        waypointRoute.add(LOTRWaypoint.MOUNT_GRAM);
        waypointRoute.add(LOTRWaypoint.FORNOST);
        waypointRoute.add(LOTRWaypoint.ANNUMINAS);
        waypointRoute.add(LOTRWaypoint.MITHLOND_NORTH);
        waypointRoute.add(LOTRWaypoint.TOWER_HILLS);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int lowerButtonMaxY = 0;
        for (Object obj : this.field_146292_n) {
            GuiButton button = (GuiButton)obj;
            int buttonMaxY = button.field_146129_i + button.field_146121_g;
            if (buttonMaxY <= lowerButtonMaxY) continue;
            lowerButtonMaxY = buttonMaxY;
        }
        int idealMoveDown = 50;
        int lowestSuitableHeight = this.field_146295_m - 25;
        int moveDown = Math.min(idealMoveDown, lowestSuitableHeight - lowerButtonMaxY);
        moveDown = Math.max(moveDown, 0);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            button.field_146129_i += moveDown;
            if (button.getClass() != GuiButton.class) continue;
            LOTRGuiButtonRedBook newButton = new LOTRGuiButtonRedBook(button.field_146127_k, button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, button.field_146126_j);
            this.field_146292_n.set(i, newButton);
        }
    }

    public void func_146280_a(Minecraft mc, int i, int j) {
        super.func_146280_a(mc, i, j);
        this.mapGui.func_146280_a(mc, i, j);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++tickCounter;
        mapRenderer.updateTick();
        LOTRWaypoint wp = waypointRoute.get(currentWPIndex);
        float dx = (float)wp.getX() - LOTRGuiMainMenu.mapRenderer.mapX;
        float dy = (float)wp.getY() - LOTRGuiMainMenu.mapRenderer.mapY;
        float distSq = dx * dx + dy * dy;
        float dist = (float)Math.sqrt(distSq);
        if (dist <= 12.0f) {
            if (++currentWPIndex >= waypointRoute.size()) {
                currentWPIndex = 0;
            }
        } else {
            mapSpeed += 0.01f;
            mapSpeed = Math.min(mapSpeed, 0.8f);
            float vXNew = dx / dist * mapSpeed;
            float vYNew = dy / dist * mapSpeed;
            float a = 0.02f;
            mapVelX += (vXNew - mapVelX) * a;
            mapVelY += (vYNew - mapVelY) * a;
        }
        LOTRGuiMainMenu.mapRenderer.mapX += mapVelX;
        LOTRGuiMainMenu.mapRenderer.mapY += mapVelY;
    }

    public void func_73863_a(int i, int j, float f) {
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (this.firstRenderTime == 0L && this.fadeIn) {
            this.firstRenderTime = System.currentTimeMillis();
        }
        float fade = this.fadeIn ? (float)(System.currentTimeMillis() - this.firstRenderTime) / 1000.0f : 1.0f;
        float fadeAlpha = this.fadeIn ? MathHelper.func_76131_a((float)(fade - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        LOTRGuiMainMenu.mapRenderer.zoomExp = -0.1f + MathHelper.func_76134_b((float)(((float)tickCounter + f) * 0.003f)) * 0.8f;
        if (this.fadeIn) {
            float slowerFade = fade * 0.5f;
            float fadeInZoom = MathHelper.func_76131_a((float)(1.0f - slowerFade), (float)0.0f, (float)1.0f) * -1.5f;
            LOTRGuiMainMenu.mapRenderer.zoomExp += fadeInZoom;
        }
        LOTRGuiMainMenu.mapRenderer.zoomStable = (float)Math.pow(2.0, -0.1f);
        mapRenderer.renderMap((GuiScreen)this, this.mapGui, f);
        mapRenderer.renderVignettes((GuiScreen)this, this.field_73735_i, 2);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fadeIn ? MathHelper.func_76131_a((float)(1.0f - fade), (float)0.0f, (float)1.0f) : 0.0f));
        this.field_146297_k.func_110434_K().func_110577_a(menuOverlay);
        LOTRGuiMainMenu.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)this.field_146294_l, (int)this.field_146295_m, (float)16.0f, (float)128.0f);
        int fadeAlphaI = MathHelper.func_76123_f((float)(fadeAlpha * 255.0f)) << 24;
        if ((fadeAlphaI & 0xFC000000) != 0) {
            Tessellator tessellator = Tessellator.field_78398_a;
            int short1 = 274;
            int k = this.field_146294_l / 2 - short1 / 2;
            int b0 = 30;
            this.field_146297_k.func_110434_K().func_110577_a(titleTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeAlpha);
            this.func_73729_b(k + 0, b0 + 0, 0, 0, 155, 44);
            this.func_73729_b(k + 155, b0 + 0, 0, 45, 155, 44);
            String modSubtitle = StatCollector.func_74838_a((String)"lotr.menu.title");
            this.func_73731_b(this.field_146289_q, modSubtitle, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(modSubtitle) / 2, 80, -1);
            List brandings = Lists.reverse((List)FMLCommonHandler.instance().getBrandings(true));
            for (int l = 0; l < brandings.size(); ++l) {
                String brd = (String)brandings.get(l);
                if (Strings.isNullOrEmpty((String)brd)) continue;
                this.func_73731_b(this.field_146289_q, brd, 2, this.field_146295_m - (10 + l * (this.field_146289_q.field_78288_b + 1)), -1);
            }
            ForgeHooksClient.renderMainMenu((GuiMainMenu)this, (FontRenderer)this.field_146289_q, (int)this.field_146294_l, (int)this.field_146295_m);
            String copyright = "Copyright Mojang AB. Do not distribute!";
            this.func_73731_b(this.field_146289_q, copyright, this.field_146294_l - this.field_146289_q.func_78256_a(copyright) - 2, this.field_146295_m - 10, -1);
            String field_92025_p = (String)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92025_p"});
            String field_146972_A = (String)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_146972_A"});
            int field_92024_r = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92024_r"});
            int field_92022_t = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92022_t"});
            int field_92021_u = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92021_u"});
            int field_92020_v = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92020_v"});
            int field_92019_w = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiMainMenu.class, (Object)((Object)this), (String[])new String[]{"field_92019_w"});
            if (field_92025_p != null && field_92025_p.length() > 0) {
                LOTRGuiMainMenu.func_73734_a((int)(field_92022_t - 2), (int)(field_92021_u - 2), (int)(field_92020_v + 2), (int)(field_92019_w - 1), (int)0x55200000);
                this.func_73731_b(this.field_146289_q, field_92025_p, field_92022_t, field_92021_u, -1);
                this.func_73731_b(this.field_146289_q, field_146972_A, (this.field_146294_l - field_92024_r) / 2, ((GuiButton)this.field_146292_n.get((int)0)).field_146129_i - 12, -1);
            }
            for (Object button : this.field_146292_n) {
                ((GuiButton)button).func_146112_a(this.field_146297_k, i, j);
            }
            for (Object label : this.field_146293_o) {
                ((GuiLabel)label).func_146159_a(this.field_146297_k, i, j);
            }
        }
    }

    static {
        rand = new Random();
        isFirstMenu = true;
        waypointRoute = new ArrayList<LOTRWaypoint>();
        randomWPStart = false;
    }
}

