/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.sound;

import java.util.Random;
import lotr.client.LOTRClientProxy;
import lotr.client.sound.LOTRMusic;
import lotr.client.sound.LOTRMusicCategory;
import lotr.client.sound.LOTRMusicTrack;
import lotr.client.sound.LOTRRegionTrackPool;
import lotr.client.sound.LOTRTrackSorter;
import lotr.common.LOTRConfig;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRMusicRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTRMusicTicker {
    public static LOTRMusicTrack currentTrack;
    private static boolean wasPlayingMenu;
    private static final int firstTiming = 100;
    private static int timing;
    private static final int nullTrackResetTiming = 400;

    public static void update(Random rand) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean noMusic = mc.field_71474_y.func_151438_a(SoundCategory.MUSIC) <= 0.0f;
        boolean menu = LOTRMusic.isMenuMusic();
        if (wasPlayingMenu != menu) {
            if (currentTrack != null) {
                mc.func_147118_V().func_147683_b((ISound)currentTrack);
                currentTrack = null;
            }
            wasPlayingMenu = menu;
            timing = 100;
        }
        if (currentTrack != null) {
            if (noMusic) {
                mc.func_147118_V().func_147683_b((ISound)currentTrack);
            }
            if (!mc.func_147118_V().func_147692_c((ISound)currentTrack)) {
                currentTrack = null;
                LOTRMusicTicker.resetTiming(rand);
            }
        }
        if (!noMusic) {
            boolean update = false;
            if (menu) {
                update = true;
            } else {
                boolean bl = update = LOTRMusic.isLOTRDimension() && !Minecraft.func_71410_x().func_147113_T();
            }
            if (update && currentTrack == null && --timing <= 0) {
                currentTrack = LOTRMusicTicker.getNewTrack(mc, rand);
                if (currentTrack != null) {
                    wasPlayingMenu = menu;
                    mc.func_147118_V().func_147682_a((ISound)currentTrack);
                    timing = Integer.MAX_VALUE;
                } else {
                    timing = 400;
                }
            }
        }
    }

    private static void resetTiming(Random rand) {
        timing = LOTRMusic.isMenuMusic() ? MathHelper.func_76136_a((Random)rand, (int)(LOTRConfig.musicIntervalMenuMin * 20), (int)(LOTRConfig.musicIntervalMenuMax * 20)) : MathHelper.func_76136_a((Random)rand, (int)(LOTRConfig.musicIntervalMin * 20), (int)(LOTRConfig.musicIntervalMax * 20));
    }

    private static LOTRMusicTrack getNewTrack(Minecraft mc, Random rand) {
        LOTRMusicRegion.Sub regionSub = LOTRMusicTicker.getCurrentRegion(mc, rand);
        LOTRMusicCategory category = LOTRMusicTicker.getCurrentCategory(mc, rand);
        if (regionSub != null) {
            LOTRMusicRegion region = regionSub.region;
            String sub = regionSub.subregion;
            LOTRTrackSorter.Filter filter = category != null ? LOTRTrackSorter.forRegionAndCategory(region, category) : LOTRTrackSorter.forAny();
            LOTRRegionTrackPool trackPool = LOTRMusic.getTracksForRegion(region, sub);
            return trackPool.getRandomTrack(rand, filter);
        }
        return null;
    }

    private static LOTRMusicRegion.Sub getCurrentRegion(Minecraft mc, Random rand) {
        BiomeGenBase biome;
        int k;
        int i;
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        if (LOTRMusic.isMenuMusic()) {
            return LOTRMusicRegion.MENU.getWithoutSub();
        }
        if (LOTRMusic.isLOTRDimension() && LOTRClientProxy.doesClientChunkExist((World)world, i = MathHelper.func_76128_c((double)entityplayer.field_70165_t), k = MathHelper.func_76128_c((double)entityplayer.field_70161_v)) && (biome = world.func_72807_a(i, k)) instanceof LOTRBiome) {
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            LOTRMusicRegion.Sub region = lotrbiome.getBiomeMusic();
            return region;
        }
        return null;
    }

    private static LOTRMusicCategory getCurrentCategory(Minecraft mc, Random rand) {
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        if (world != null && entityplayer != null) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
            if (LOTRMusicCategory.isCave((World)world, i, j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)entityplayer.field_70161_v))) {
                return LOTRMusicCategory.CAVE;
            }
            if (LOTRMusicCategory.isDay((World)world)) {
                return LOTRMusicCategory.DAY;
            }
            return LOTRMusicCategory.NIGHT;
        }
        return null;
    }

    static {
        wasPlayingMenu = true;
        timing = 100;
    }
}

