/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.sound;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lotr.client.sound.LOTRMusic;
import lotr.client.sound.LOTRMusicCategory;
import lotr.client.sound.LOTRTrackRegionInfo;
import lotr.common.world.biome.LOTRMusicRegion;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.util.ResourceLocation;

public class LOTRMusicTrack
extends PositionedSound {
    private final String filename;
    private String title;
    private Map<LOTRMusicRegion, LOTRTrackRegionInfo> regions = new HashMap<LOTRMusicRegion, LOTRTrackRegionInfo>();
    private List<String> authors = new ArrayList<String>();

    public LOTRMusicTrack(String s) {
        super(LOTRMusicTrack.getMusicResource(s));
        this.field_147662_b = 1.0f;
        this.field_147663_c = 1.0f;
        this.field_147660_d = 0.0f;
        this.field_147661_e = 0.0f;
        this.field_147658_f = 0.0f;
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.filename = s;
    }

    private static ResourceLocation getMusicResource(String s) {
        ResourceLocation res = new ResourceLocation("lotrmusic", s);
        return res;
    }

    public void loadTrack(InputStream in) throws IOException {
        this.loadSoundResource();
        LOTRMusic.addTrackToRegions(this);
    }

    private void loadSoundResource() {
        SoundEventAccessorComposite soundAccessorComp;
        ResourceLocation resource = this.func_147650_b();
        SoundList soundList = new SoundList();
        soundList.func_148572_a(true);
        soundList.func_148571_a(SoundCategory.MUSIC);
        SoundList.SoundEntry soundEntry = new SoundList.SoundEntry();
        soundEntry.func_148561_a(this.filename);
        soundEntry.func_148553_a(this.func_147653_e());
        soundEntry.func_148559_b(this.func_147655_f());
        soundEntry.func_148554_a(1);
        soundEntry.func_148562_a(SoundList.SoundEntry.Type.SOUND_EVENT);
        soundEntry.func_148557_a(true);
        soundList.func_148570_a().add(soundEntry);
        SoundRegistry sndRegistry = LOTRMusic.Reflect.getSoundRegistry();
        if (sndRegistry.func_148741_d((Object)resource) && !soundList.func_148574_b()) {
            soundAccessorComp = (SoundEventAccessorComposite)sndRegistry.func_82594_a((Object)resource);
        } else {
            soundAccessorComp = new SoundEventAccessorComposite(resource, 1.0, 1.0, soundList.func_148573_c());
            sndRegistry.func_148762_a(soundAccessorComp);
        }
        SoundPoolEntry soundPoolEntry = new SoundPoolEntry(resource, (double)soundEntry.func_148560_c(), (double)soundEntry.func_148558_b(), soundEntry.func_148552_f());
        TrackSoundAccessor soundAccessor = new TrackSoundAccessor(soundPoolEntry, soundEntry.func_148555_d());
        soundAccessorComp.func_148727_a((ISoundEventAccessor)soundAccessor);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.filename;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public Set<LOTRMusicRegion> getAllRegions() {
        return this.regions.keySet();
    }

    public LOTRTrackRegionInfo createRegionInfo(LOTRMusicRegion reg) {
        LOTRTrackRegionInfo info = this.regions.get((Object)reg);
        if (info == null) {
            info = new LOTRTrackRegionInfo(reg);
            this.regions.put(reg, info);
        }
        return info;
    }

    public LOTRTrackRegionInfo getRegionInfo(LOTRMusicRegion reg) {
        if (this.regions.containsKey((Object)reg)) {
            return this.regions.get((Object)reg);
        }
        return null;
    }

    public void addAuthor(String s) {
        this.authors.add(s);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String[] getTrackInfo() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Title: " + this.getTitle());
        list.add("Filename: " + this.getFilename());
        list.add("Regions:");
        for (LOTRMusicRegion reg : this.getAllRegions()) {
            List<LOTRMusicCategory> categories;
            LOTRTrackRegionInfo info = this.getRegionInfo(reg);
            list.add(">" + reg.regionName);
            list.add(">Weight: " + info.getWeight());
            List<String> subs = info.getSubregions();
            if (!subs.isEmpty()) {
                list.add(">Subregions:");
                for (String s : subs) {
                    list.add(">>" + s);
                }
            }
            if ((categories = info.getCategories()).isEmpty()) continue;
            list.add(">Categories:");
            for (LOTRMusicCategory cat : categories) {
                list.add(">>" + cat.categoryName);
            }
        }
        list.add("Authors:");
        for (String auth : this.getAuthors()) {
            list.add(">" + auth);
        }
        return list.toArray(new String[0]);
    }

    private static class TrackSoundAccessor
    implements ISoundEventAccessor {
        private final SoundPoolEntry soundEntry;
        private final int weight;

        private TrackSoundAccessor(SoundPoolEntry e, int i) {
            this.soundEntry = e;
            this.weight = i;
        }

        public int func_148721_a() {
            return this.weight;
        }

        public SoundPoolEntry func_148720_g() {
            return new SoundPoolEntry(this.soundEntry);
        }
    }
}

