/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.google.common.base.Supplier;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDimension;
import lotr.common.LOTRGuiMessageTypes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerQuestData;
import lotr.common.LOTRShields;
import lotr.common.LOTRTitle;
import lotr.common.block.LOTRBlockCraftingTable;
import lotr.common.command.LOTRCommandAdminHideMap;
import lotr.common.entity.npc.LOTREntityGollum;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRAlignmentBonusMap;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.fac.LOTRFactionData;
import lotr.common.fac.LOTRFactionRank;
import lotr.common.fellowship.FellowshipUpdateType;
import lotr.common.fellowship.LOTRFellowship;
import lotr.common.fellowship.LOTRFellowshipClient;
import lotr.common.fellowship.LOTRFellowshipData;
import lotr.common.fellowship.LOTRFellowshipInvite;
import lotr.common.item.LOTRItemArmor;
import lotr.common.item.LOTRItemCrossbowBolt;
import lotr.common.item.LOTRMaterial;
import lotr.common.network.LOTRPacketAchievement;
import lotr.common.network.LOTRPacketAchievementRemove;
import lotr.common.network.LOTRPacketAlignDrain;
import lotr.common.network.LOTRPacketAlignmentBonus;
import lotr.common.network.LOTRPacketAlignmentChoiceOffer;
import lotr.common.network.LOTRPacketBrokenPledge;
import lotr.common.network.LOTRPacketCWPSharedHideClient;
import lotr.common.network.LOTRPacketCWPSharedUnlockClient;
import lotr.common.network.LOTRPacketCreateCWPClient;
import lotr.common.network.LOTRPacketDeleteCWPClient;
import lotr.common.network.LOTRPacketFTBounceClient;
import lotr.common.network.LOTRPacketFTScreen;
import lotr.common.network.LOTRPacketFTTimer;
import lotr.common.network.LOTRPacketFactionData;
import lotr.common.network.LOTRPacketFellowship;
import lotr.common.network.LOTRPacketFellowshipPartialUpdate;
import lotr.common.network.LOTRPacketFellowshipRemove;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketLoginPlayerData;
import lotr.common.network.LOTRPacketMessage;
import lotr.common.network.LOTRPacketMiniquest;
import lotr.common.network.LOTRPacketMiniquestRemove;
import lotr.common.network.LOTRPacketMiniquestTrackClient;
import lotr.common.network.LOTRPacketOptions;
import lotr.common.network.LOTRPacketPledge;
import lotr.common.network.LOTRPacketRenameCWPClient;
import lotr.common.network.LOTRPacketShareCWPClient;
import lotr.common.network.LOTRPacketTitle;
import lotr.common.network.LOTRPacketUpdateViewingFaction;
import lotr.common.network.LOTRPacketWaypointRegion;
import lotr.common.network.LOTRPacketWaypointUseCount;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestEvent;
import lotr.common.quest.LOTRMiniQuestWelcome;
import lotr.common.quest.MiniQuestSelector;
import lotr.common.util.LOTRLog;
import lotr.common.world.LOTRUtumnoLevel;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import lotr.common.world.map.LOTRAbstractWaypoint;
import lotr.common.world.map.LOTRConquestGrid;
import lotr.common.world.map.LOTRCustomWaypoint;
import lotr.common.world.map.LOTRCustomWaypointLogger;
import lotr.common.world.map.LOTRWaypoint;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRPlayerData {
    private UUID playerUUID;
    private boolean needsSave = false;
    private int pdTick = 0;
    private Map<LOTRFaction, Float> alignments = new HashMap<LOTRFaction, Float>();
    private Map<LOTRFaction, LOTRFactionData> factionDataMap = new HashMap<LOTRFaction, LOTRFactionData>();
    private LOTRFaction viewingFaction;
    private Map<LOTRDimension.DimensionRegion, LOTRFaction> prevRegionFactions = new HashMap<LOTRDimension.DimensionRegion, LOTRFaction>();
    private boolean hideAlignment = false;
    private Set<LOTRFaction> takenAlignmentRewards = new HashSet<LOTRFaction>();
    private LOTRFaction pledgeFaction;
    private int pledgeKillCooldown = 0;
    public static final int PLEDGE_KILL_COOLDOWN_MAX = 24000;
    private int pledgeBreakCooldown;
    private int pledgeBreakCooldownStart;
    private LOTRFaction brokenPledgeFaction = null;
    private boolean hasPre35Alignments = false;
    private boolean chosenUnwantedAlignments = false;
    private boolean hideOnMap = false;
    private boolean adminHideMap = false;
    private boolean showWaypoints = true;
    private boolean showCustomWaypoints = true;
    private boolean showHiddenSharedWaypoints = true;
    private boolean conquestKills = true;
    private List<LOTRAchievement> achievements = new ArrayList<LOTRAchievement>();
    private LOTRShields shield;
    private boolean friendlyFire = false;
    private boolean hiredDeathMessages = true;
    private ChunkCoordinates deathPoint;
    private int deathDim;
    private int alcoholTolerance;
    private List<LOTRMiniQuest> miniQuests = new ArrayList<LOTRMiniQuest>();
    private List<LOTRMiniQuest> miniQuestsCompleted = new ArrayList<LOTRMiniQuest>();
    private int completedMiniquestCount;
    private int completedBountyQuests;
    private UUID trackingMiniQuestID;
    private List<LOTRFaction> bountiesPlaced = new ArrayList<LOTRFaction>();
    private LOTRWaypoint lastWaypoint;
    private LOTRBiome lastBiome;
    private Map<LOTRGuiMessageTypes, Boolean> sentMessageTypes = new HashMap<LOTRGuiMessageTypes, Boolean>();
    private LOTRTitle.PlayerTitle playerTitle;
    private boolean femRankOverride = false;
    private int ftSinceTick;
    private LOTRAbstractWaypoint targetFTWaypoint;
    private int ticksUntilFT;
    private static int ticksUntilFT_max = 200;
    private UUID uuidToMount;
    private int uuidToMountTime;
    private Set<LOTRWaypoint.Region> unlockedFTRegions = new HashSet<LOTRWaypoint.Region>();
    private List<LOTRCustomWaypoint> customWaypoints = new ArrayList<LOTRCustomWaypoint>();
    private List<LOTRCustomWaypoint> customWaypointsShared = new ArrayList<LOTRCustomWaypoint>();
    private Set<CWPSharedKey> cwpSharedUnlocked = new HashSet<CWPSharedKey>();
    private Set<CWPSharedKey> cwpSharedHidden = new HashSet<CWPSharedKey>();
    private Map<LOTRWaypoint, Integer> wpUseCounts = new HashMap<LOTRWaypoint, Integer>();
    private Map<Integer, Integer> cwpUseCounts = new HashMap<Integer, Integer>();
    private Map<CWPSharedKey, Integer> cwpSharedUseCounts = new HashMap<CWPSharedKey, Integer>();
    private static int startCwpID = 20000;
    private int nextCwpID = startCwpID;
    private List<UUID> fellowshipIDs = new ArrayList<UUID>();
    private List<LOTRFellowshipClient> fellowshipsClient = new ArrayList<LOTRFellowshipClient>();
    private List<LOTRFellowshipInvite> fellowshipInvites = new ArrayList<LOTRFellowshipInvite>();
    private List<LOTRFellowshipClient> fellowshipInvitesClient = new ArrayList<LOTRFellowshipClient>();
    private UUID chatBoundFellowshipID;
    private boolean structuresBanned = false;
    private boolean teleportedME = false;
    private LOTRPlayerQuestData questData = new LOTRPlayerQuestData(this);
    private int siegeActiveTime;

    public LOTRPlayerData(UUID uuid) {
        this.playerUUID = uuid;
        this.viewingFaction = LOTRFaction.HOBBIT;
        this.ftSinceTick = LOTRLevelData.getWaypointCooldownMax() * 20;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    private EntityPlayer getPlayer() {
        Object[] searchWorlds = null;
        searchWorlds = LOTRMod.proxy.isClient() ? new World[]{LOTRMod.proxy.getClientWorld()} : MinecraftServer.func_71276_C().field_71305_c;
        for (WorldServer world : searchWorlds) {
            EntityPlayer entityplayer = world.func_152378_a(this.playerUUID);
            if (entityplayer == null) continue;
            return entityplayer;
        }
        return null;
    }

    private EntityPlayer getOtherPlayer(UUID uuid) {
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            EntityPlayer entityplayer = world.func_152378_a(uuid);
            if (entityplayer == null) continue;
            return entityplayer;
        }
        return null;
    }

    public void markDirty() {
        this.needsSave = true;
    }

    public boolean needsSave() {
        return this.needsSave;
    }

    public void save(NBTTagCompound playerData) {
        NBTTagCompound nbt;
        NBTTagList alignmentTags = new NBTTagList();
        for (Map.Entry<LOTRFaction, Float> entry : this.alignments.entrySet()) {
            LOTRFaction lOTRFaction = entry.getKey();
            float f = entry.getValue().floatValue();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Faction", lOTRFaction.codeName());
            nBTTagCompound.func_74776_a("AlignF", f);
            alignmentTags.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("AlignmentMap", (NBTBase)alignmentTags);
        NBTTagList factionDataTags = new NBTTagList();
        for (Map.Entry<LOTRFaction, LOTRFactionData> entry : this.factionDataMap.entrySet()) {
            LOTRFaction lOTRFaction = entry.getKey();
            LOTRFactionData lOTRFactionData = entry.getValue();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Faction", lOTRFaction.codeName());
            lOTRFactionData.save(nBTTagCompound);
            factionDataTags.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("FactionData", (NBTBase)factionDataTags);
        playerData.func_74778_a("CurrentFaction", this.viewingFaction.codeName());
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<LOTRDimension.DimensionRegion, LOTRFaction> entry : this.prevRegionFactions.entrySet()) {
            LOTRDimension.DimensionRegion dimensionRegion = entry.getKey();
            LOTRFaction lOTRFaction = entry.getValue();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Region", dimensionRegion.codeName());
            nBTTagCompound.func_74778_a("Faction", lOTRFaction.codeName());
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("PrevRegionFactions", (NBTBase)nBTTagList);
        playerData.func_74757_a("HideAlignment", this.hideAlignment);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (LOTRFaction lOTRFaction : this.takenAlignmentRewards) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Faction", lOTRFaction.codeName());
            nBTTagList2.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("TakenAlignmentRewards", (NBTBase)nBTTagList2);
        if (this.pledgeFaction != null) {
            playerData.func_74778_a("PledgeFac", this.pledgeFaction.codeName());
        }
        playerData.func_74768_a("PledgeKillCD", this.pledgeKillCooldown);
        playerData.func_74768_a("PledgeBreakCD", this.pledgeBreakCooldown);
        playerData.func_74768_a("PledgeBreakCDStart", this.pledgeBreakCooldownStart);
        if (this.brokenPledgeFaction != null) {
            playerData.func_74778_a("BrokenPledgeFac", this.brokenPledgeFaction.codeName());
        }
        playerData.func_74757_a("Pre35Align", this.hasPre35Alignments);
        playerData.func_74757_a("Chosen35Align", this.chosenUnwantedAlignments);
        playerData.func_74757_a("HideOnMap", this.hideOnMap);
        playerData.func_74757_a("AdminHideMap", this.adminHideMap);
        playerData.func_74757_a("ShowWP", this.showWaypoints);
        playerData.func_74757_a("ShowCWP", this.showCustomWaypoints);
        playerData.func_74757_a("ShowHiddenSWP", this.showHiddenSharedWaypoints);
        playerData.func_74757_a("ConquestKills", this.conquestKills);
        NBTTagList nBTTagList3 = new NBTTagList();
        for (LOTRAchievement lOTRAchievement : this.achievements) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Category", lOTRAchievement.category.name());
            nBTTagCompound.func_74768_a("ID", lOTRAchievement.ID);
            nBTTagList3.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("Achievements", (NBTBase)nBTTagList3);
        if (this.shield != null) {
            playerData.func_74778_a("Shield", this.shield.name());
        }
        playerData.func_74757_a("FriendlyFire", this.friendlyFire);
        playerData.func_74757_a("HiredDeathMessages", this.hiredDeathMessages);
        if (this.deathPoint != null) {
            playerData.func_74768_a("DeathX", this.deathPoint.field_71574_a);
            playerData.func_74768_a("DeathY", this.deathPoint.field_71572_b);
            playerData.func_74768_a("DeathZ", this.deathPoint.field_71573_c);
            playerData.func_74768_a("DeathDim", this.deathDim);
        }
        playerData.func_74768_a("Alcohol", this.alcoholTolerance);
        NBTTagList nBTTagList4 = new NBTTagList();
        for (LOTRMiniQuest lOTRMiniQuest : this.miniQuests) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            lOTRMiniQuest.writeToNBT(nBTTagCompound);
            nBTTagList4.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("MiniQuests", (NBTBase)nBTTagList4);
        NBTTagList nBTTagList5 = new NBTTagList();
        for (LOTRMiniQuest lOTRMiniQuest : this.miniQuestsCompleted) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            lOTRMiniQuest.writeToNBT(nBTTagCompound);
            nBTTagList5.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("MiniQuestsCompleted", (NBTBase)nBTTagList5);
        playerData.func_74768_a("MQCompleteCount", this.completedMiniquestCount);
        playerData.func_74768_a("MQCompletedBounties", this.completedBountyQuests);
        if (this.trackingMiniQuestID != null) {
            playerData.func_74778_a("MiniQuestTrack", this.trackingMiniQuestID.toString());
        }
        NBTTagList nBTTagList6 = new NBTTagList();
        for (LOTRFaction lOTRFaction : this.bountiesPlaced) {
            String string = lOTRFaction.codeName();
            nBTTagList6.func_74742_a((NBTBase)new NBTTagString(string));
        }
        playerData.func_74782_a("BountiesPlaced", (NBTBase)nBTTagList6);
        if (this.lastWaypoint != null) {
            String string = this.lastWaypoint.getCodeName();
            playerData.func_74778_a("LastWP", string);
        }
        if (this.lastBiome != null) {
            int n = this.lastBiome.field_76756_M;
            playerData.func_74777_a("LastBiome", (short)n);
        }
        NBTTagList nBTTagList7 = new NBTTagList();
        for (Map.Entry<LOTRGuiMessageTypes, Boolean> entry : this.sentMessageTypes.entrySet()) {
            LOTRGuiMessageTypes lOTRGuiMessageTypes = entry.getKey();
            boolean sent = entry.getValue();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("Message", lOTRGuiMessageTypes.getSaveName());
            nBTTagCompound.func_74757_a("Sent", sent);
            nBTTagList7.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("SentMessageTypes", (NBTBase)nBTTagList7);
        if (this.playerTitle != null) {
            playerData.func_74778_a("PlayerTitle", this.playerTitle.getTitle().getTitleName());
            playerData.func_74768_a("PlayerTitleColor", (int)this.playerTitle.getColor().func_96298_a());
        }
        playerData.func_74757_a("FemRankOverride", this.femRankOverride);
        playerData.func_74768_a("FTSince", this.ftSinceTick);
        if (this.uuidToMount != null) {
            playerData.func_74778_a("MountUUID", this.uuidToMount.toString());
        }
        playerData.func_74768_a("MountUUIDTime", this.uuidToMountTime);
        NBTTagList nBTTagList8 = new NBTTagList();
        for (LOTRWaypoint.Region region : this.unlockedFTRegions) {
            NBTTagCompound nbt8 = new NBTTagCompound();
            nbt8.func_74778_a("Name", region.name());
            nBTTagList8.func_74742_a((NBTBase)nbt8);
        }
        playerData.func_74782_a("UnlockedFTRegions", (NBTBase)nBTTagList8);
        NBTTagList nBTTagList9 = new NBTTagList();
        for (LOTRCustomWaypoint waypoint : this.customWaypoints) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            waypoint.writeToNBT(nBTTagCompound, this);
            nBTTagList9.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("CustomWaypoints", (NBTBase)nBTTagList9);
        NBTTagList nBTTagList10 = new NBTTagList();
        for (CWPSharedKey cWPSharedKey : this.cwpSharedUnlocked) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("SharingPlayer", cWPSharedKey.sharingPlayer.toString());
            nBTTagCompound.func_74768_a("CustomID", cWPSharedKey.waypointID);
            nBTTagList10.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("CWPSharedUnlocked", (NBTBase)nBTTagList10);
        NBTTagList cwpSharedHiddenTags = new NBTTagList();
        for (CWPSharedKey cWPSharedKey : this.cwpSharedHidden) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("SharingPlayer", cWPSharedKey.sharingPlayer.toString());
            nBTTagCompound.func_74768_a("CustomID", cWPSharedKey.waypointID);
            cwpSharedHiddenTags.func_74742_a((NBTBase)nBTTagCompound);
        }
        playerData.func_74782_a("CWPSharedHidden", (NBTBase)cwpSharedHiddenTags);
        NBTTagList nBTTagList11 = new NBTTagList();
        for (Map.Entry<LOTRWaypoint, Integer> entry : this.wpUseCounts.entrySet()) {
            LOTRAbstractWaypoint lOTRAbstractWaypoint = entry.getKey();
            int n = entry.getValue();
            NBTTagCompound nbt11 = new NBTTagCompound();
            nbt11.func_74778_a("WPName", lOTRAbstractWaypoint.getCodeName());
            nbt11.func_74768_a("Count", n);
            nBTTagList11.func_74742_a((NBTBase)nbt11);
        }
        playerData.func_74782_a("WPUses", (NBTBase)nBTTagList11);
        NBTTagList nBTTagList12 = new NBTTagList();
        for (Map.Entry<Integer, Integer> entry : this.cwpUseCounts.entrySet()) {
            int n = entry.getKey();
            int count = entry.getValue();
            NBTTagCompound nbt12 = new NBTTagCompound();
            nbt12.func_74768_a("CustomID", n);
            nbt12.func_74768_a("Count", count);
            nBTTagList12.func_74742_a((NBTBase)nbt12);
        }
        playerData.func_74782_a("CWPUses", (NBTBase)nBTTagList12);
        NBTTagList nBTTagList13 = new NBTTagList();
        for (Map.Entry<CWPSharedKey, Integer> entry : this.cwpSharedUseCounts.entrySet()) {
            CWPSharedKey key = entry.getKey();
            int count = entry.getValue();
            nbt = new NBTTagCompound();
            nbt.func_74778_a("SharingPlayer", key.sharingPlayer.toString());
            nbt.func_74768_a("CustomID", key.waypointID);
            nbt.func_74768_a("Count", count);
            nBTTagList13.func_74742_a((NBTBase)nbt);
        }
        playerData.func_74782_a("CWPSharedUses", (NBTBase)nBTTagList13);
        playerData.func_74768_a("NextCWPID", this.nextCwpID);
        NBTTagList nBTTagList14 = new NBTTagList();
        for (UUID fsID : this.fellowshipIDs) {
            NBTTagCompound nbt13 = new NBTTagCompound();
            nbt13.func_74778_a("ID", fsID.toString());
            nBTTagList14.func_74742_a((NBTBase)nbt13);
        }
        playerData.func_74782_a("Fellowships", (NBTBase)nBTTagList14);
        NBTTagList nBTTagList15 = new NBTTagList();
        for (LOTRFellowshipInvite invite : this.fellowshipInvites) {
            nbt = new NBTTagCompound();
            nbt.func_74778_a("ID", invite.fellowshipID.toString());
            if (invite.inviterID != null) {
                nbt.func_74778_a("InviterID", invite.inviterID.toString());
            }
            nBTTagList15.func_74742_a((NBTBase)nbt);
        }
        playerData.func_74782_a("FellowshipInvites", (NBTBase)nBTTagList15);
        if (this.chatBoundFellowshipID != null) {
            playerData.func_74778_a("ChatBoundFellowship", this.chatBoundFellowshipID.toString());
        }
        playerData.func_74757_a("StructuresBanned", this.structuresBanned);
        playerData.func_74757_a("TeleportedME", this.teleportedME);
        NBTTagCompound questNBT = new NBTTagCompound();
        this.questData.save(questNBT);
        playerData.func_74782_a("QuestData", (NBTBase)questNBT);
        this.needsSave = false;
    }

    public void load(NBTTagCompound playerData) {
        UUID fsID;
        LOTRTitle title;
        LOTRShields savedShield;
        LOTRFaction faction;
        LOTRFaction cur;
        this.alignments.clear();
        NBTTagList alignmentTags = playerData.func_150295_c("AlignmentMap", 10);
        for (int i = 0; i < alignmentTags.func_74745_c(); ++i) {
            float alignment;
            NBTTagCompound nbt = alignmentTags.func_150305_b(i);
            LOTRFaction faction2 = LOTRFaction.forName(nbt.func_74779_i("Faction"));
            if (faction2 == null) continue;
            if (nbt.func_74764_b("Alignment")) {
                alignment = nbt.func_74762_e("Alignment");
                this.hasPre35Alignments = true;
            } else {
                alignment = nbt.func_74760_g("AlignF");
            }
            this.alignments.put(faction2, Float.valueOf(alignment));
        }
        this.factionDataMap.clear();
        NBTTagList factionDataTags = playerData.func_150295_c("FactionData", 10);
        for (int i = 0; i < factionDataTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = factionDataTags.func_150305_b(i);
            LOTRFaction faction3 = LOTRFaction.forName(nbt.func_74779_i("Faction"));
            if (faction3 == null) continue;
            LOTRFactionData data = new LOTRFactionData(this, faction3);
            data.load(nbt);
            this.factionDataMap.put(faction3, data);
        }
        if (playerData.func_74764_b("CurrentFaction") && (cur = LOTRFaction.forName(playerData.func_74779_i("CurrentFaction"))) != null) {
            this.viewingFaction = cur;
        }
        this.prevRegionFactions.clear();
        NBTTagList prevRegionFactionTags = playerData.func_150295_c("PrevRegionFactions", 10);
        for (int i = 0; i < prevRegionFactionTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = prevRegionFactionTags.func_150305_b(i);
            LOTRDimension.DimensionRegion region = LOTRDimension.DimensionRegion.forName(nbt.func_74779_i("Region"));
            faction = LOTRFaction.forName(nbt.func_74779_i("Faction"));
            if (region == null || faction == null) continue;
            this.prevRegionFactions.put(region, faction);
        }
        this.hideAlignment = playerData.func_74767_n("HideAlignment");
        this.takenAlignmentRewards.clear();
        NBTTagList takenRewardsTags = playerData.func_150295_c("TakenAlignmentRewards", 10);
        for (int i = 0; i < takenRewardsTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = takenRewardsTags.func_150305_b(i);
            faction = LOTRFaction.forName(nbt.func_74779_i("Faction"));
            if (faction == null) continue;
            this.takenAlignmentRewards.add(faction);
        }
        this.pledgeFaction = null;
        if (playerData.func_74764_b("PledgeFac")) {
            this.pledgeFaction = LOTRFaction.forName(playerData.func_74779_i("PledgeFac"));
        }
        this.pledgeKillCooldown = playerData.func_74762_e("PledgeKillCD");
        this.pledgeBreakCooldown = playerData.func_74762_e("PledgeBreakCD");
        this.pledgeBreakCooldownStart = playerData.func_74762_e("PledgeBreakCDStart");
        this.brokenPledgeFaction = null;
        if (playerData.func_74764_b("BrokenPledgeFac")) {
            this.brokenPledgeFaction = LOTRFaction.forName(playerData.func_74779_i("BrokenPledgeFac"));
        }
        if (!this.hasPre35Alignments && playerData.func_74764_b("Pre35Align")) {
            this.hasPre35Alignments = playerData.func_74767_n("Pre35Align");
        }
        if (playerData.func_74764_b("Chosen35Align")) {
            this.chosenUnwantedAlignments = playerData.func_74767_n("Chosen35Align");
        }
        this.hideOnMap = playerData.func_74767_n("HideOnMap");
        this.adminHideMap = playerData.func_74767_n("AdminHideMap");
        if (playerData.func_74764_b("ShowWP")) {
            this.showWaypoints = playerData.func_74767_n("ShowWP");
        }
        if (playerData.func_74764_b("ShowCWP")) {
            this.showCustomWaypoints = playerData.func_74767_n("ShowCWP");
        }
        if (playerData.func_74764_b("ShowHiddenSWP")) {
            this.showHiddenSharedWaypoints = playerData.func_74767_n("ShowHiddenSWP");
        }
        if (playerData.func_74764_b("ConquestKills")) {
            this.conquestKills = playerData.func_74767_n("ConquestKills");
        }
        this.achievements.clear();
        NBTTagList achievementTags = playerData.func_150295_c("Achievements", 10);
        for (int i = 0; i < achievementTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = achievementTags.func_150305_b(i);
            String category = nbt.func_74779_i("Category");
            int ID = nbt.func_74762_e("ID");
            LOTRAchievement achievement = LOTRAchievement.achievementForCategoryAndID(LOTRAchievement.categoryForName(category), ID);
            if (achievement == null || this.achievements.contains(achievement)) continue;
            this.achievements.add(achievement);
        }
        this.shield = null;
        if (playerData.func_74764_b("Shield") && (savedShield = LOTRShields.shieldForName(playerData.func_74779_i("Shield"))) != null) {
            this.shield = savedShield;
        }
        if (playerData.func_74764_b("FriendlyFire")) {
            this.friendlyFire = playerData.func_74767_n("FriendlyFire");
        }
        if (playerData.func_74764_b("HiredDeathMessages")) {
            this.hiredDeathMessages = playerData.func_74767_n("HiredDeathMessages");
        }
        this.deathPoint = null;
        if (playerData.func_74764_b("DeathX") && playerData.func_74764_b("DeathY") && playerData.func_74764_b("DeathZ")) {
            this.deathPoint = new ChunkCoordinates(playerData.func_74762_e("DeathX"), playerData.func_74762_e("DeathY"), playerData.func_74762_e("DeathZ"));
            this.deathDim = playerData.func_74764_b("DeathDim") ? playerData.func_74762_e("DeathDim") : LOTRDimension.MIDDLE_EARTH.dimensionID;
        }
        this.alcoholTolerance = playerData.func_74762_e("Alcohol");
        this.miniQuests.clear();
        NBTTagList miniquestTags = playerData.func_150295_c("MiniQuests", 10);
        for (int i = 0; i < miniquestTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = miniquestTags.func_150305_b(i);
            LOTRMiniQuest quest = LOTRMiniQuest.loadQuestFromNBT(nbt, this);
            if (quest == null) continue;
            this.miniQuests.add(quest);
        }
        this.miniQuestsCompleted.clear();
        NBTTagList miniquestCompletedTags = playerData.func_150295_c("MiniQuestsCompleted", 10);
        for (int i = 0; i < miniquestCompletedTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = miniquestCompletedTags.func_150305_b(i);
            LOTRMiniQuest quest = LOTRMiniQuest.loadQuestFromNBT(nbt, this);
            if (quest == null) continue;
            this.miniQuestsCompleted.add(quest);
        }
        this.completedMiniquestCount = playerData.func_74762_e("MQCompleteCount");
        this.completedBountyQuests = playerData.func_74762_e("MQCompletedBounties");
        this.trackingMiniQuestID = null;
        if (playerData.func_74764_b("MiniQuestTrack")) {
            String s = playerData.func_74779_i("MiniQuestTrack");
            this.trackingMiniQuestID = UUID.fromString(s);
        }
        this.bountiesPlaced.clear();
        NBTTagList bountyTags = playerData.func_150295_c("BountiesPlaced", 8);
        for (int i = 0; i < bountyTags.func_74745_c(); ++i) {
            String fName = bountyTags.func_150307_f(i);
            LOTRFaction fac = LOTRFaction.forName(fName);
            if (fac == null) continue;
            this.bountiesPlaced.add(fac);
        }
        this.lastWaypoint = null;
        if (playerData.func_74764_b("LastWP")) {
            String lastWPName = playerData.func_74779_i("LastWP");
            this.lastWaypoint = LOTRWaypoint.waypointForName(lastWPName);
        }
        this.lastBiome = null;
        if (playerData.func_74764_b("LastBiome")) {
            short lastBiomeID = playerData.func_74765_d("LastBiome");
            LOTRBiome[] biomeList = LOTRDimension.MIDDLE_EARTH.biomeList;
            if (lastBiomeID >= 0 && lastBiomeID < biomeList.length) {
                this.lastBiome = biomeList[lastBiomeID];
            }
        }
        this.sentMessageTypes.clear();
        NBTTagList sentMessageTags = playerData.func_150295_c("SentMessageTypes", 10);
        for (int i = 0; i < sentMessageTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = sentMessageTags.func_150305_b(i);
            LOTRGuiMessageTypes message = LOTRGuiMessageTypes.forSaveName(nbt.func_74779_i("Message"));
            if (message == null) continue;
            boolean sent = nbt.func_74767_n("Sent");
            this.sentMessageTypes.put(message, sent);
        }
        this.playerTitle = null;
        if (playerData.func_74764_b("PlayerTitle") && (title = LOTRTitle.forName(playerData.func_74779_i("PlayerTitle"))) != null) {
            int colorCode = playerData.func_74762_e("PlayerTitleColor");
            EnumChatFormatting color = LOTRTitle.PlayerTitle.colorForID(colorCode);
            this.playerTitle = new LOTRTitle.PlayerTitle(title, color);
        }
        if (playerData.func_74764_b("FemRankOverride")) {
            this.femRankOverride = playerData.func_74767_n("FemRankOverride");
        }
        if (playerData.func_74764_b("FTSince")) {
            this.ftSinceTick = playerData.func_74762_e("FTSince");
        }
        this.targetFTWaypoint = null;
        this.uuidToMount = null;
        if (playerData.func_74764_b("MountUUID")) {
            this.uuidToMount = UUID.fromString(playerData.func_74779_i("MountUUID"));
        }
        this.uuidToMountTime = playerData.func_74762_e("MountUUIDTime");
        this.unlockedFTRegions.clear();
        NBTTagList unlockedFTRegionTags = playerData.func_150295_c("UnlockedFTRegions", 10);
        for (int i = 0; i < unlockedFTRegionTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = unlockedFTRegionTags.func_150305_b(i);
            String regionName = nbt.func_74779_i("Name");
            LOTRWaypoint.Region region = LOTRWaypoint.regionForName(regionName);
            if (region == null) continue;
            this.unlockedFTRegions.add(region);
        }
        this.customWaypoints.clear();
        NBTTagList customWaypointTags = playerData.func_150295_c("CustomWaypoints", 10);
        for (int i = 0; i < customWaypointTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = customWaypointTags.func_150305_b(i);
            LOTRCustomWaypoint waypoint = LOTRCustomWaypoint.readFromNBT(nbt, this);
            this.customWaypoints.add(waypoint);
        }
        this.cwpSharedUnlocked.clear();
        NBTTagList cwpSharedUnlockedTags = playerData.func_150295_c("CWPSharedUnlocked", 10);
        for (int i = 0; i < cwpSharedUnlockedTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = cwpSharedUnlockedTags.func_150305_b(i);
            UUID sharingPlayer = UUID.fromString(nbt.func_74779_i("SharingPlayer"));
            if (sharingPlayer == null) continue;
            int ID = nbt.func_74762_e("CustomID");
            CWPSharedKey key = CWPSharedKey.keyFor(sharingPlayer, ID);
            this.cwpSharedUnlocked.add(key);
        }
        this.cwpSharedHidden.clear();
        NBTTagList cwpSharedHiddenTags = playerData.func_150295_c("CWPSharedHidden", 10);
        for (int i = 0; i < cwpSharedHiddenTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = cwpSharedHiddenTags.func_150305_b(i);
            UUID sharingPlayer = UUID.fromString(nbt.func_74779_i("SharingPlayer"));
            if (sharingPlayer == null) continue;
            int ID = nbt.func_74762_e("CustomID");
            CWPSharedKey key = CWPSharedKey.keyFor(sharingPlayer, ID);
            this.cwpSharedHidden.add(key);
        }
        this.wpUseCounts.clear();
        NBTTagList wpCooldownTags = playerData.func_150295_c("WPUses", 10);
        for (int i = 0; i < wpCooldownTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = wpCooldownTags.func_150305_b(i);
            String name = nbt.func_74779_i("WPName");
            int count = nbt.func_74762_e("Count");
            LOTRWaypoint wp = LOTRWaypoint.waypointForName(name);
            if (wp == null) continue;
            this.wpUseCounts.put(wp, count);
        }
        this.cwpUseCounts.clear();
        NBTTagList cwpCooldownTags = playerData.func_150295_c("CWPUses", 10);
        for (int i = 0; i < cwpCooldownTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = cwpCooldownTags.func_150305_b(i);
            int ID = nbt.func_74762_e("CustomID");
            int count = nbt.func_74762_e("Count");
            this.cwpUseCounts.put(ID, count);
        }
        this.cwpSharedUseCounts.clear();
        NBTTagList cwpSharedCooldownTags = playerData.func_150295_c("CWPSharedUses", 10);
        for (int i = 0; i < cwpSharedCooldownTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = cwpSharedCooldownTags.func_150305_b(i);
            UUID sharingPlayer = UUID.fromString(nbt.func_74779_i("SharingPlayer"));
            if (sharingPlayer == null) continue;
            int ID = nbt.func_74762_e("CustomID");
            CWPSharedKey key = CWPSharedKey.keyFor(sharingPlayer, ID);
            int count = nbt.func_74762_e("Count");
            this.cwpSharedUseCounts.put(key, count);
        }
        this.nextCwpID = startCwpID;
        if (playerData.func_74764_b("NextCWPID")) {
            this.nextCwpID = playerData.func_74762_e("NextCWPID");
        }
        this.fellowshipIDs.clear();
        NBTTagList fellowshipTags = playerData.func_150295_c("Fellowships", 10);
        for (int i = 0; i < fellowshipTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = fellowshipTags.func_150305_b(i);
            UUID fsID2 = UUID.fromString(nbt.func_74779_i("ID"));
            if (fsID2 == null) continue;
            this.fellowshipIDs.add(fsID2);
        }
        this.fellowshipInvites.clear();
        NBTTagList fellowshipInviteTags = playerData.func_150295_c("FellowshipInvites", 10);
        for (int i = 0; i < fellowshipInviteTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = fellowshipInviteTags.func_150305_b(i);
            UUID fsID3 = UUID.fromString(nbt.func_74779_i("ID"));
            if (fsID3 == null) continue;
            UUID inviterID = null;
            if (nbt.func_74764_b("InviterID")) {
                inviterID = UUID.fromString(nbt.func_74779_i("InviterID"));
            }
            this.fellowshipInvites.add(new LOTRFellowshipInvite(fsID3, inviterID));
        }
        this.chatBoundFellowshipID = null;
        if (playerData.func_74764_b("ChatBoundFellowship") && (fsID = UUID.fromString(playerData.func_74779_i("ChatBoundFellowship"))) != null) {
            this.chatBoundFellowshipID = fsID;
        }
        this.structuresBanned = playerData.func_74767_n("StructuresBanned");
        this.teleportedME = playerData.func_74767_n("TeleportedME");
        if (playerData.func_74764_b("QuestData")) {
            NBTTagCompound questNBT = playerData.func_74775_l("QuestData");
            this.questData.load(questNBT);
        }
    }

    public void sendPlayerData(EntityPlayerMP entityplayer) throws IOException {
        LOTRFellowship fs;
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(nbt);
        nbt.func_82580_o("Achievements");
        nbt.func_82580_o("MiniQuests");
        nbt.func_82580_o("MiniQuestsCompleted");
        nbt.func_82580_o("CustomWaypoints");
        nbt.func_82580_o("Fellowships");
        nbt.func_82580_o("FellowshipInvites");
        LOTRPacketLoginPlayerData packet = new LOTRPacketLoginPlayerData(nbt);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
        for (LOTRAchievement achievement : this.achievements) {
            this.sendAchievementPacket(entityplayer, achievement, false);
        }
        for (LOTRMiniQuest quest : this.miniQuests) {
            this.sendMiniQuestPacket(entityplayer, quest, false);
        }
        for (LOTRMiniQuest quest : this.miniQuestsCompleted) {
            this.sendMiniQuestPacket(entityplayer, quest, true);
        }
        for (LOTRCustomWaypoint waypoint : this.customWaypoints) {
            LOTRPacketCreateCWPClient cwpPacket = waypoint.getClientPacket();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)cwpPacket, entityplayer);
        }
        for (UUID fsID : this.fellowshipIDs) {
            fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null) continue;
            this.sendFellowshipPacket(fs);
        }
        for (LOTRFellowshipInvite invite : this.fellowshipInvites) {
            fs = LOTRFellowshipData.getFellowship(invite.fellowshipID);
            if (fs == null) continue;
            this.sendFellowshipInvitePacket(fs);
        }
        this.addSharedCustomWaypoints(null);
    }

    public void send35AlignmentChoice(EntityPlayerMP entityplayer, World world) {
        if (LOTRConfig.alignmentDrain && this.hasPre35Alignments && !this.chosenUnwantedAlignments) {
            LOTRPacketAlignmentChoiceOffer pkt = new LOTRPacketAlignmentChoiceOffer();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)pkt, entityplayer);
        }
    }

    public void chooseUnwantedAlignments(EntityPlayerMP entityplayer, Set<LOTRFaction> setZeroFacs) {
        if (LOTRConfig.alignmentDrain && this.hasPre35Alignments && !this.chosenUnwantedAlignments) {
            HashSet<LOTRFaction> validSelections = new HashSet<LOTRFaction>();
            for (LOTRFaction fac : setZeroFacs) {
                boolean valid = false;
                if (this.getAlignment(fac) > 0.0f) {
                    for (LOTRFaction otherFac : LOTRFaction.getPlayableAlignmentFactions()) {
                        if (fac == otherFac || !this.doFactionsDrain(fac, otherFac) || !(this.getAlignment(otherFac) > 0.0f)) continue;
                        valid = true;
                        break;
                    }
                }
                if (!valid) continue;
                validSelections.add(fac);
            }
            for (LOTRFaction fac : validSelections) {
                this.setAlignment(fac, 0.0f);
                entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("Set %s alignment to zero", new Object[]{fac.factionName()}));
            }
            this.hasPre35Alignments = false;
            this.chosenUnwantedAlignments = true;
            this.markDirty();
        }
    }

    private static boolean isTimerAutosaveTick() {
        return MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71259_af() % 200 == 0;
    }

    public void onUpdate(EntityPlayerMP entityplayer, WorldServer world) {
        ++this.pdTick;
        LOTRDimension.DimensionRegion currentRegion = this.viewingFaction.factionRegion;
        LOTRDimension currentDim = LOTRDimension.getCurrentDimensionWithFallback((World)world);
        if (currentRegion.getDimension() != currentDim) {
            currentRegion = currentDim.dimensionRegions.get(0);
            this.setViewingFaction(this.getRegionLastViewedFaction(currentRegion));
        }
        this.runAlignmentDraining(entityplayer);
        this.questData.onUpdate(entityplayer, world);
        if (!this.isSiegeActive()) {
            this.runAchievementChecks((EntityPlayer)entityplayer, (World)world);
        }
        if (this.playerTitle != null && !this.playerTitle.getTitle().canPlayerUse((EntityPlayer)entityplayer)) {
            ChatComponentTranslation msg = new ChatComponentTranslation("chat.lotr.loseTitle", new Object[]{this.playerTitle.getFullTitleComponent((EntityPlayer)entityplayer)});
            entityplayer.func_145747_a((IChatComponent)msg);
            this.setPlayerTitle(null);
        }
        if (this.pledgeKillCooldown > 0) {
            --this.pledgeKillCooldown;
            if (this.pledgeKillCooldown == 0 || LOTRPlayerData.isTimerAutosaveTick()) {
                this.markDirty();
            }
        }
        if (this.pledgeBreakCooldown > 0) {
            this.setPledgeBreakCooldown(this.pledgeBreakCooldown - 1);
        }
        if (this.trackingMiniQuestID != null && this.getTrackingMiniQuest() == null) {
            this.setTrackingMiniQuest(null);
        }
        List<LOTRMiniQuest> activeMiniquests = this.getActiveMiniQuests();
        for (LOTRMiniQuest quest : activeMiniquests) {
            quest.onPlayerTick((EntityPlayer)entityplayer);
        }
        if (!this.bountiesPlaced.isEmpty()) {
            for (LOTRFaction fac : this.bountiesPlaced) {
                ChatComponentTranslation msg = new ChatComponentTranslation("chat.lotr.bountyPlaced", new Object[]{fac.factionName()});
                msg.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                entityplayer.func_145747_a((IChatComponent)msg);
            }
            this.bountiesPlaced.clear();
            this.markDirty();
        }
        this.setTimeSinceFT(this.ftSinceTick + 1);
        if (this.targetFTWaypoint != null) {
            if (this.ticksUntilFT > 0) {
                int seconds = this.ticksUntilFT / 20;
                if (this.ticksUntilFT == ticksUntilFT_max) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.fastTravel.travelTicksStart", new Object[]{seconds}));
                } else if (this.ticksUntilFT % 20 == 0 && seconds <= 5) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.fastTravel.travelTicks", new Object[]{seconds}));
                }
                --this.ticksUntilFT;
                this.setTicksUntilFT(this.ticksUntilFT);
            } else {
                this.sendFTBouncePacket(entityplayer);
            }
        } else {
            this.setTicksUntilFT(0);
        }
        if (this.uuidToMount != null) {
            if (this.uuidToMountTime > 0) {
                --this.uuidToMountTime;
            } else {
                double range = 32.0;
                List entities = world.func_72872_a(EntityLivingBase.class, entityplayer.field_70121_D.func_72314_b(range, range, range));
                for (Object obj : entities) {
                    Entity entity = (Entity)obj;
                    if (!entity.func_110124_au().equals(this.uuidToMount)) continue;
                    entityplayer.func_70078_a(entity);
                    break;
                }
                this.setUUIDToMount(null);
            }
        }
        if (this.pdTick % 24000 == 0 && this.alcoholTolerance > 0) {
            --this.alcoholTolerance;
            this.setAlcoholTolerance(this.alcoholTolerance);
        }
        this.unlockSharedCustomWaypoints((EntityPlayer)entityplayer);
        if (this.pdTick % 100 == 0 && world.field_73011_w instanceof LOTRWorldProvider) {
            int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
            int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
            LOTRBiome biome = (LOTRBiome)world.field_73011_w.getBiomeGenForCoords(i, k);
            if (biome.biomeDimension == LOTRDimension.MIDDLE_EARTH) {
                LOTRBiome prevLastBiome = this.lastBiome;
                this.lastBiome = biome;
                if (prevLastBiome != biome) {
                    this.markDirty();
                }
            }
        }
        if (this.adminHideMap) {
            boolean isOp = MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(entityplayer.func_146103_bH());
            if (!entityplayer.field_71075_bZ.field_75098_d || !isOp) {
                this.setAdminHideMap(false);
                LOTRCommandAdminHideMap.notifyUnhidden((EntityPlayer)entityplayer);
            }
        }
        if (this.siegeActiveTime > 0) {
            --this.siegeActiveTime;
        }
    }

    public float getAlignment(LOTRFaction faction) {
        if (faction.hasFixedAlignment) {
            return faction.fixedAlignment;
        }
        Float alignment = this.alignments.get((Object)faction);
        return alignment != null ? alignment.floatValue() : 0.0f;
    }

    public void setAlignment(LOTRFaction faction, float alignment) {
        EntityPlayer entityplayer = this.getPlayer();
        if (faction.isPlayableAlignmentFaction()) {
            float prevAlignment = this.getAlignment(faction);
            this.alignments.put(faction, Float.valueOf(alignment));
            this.markDirty();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
            }
            this.checkAlignmentAchievements(faction, prevAlignment);
        }
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K && this.pledgeFaction != null && !this.canPledgeTo(this.pledgeFaction)) {
            this.revokePledgeFaction(entityplayer, false);
        }
    }

    public LOTRAlignmentBonusMap addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.AlignmentBonus source, LOTRFaction faction, Entity entity) {
        return this.addAlignment(entityplayer, source, faction, null, entity);
    }

    public LOTRAlignmentBonusMap addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.AlignmentBonus source, LOTRFaction faction, List<LOTRFaction> forcedBonusFactions, Entity entity) {
        return this.addAlignment(entityplayer, source, faction, forcedBonusFactions, entity.field_70165_t, entity.field_70121_D.field_72338_b + (double)entity.field_70131_O * 0.7, entity.field_70161_v);
    }

    public LOTRAlignmentBonusMap addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.AlignmentBonus source, LOTRFaction faction, double posX, double posY, double posZ) {
        return this.addAlignment(entityplayer, source, faction, null, posX, posY, posZ);
    }

    public LOTRAlignmentBonusMap addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.AlignmentBonus source, LOTRFaction faction, List<LOTRFaction> forcedBonusFactions, double posX, double posY, double posZ) {
        float bonus = source.bonus;
        LOTRAlignmentBonusMap factionBonusMap = new LOTRAlignmentBonusMap();
        float prevMainAlignment = this.getAlignment(faction);
        float conquestBonus = 0.0f;
        float notPledgedMultiplier = 0.5f;
        if (source.isKill) {
            List<LOTRFaction> killBonuses = faction.getBonusesForKilling();
            for (LOTRFaction bonusFaction : killBonuses) {
                if (!bonusFaction.isPlayableAlignmentFaction() || !bonusFaction.approvesWarCrimes && source.isCivilianKill) continue;
                if (!source.killByHiredUnit) {
                    float mplier = 0.0f;
                    mplier = forcedBonusFactions != null && forcedBonusFactions.contains((Object)bonusFaction) ? 1.0f : bonusFaction.getControlZoneAlignmentMultiplier(entityplayer);
                    if (mplier > 0.0f) {
                        float alignment = this.getAlignment(bonusFaction);
                        float factionBonus = Math.abs(bonus);
                        factionBonus *= mplier;
                        if (alignment >= bonusFaction.getPledgeAlignment() && !this.isPledgedTo(bonusFaction)) {
                            factionBonus *= 0.5f;
                        }
                        factionBonus = this.checkBonusForPledgeEnemyLimit(bonusFaction, factionBonus);
                        this.setAlignment(bonusFaction, alignment += factionBonus);
                        factionBonusMap.put(bonusFaction, Float.valueOf(factionBonus));
                    }
                }
                if (bonusFaction != this.getPledgeFaction()) continue;
                float conq = bonus;
                if (source.killByHiredUnit) {
                    conq *= 0.25f;
                }
                conquestBonus = LOTRConquestGrid.onConquestKill(entityplayer, bonusFaction, faction, conq);
                this.getFactionData(bonusFaction).addConquest(Math.abs(conquestBonus));
            }
            List<LOTRFaction> killPenalties = faction.getPenaltiesForKilling();
            for (LOTRFaction penaltyFaction : killPenalties) {
                if (!penaltyFaction.isPlayableAlignmentFaction() || source.killByHiredUnit) continue;
                float mplier = 0.0f;
                mplier = penaltyFaction == faction ? 1.0f : penaltyFaction.getControlZoneAlignmentMultiplier(entityplayer);
                if (!(mplier > 0.0f)) continue;
                float alignment = this.getAlignment(penaltyFaction);
                float factionPenalty = -Math.abs(bonus);
                factionPenalty *= mplier;
                factionPenalty = LOTRAlignmentValues.AlignmentBonus.scalePenalty(factionPenalty, alignment);
                this.setAlignment(penaltyFaction, alignment += factionPenalty);
                factionBonusMap.put(penaltyFaction, Float.valueOf(factionPenalty));
            }
        } else if (faction.isPlayableAlignmentFaction()) {
            float alignment = this.getAlignment(faction);
            float factionBonus = bonus;
            if (factionBonus > 0.0f && alignment >= faction.getPledgeAlignment() && !this.isPledgedTo(faction)) {
                factionBonus *= 0.5f;
            }
            factionBonus = this.checkBonusForPledgeEnemyLimit(faction, factionBonus);
            this.setAlignment(faction, alignment += factionBonus);
            factionBonusMap.put(faction, Float.valueOf(factionBonus));
        }
        if (!factionBonusMap.isEmpty() || conquestBonus != 0.0f) {
            this.sendAlignmentBonusPacket(source, faction, prevMainAlignment, factionBonusMap, conquestBonus, posX, posY, posZ);
        }
        return factionBonusMap;
    }

    public void givePureConquestBonus(EntityPlayer entityplayer, LOTRFaction bonusFac, LOTRFaction enemyFac, float conq, String title, double posX, double posY, double posZ) {
        conq = LOTRConquestGrid.onConquestKill(entityplayer, bonusFac, enemyFac, conq);
        this.getFactionData(bonusFac).addConquest(Math.abs(conq));
        if (conq != 0.0f) {
            LOTRAlignmentValues.AlignmentBonus source = new LOTRAlignmentValues.AlignmentBonus(0.0f, title);
            LOTRPacketAlignmentBonus packet = new LOTRPacketAlignmentBonus(bonusFac, this.getAlignment(bonusFac), new LOTRAlignmentBonusMap(), conq, posX, posY, posZ, source);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    private void sendAlignmentBonusPacket(LOTRAlignmentValues.AlignmentBonus source, LOTRFaction faction, float prevMainAlignment, LOTRAlignmentBonusMap factionMap, float conqBonus, double posX, double posY, double posZ) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null) {
            LOTRPacketAlignmentBonus packet = new LOTRPacketAlignmentBonus(faction, prevMainAlignment, factionMap, conqBonus, posX, posY, posZ, source);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void setAlignmentFromCommand(LOTRFaction faction, float set) {
        this.setAlignment(faction, set);
    }

    public void addAlignmentFromCommand(LOTRFaction faction, float add) {
        float alignment = this.getAlignment(faction);
        this.setAlignment(faction, alignment += add);
    }

    private float checkBonusForPledgeEnemyLimit(LOTRFaction fac, float bonus) {
        if (this.isPledgeEnemyAlignmentLimited(fac)) {
            float limit;
            float alignment = this.getAlignment(fac);
            if (alignment > (limit = this.getPledgeEnemyAlignmentLimit(fac))) {
                bonus = 0.0f;
            } else if (alignment + bonus > limit) {
                bonus = limit - alignment;
            }
        }
        return bonus;
    }

    public boolean isPledgeEnemyAlignmentLimited(LOTRFaction fac) {
        return this.pledgeFaction != null && this.doesFactionPreventPledge(this.pledgeFaction, fac);
    }

    public float getPledgeEnemyAlignmentLimit(LOTRFaction fac) {
        return 0.0f;
    }

    private void checkAlignmentAchievements(LOTRFaction faction, float prevAlignment) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            float alignment = this.getAlignment(faction);
            faction.checkAlignmentAchievements(entityplayer, alignment);
        }
    }

    private void runAlignmentDraining(EntityPlayerMP entityplayer) {
        if (LOTRConfig.alignmentDrain && this.pdTick % 1000 == 0) {
            float drainLimit = 0.0f;
            ArrayList<LOTRFaction> drainFactions = new ArrayList<LOTRFaction>();
            List<LOTRFaction> allFacs = LOTRFaction.getPlayableAlignmentFactions();
            for (LOTRFaction fac1 : allFacs) {
                for (LOTRFaction fac2 : allFacs) {
                    if (!this.doFactionsDrain(fac1, fac2)) continue;
                    float align1 = this.getAlignment(fac1);
                    float align2 = this.getAlignment(fac2);
                    if (!(align1 > 0.0f) || !(align2 > 0.0f)) continue;
                    if (!drainFactions.contains((Object)fac1)) {
                        drainFactions.add(fac1);
                    }
                    if (drainFactions.contains((Object)fac2)) continue;
                    drainFactions.add(fac2);
                }
            }
            if (!drainFactions.isEmpty()) {
                for (LOTRFaction fac : drainFactions) {
                    float align = this.getAlignment(fac);
                    float alignLoss = 5.0f;
                    alignLoss = Math.min(alignLoss, align - 0.0f);
                    this.setAlignment(fac, align -= alignLoss);
                }
                this.sendMessageIfNotReceived(LOTRGuiMessageTypes.ALIGN_DRAIN);
                LOTRPacketAlignDrain packet = new LOTRPacketAlignDrain(drainFactions.size());
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
            }
        }
    }

    public boolean doFactionsDrain(LOTRFaction fac1, LOTRFaction fac2) {
        return fac1.isMortalEnemy(fac2);
    }

    public LOTRFactionData getFactionData(LOTRFaction faction) {
        LOTRFactionData data = this.factionDataMap.get((Object)faction);
        if (data == null) {
            data = new LOTRFactionData(this, faction);
            this.factionDataMap.put(faction, data);
        }
        return data;
    }

    public void updateFactionData(LOTRFaction faction, LOTRFactionData factionData) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            this.markDirty();
            NBTTagCompound nbt = new NBTTagCompound();
            factionData.save(nbt);
            LOTRPacketFactionData packet = new LOTRPacketFactionData(faction, nbt);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public LOTRFaction getPledgeFaction() {
        return this.pledgeFaction;
    }

    public boolean isPledgedTo(LOTRFaction fac) {
        return this.pledgeFaction == fac;
    }

    public void setPledgeFaction(LOTRFaction fac) {
        EntityPlayer entityplayer;
        this.pledgeFaction = fac;
        this.pledgeKillCooldown = 0;
        this.markDirty();
        if (fac != null) {
            this.checkAlignmentAchievements(fac, this.getAlignment(fac));
            this.addAchievement(LOTRAchievement.pledgeService);
        }
        if ((entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
            if (fac != null) {
                World world = entityplayer.field_70170_p;
                world.func_72956_a((Entity)entityplayer, "lotr:event.pledge", 1.0f, 1.0f);
            }
            LOTRPacketPledge packet = new LOTRPacketPledge(fac);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public boolean canPledgeTo(LOTRFaction fac) {
        if (fac.isPlayableAlignmentFaction()) {
            return this.hasPledgeAlignment(fac) && this.getFactionsPreventingPledgeTo(fac).isEmpty();
        }
        return false;
    }

    public boolean hasPledgeAlignment(LOTRFaction fac) {
        float alignment = this.getAlignment(fac);
        return alignment >= fac.getPledgeAlignment();
    }

    public List<LOTRFaction> getFactionsPreventingPledgeTo(LOTRFaction fac) {
        ArrayList<LOTRFaction> enemies = new ArrayList<LOTRFaction>();
        for (LOTRFaction otherFac : LOTRFaction.values()) {
            float enemyAlign;
            if (!otherFac.isPlayableAlignmentFaction() || !this.doesFactionPreventPledge(fac, otherFac) || !((enemyAlign = this.getAlignment(otherFac)) > 0.0f)) continue;
            enemies.add(otherFac);
        }
        return enemies;
    }

    private boolean doesFactionPreventPledge(LOTRFaction pledgeFac, LOTRFaction otherFac) {
        return pledgeFac.isMortalEnemy(otherFac);
    }

    public boolean canMakeNewPledge() {
        return this.pledgeBreakCooldown <= 0;
    }

    public void revokePledgeFaction(EntityPlayer entityplayer, boolean intentional) {
        LOTRFaction wasPledge = this.pledgeFaction;
        float pledgeLvl = wasPledge.getPledgeAlignment();
        float prevAlign = this.getAlignment(wasPledge);
        float diff = prevAlign - pledgeLvl;
        float cd = diff / 5000.0f;
        cd = MathHelper.func_76131_a((float)cd, (float)0.0f, (float)1.0f);
        int cdTicks = 36000;
        this.setPledgeFaction(null);
        this.setBrokenPledgeFaction(wasPledge);
        this.setPledgeBreakCooldown(cdTicks += Math.round(cd * 150.0f * 60.0f * 20.0f));
        World world = entityplayer.field_70170_p;
        if (!world.field_72995_K) {
            ChatComponentTranslation msg;
            LOTRFactionRank rank = wasPledge.getRank(prevAlign);
            LOTRFactionRank rankBelow = wasPledge.getRankBelow(rank);
            LOTRFactionRank rankBelow2 = wasPledge.getRankBelow(rankBelow);
            float newAlign = rankBelow2.alignment;
            float alignPenalty = (newAlign = Math.max(newAlign, pledgeLvl / 2.0f)) - prevAlign;
            if (alignPenalty < 0.0f) {
                LOTRAlignmentValues.AlignmentBonus penalty = LOTRAlignmentValues.createPledgePenalty(alignPenalty);
                double alignX = 0.0;
                double alignY = 0.0;
                double alignZ = 0.0;
                double lookRange = 2.0;
                Vec3 posEye = Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70121_D.field_72338_b + (double)entityplayer.func_70047_e()), (double)entityplayer.field_70161_v);
                Vec3 look = entityplayer.func_70676_i(1.0f);
                Vec3 posSight = posEye.func_72441_c(look.field_72450_a * lookRange, look.field_72448_b * lookRange, look.field_72449_c * lookRange);
                MovingObjectPosition mop = world.func_72933_a(posEye, posSight);
                if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    alignX = (double)mop.field_72311_b + 0.5;
                    alignY = (double)mop.field_72312_c + 0.5;
                    alignZ = (double)mop.field_72309_d + 0.5;
                } else {
                    alignX = posSight.field_72450_a;
                    alignY = posSight.field_72448_b;
                    alignZ = posSight.field_72449_c;
                }
                this.addAlignment(entityplayer, penalty, wasPledge, alignX, alignY, alignZ);
            }
            world.func_72956_a((Entity)entityplayer, "lotr:event.unpledge", 1.0f, 1.0f);
            if (intentional) {
                msg = new ChatComponentTranslation("chat.lotr.unpledge", new Object[]{wasPledge.factionName()});
                entityplayer.func_145747_a((IChatComponent)msg);
            } else {
                msg = new ChatComponentTranslation("chat.lotr.autoUnpledge", new Object[]{wasPledge.factionName()});
                entityplayer.func_145747_a((IChatComponent)msg);
            }
            this.checkAlignmentAchievements(wasPledge, prevAlign);
        }
    }

    public void onPledgeKill(EntityPlayer entityplayer) {
        this.pledgeKillCooldown += 24000;
        this.markDirty();
        if (this.pledgeKillCooldown > 24000) {
            this.revokePledgeFaction(entityplayer, false);
        } else if (this.pledgeFaction != null) {
            ChatComponentTranslation msg = new ChatComponentTranslation("chat.lotr.pledgeKillWarn", new Object[]{this.pledgeFaction.factionName()});
            entityplayer.func_145747_a((IChatComponent)msg);
        }
    }

    public int getPledgeBreakCooldown() {
        return this.pledgeBreakCooldown;
    }

    public void setPledgeBreakCooldown(int i) {
        EntityPlayer entityplayer;
        boolean bigChange;
        int preCD = this.pledgeBreakCooldown;
        LOTRFaction preBroken = this.brokenPledgeFaction;
        this.pledgeBreakCooldown = i = Math.max(0, i);
        boolean bl = bigChange = (this.pledgeBreakCooldown == 0 || preCD == 0) && this.pledgeBreakCooldown != preCD;
        if (this.pledgeBreakCooldown > this.pledgeBreakCooldownStart) {
            this.setPledgeBreakCooldownStart(this.pledgeBreakCooldown);
            bigChange = true;
        }
        if (this.pledgeBreakCooldown <= 0 && preBroken != null) {
            this.setPledgeBreakCooldownStart(0);
            this.setBrokenPledgeFaction(null);
            bigChange = true;
        }
        if (bigChange || LOTRPlayerData.isTimerAutosaveTick()) {
            this.markDirty();
        }
        if ((bigChange || this.pledgeBreakCooldown % 5 == 0) && (entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketBrokenPledge packet = new LOTRPacketBrokenPledge(this.pledgeBreakCooldown, this.pledgeBreakCooldownStart, this.brokenPledgeFaction);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
        if (this.pledgeBreakCooldown == 0 && preCD != this.pledgeBreakCooldown && (entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
            String brokenName = preBroken == null ? StatCollector.func_74838_a((String)"lotr.gui.factions.pledgeUnknown") : preBroken.factionName();
            ChatComponentTranslation msg = new ChatComponentTranslation("chat.lotr.pledgeBreakCooldown", new Object[]{brokenName});
            entityplayer.func_145747_a((IChatComponent)msg);
        }
    }

    public int getPledgeBreakCooldownStart() {
        return this.pledgeBreakCooldownStart;
    }

    public void setPledgeBreakCooldownStart(int i) {
        this.pledgeBreakCooldownStart = i;
        this.markDirty();
    }

    public LOTRFaction getBrokenPledgeFaction() {
        return this.brokenPledgeFaction;
    }

    public void setBrokenPledgeFaction(LOTRFaction f) {
        this.brokenPledgeFaction = f;
        this.markDirty();
    }

    public List<LOTRAchievement> getAchievements() {
        return this.achievements;
    }

    public List<LOTRAchievement> getEarnedAchievements(LOTRDimension dimension) {
        ArrayList<LOTRAchievement> earnedAchievements = new ArrayList<LOTRAchievement>();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null) {
            for (LOTRAchievement achievement : this.achievements) {
                if (achievement.getDimension() != dimension || !achievement.canPlayerEarn(entityplayer)) continue;
                earnedAchievements.add(achievement);
            }
        }
        return earnedAchievements;
    }

    public boolean hasAchievement(LOTRAchievement achievement) {
        for (LOTRAchievement a : this.achievements) {
            if (a.category != achievement.category || a.ID != achievement.ID) continue;
            return true;
        }
        return false;
    }

    public void addAchievement(LOTRAchievement achievement) {
        if (this.hasAchievement(achievement)) {
            return;
        }
        if (this.isSiegeActive()) {
            return;
        }
        this.achievements.add(achievement);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            boolean canEarn = achievement.canPlayerEarn(entityplayer);
            this.sendAchievementPacket((EntityPlayerMP)entityplayer, achievement, canEarn);
            if (canEarn) {
                achievement.broadcastEarning(entityplayer);
                List<LOTRAchievement> earnedAchievements = this.getEarnedAchievements(LOTRDimension.MIDDLE_EARTH);
                int biomes = 0;
                for (int i = 0; i < earnedAchievements.size(); ++i) {
                    LOTRAchievement earnedAchievement = earnedAchievements.get(i);
                    if (!earnedAchievement.isBiomeAchievement) continue;
                    ++biomes;
                }
                if (biomes >= 10) {
                    this.addAchievement(LOTRAchievement.travel10);
                }
                if (biomes >= 20) {
                    this.addAchievement(LOTRAchievement.travel20);
                }
                if (biomes >= 30) {
                    this.addAchievement(LOTRAchievement.travel30);
                }
                if (biomes >= 40) {
                    this.addAchievement(LOTRAchievement.travel40);
                }
                if (biomes >= 50) {
                    this.addAchievement(LOTRAchievement.travel50);
                }
            }
        }
    }

    public void removeAchievement(LOTRAchievement achievement) {
        if (!this.hasAchievement(achievement)) {
            return;
        }
        if (this.achievements.remove(achievement)) {
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                this.sendAchievementRemovePacket((EntityPlayerMP)entityplayer, achievement);
            }
        }
    }

    private void runAchievementChecks(EntityPlayer entityplayer, World world) {
        LOTRMaterial fullMaterial;
        int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome) {
            ItemStack[] biomeRegion;
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            LOTRAchievement ach = lotrbiome.getBiomeAchievement();
            if (ach != null) {
                this.addAchievement(ach);
            }
            if ((biomeRegion = lotrbiome.getBiomeWaypoints()) != null) {
                this.unlockFTRegion((LOTRWaypoint.Region)biomeRegion);
            }
        }
        if (entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
            this.addAchievement(LOTRAchievement.enterMiddleEarth);
        }
        if (entityplayer.field_71093_bK == LOTRDimension.UTUMNO.dimensionID) {
            this.addAchievement(LOTRAchievement.enterUtumnoIce);
            int y = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
            LOTRUtumnoLevel level = LOTRUtumnoLevel.forY(y);
            if (level == LOTRUtumnoLevel.OBSIDIAN) {
                this.addAchievement(LOTRAchievement.enterUtumnoObsidian);
            } else if (level == LOTRUtumnoLevel.FIRE) {
                this.addAchievement(LOTRAchievement.enterUtumnoFire);
            }
        }
        if (entityplayer.field_71071_by.func_146028_b(LOTRMod.pouch)) {
            this.addAchievement(LOTRAchievement.getPouch);
        }
        HashSet<Block> tables = new HashSet<Block>();
        int crossbowBolts = 0;
        for (ItemStack item : entityplayer.field_71071_by.field_70462_a) {
            Block block;
            if (item != null && item.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)item.func_77973_b())) instanceof LOTRBlockCraftingTable) {
                tables.add(block);
            }
            if (item == null || !(item.func_77973_b() instanceof LOTRItemCrossbowBolt)) continue;
            crossbowBolts += item.field_77994_a;
        }
        if (tables.size() >= 10) {
            this.addAchievement(LOTRAchievement.collectCraftingTables);
        }
        if (crossbowBolts >= 128) {
            this.addAchievement(LOTRAchievement.collectCrossbowBolts);
        }
        if (!this.hasAchievement(LOTRAchievement.hundreds) && this.pdTick % 20 == 0) {
            int hiredUnits = 0;
            List nearbyNPCs = world.func_72872_a(LOTREntityNPC.class, entityplayer.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            for (LOTREntityNPC npc : nearbyNPCs) {
                if (!npc.hiredNPCInfo.isActive || npc.hiredNPCInfo.getHiringPlayer() != entityplayer) continue;
                ++hiredUnits;
            }
            if (hiredUnits >= 100) {
                this.addAchievement(LOTRAchievement.hundreds);
            }
        }
        if (biome instanceof LOTRBiomeGenMistyMountains && entityplayer.field_70163_u > 192.0) {
            this.addAchievement(LOTRAchievement.climbMistyMountains);
        }
        if ((fullMaterial = this.isPlayerWearingFull(entityplayer)) != null) {
            if (fullMaterial == LOTRMaterial.MITHRIL) {
                this.addAchievement(LOTRAchievement.wearFullMithril);
            } else if (fullMaterial == LOTRMaterial.FUR) {
                this.addAchievement(LOTRAchievement.wearFullFur);
            } else if (fullMaterial == LOTRMaterial.BLUE_DWARVEN) {
                this.addAchievement(LOTRAchievement.wearFullBlueDwarven);
            } else if (fullMaterial == LOTRMaterial.HIGH_ELVEN) {
                this.addAchievement(LOTRAchievement.wearFullHighElven);
            } else if (fullMaterial == LOTRMaterial.GONDOLIN) {
                this.addAchievement(LOTRAchievement.wearFullGondolin);
            } else if (fullMaterial == LOTRMaterial.GALVORN) {
                this.addAchievement(LOTRAchievement.wearFullGalvorn);
            } else if (fullMaterial == LOTRMaterial.RANGER) {
                this.addAchievement(LOTRAchievement.wearFullRanger);
            } else if (fullMaterial == LOTRMaterial.GUNDABAD_URUK) {
                this.addAchievement(LOTRAchievement.wearFullGundabadUruk);
            } else if (fullMaterial == LOTRMaterial.ARNOR) {
                this.addAchievement(LOTRAchievement.wearFullArnor);
            } else if (fullMaterial == LOTRMaterial.RIVENDELL) {
                this.addAchievement(LOTRAchievement.wearFullRivendell);
            } else if (fullMaterial == LOTRMaterial.ANGMAR) {
                this.addAchievement(LOTRAchievement.wearFullAngmar);
            } else if (fullMaterial == LOTRMaterial.WOOD_ELVEN_SCOUT) {
                this.addAchievement(LOTRAchievement.wearFullWoodElvenScout);
            } else if (fullMaterial == LOTRMaterial.WOOD_ELVEN) {
                this.addAchievement(LOTRAchievement.wearFullWoodElven);
            } else if (fullMaterial == LOTRMaterial.DOL_GULDUR) {
                this.addAchievement(LOTRAchievement.wearFullDolGuldur);
            } else if (fullMaterial == LOTRMaterial.DALE) {
                this.addAchievement(LOTRAchievement.wearFullDale);
            } else if (fullMaterial == LOTRMaterial.DWARVEN) {
                this.addAchievement(LOTRAchievement.wearFullDwarven);
            } else if (fullMaterial == LOTRMaterial.GALADHRIM) {
                this.addAchievement(LOTRAchievement.wearFullElven);
            } else if (fullMaterial == LOTRMaterial.HITHLAIN) {
                this.addAchievement(LOTRAchievement.wearFullHithlain);
            } else if (fullMaterial == LOTRMaterial.URUK) {
                this.addAchievement(LOTRAchievement.wearFullUruk);
            } else if (fullMaterial == LOTRMaterial.ROHAN) {
                this.addAchievement(LOTRAchievement.wearFullRohirric);
            } else if (fullMaterial == LOTRMaterial.ROHAN_MARSHAL) {
                this.addAchievement(LOTRAchievement.wearFullRohirricMarshal);
            } else if (fullMaterial == LOTRMaterial.DUNLENDING) {
                this.addAchievement(LOTRAchievement.wearFullDunlending);
            } else if (fullMaterial == LOTRMaterial.GONDOR) {
                this.addAchievement(LOTRAchievement.wearFullGondorian);
            } else if (fullMaterial == LOTRMaterial.DOL_AMROTH) {
                this.addAchievement(LOTRAchievement.wearFullDolAmroth);
            } else if (fullMaterial == LOTRMaterial.RANGER_ITHILIEN) {
                this.addAchievement(LOTRAchievement.wearFullRangerIthilien);
            } else if (fullMaterial == LOTRMaterial.LOSSARNACH) {
                this.addAchievement(LOTRAchievement.wearFullLossarnach);
            } else if (fullMaterial == LOTRMaterial.PELARGIR) {
                this.addAchievement(LOTRAchievement.wearFullPelargir);
            } else if (fullMaterial == LOTRMaterial.PINNATH_GELIN) {
                this.addAchievement(LOTRAchievement.wearFullPinnathGelin);
            } else if (fullMaterial == LOTRMaterial.BLACKROOT) {
                this.addAchievement(LOTRAchievement.wearFullBlackroot);
            } else if (fullMaterial == LOTRMaterial.LAMEDON) {
                this.addAchievement(LOTRAchievement.wearFullLamedon);
            } else if (fullMaterial == LOTRMaterial.MORDOR) {
                this.addAchievement(LOTRAchievement.wearFullOrc);
            } else if (fullMaterial == LOTRMaterial.MORGUL) {
                this.addAchievement(LOTRAchievement.wearFullMorgul);
            } else if (fullMaterial == LOTRMaterial.BLACK_URUK) {
                this.addAchievement(LOTRAchievement.wearFullBlackUruk);
            } else if (fullMaterial == LOTRMaterial.DORWINION) {
                this.addAchievement(LOTRAchievement.wearFullDorwinion);
            } else if (fullMaterial == LOTRMaterial.DORWINION_ELF) {
                this.addAchievement(LOTRAchievement.wearFullDorwinionElf);
            } else if (fullMaterial == LOTRMaterial.RHUN) {
                this.addAchievement(LOTRAchievement.wearFullRhun);
            } else if (fullMaterial == LOTRMaterial.RHUN_GOLD) {
                this.addAchievement(LOTRAchievement.wearFullRhunGold);
            } else if (fullMaterial == LOTRMaterial.NEAR_HARAD) {
                this.addAchievement(LOTRAchievement.wearFullNearHarad);
            } else if (fullMaterial == LOTRMaterial.GULF_HARAD) {
                this.addAchievement(LOTRAchievement.wearFullGulfHarad);
            } else if (fullMaterial == LOTRMaterial.CORSAIR) {
                this.addAchievement(LOTRAchievement.wearFullCorsair);
            } else if (fullMaterial == LOTRMaterial.UMBAR) {
                this.addAchievement(LOTRAchievement.wearFullUmbar);
            } else if (fullMaterial == LOTRMaterial.HARNEDOR) {
                this.addAchievement(LOTRAchievement.wearFullHarnedor);
            } else if (fullMaterial == LOTRMaterial.HARAD_NOMAD) {
                this.addAchievement(LOTRAchievement.wearFullNomad);
            } else if (fullMaterial == LOTRMaterial.BLACK_NUMENOREAN) {
                this.addAchievement(LOTRAchievement.wearFullBlackNumenorean);
            } else if (fullMaterial == LOTRMaterial.MOREDAIN) {
                this.addAchievement(LOTRAchievement.wearFullMoredain);
            } else if (fullMaterial == LOTRMaterial.TAUREDAIN) {
                this.addAchievement(LOTRAchievement.wearFullTauredain);
            } else if (fullMaterial == LOTRMaterial.TAUREDAIN_GOLD) {
                this.addAchievement(LOTRAchievement.wearFullTaurethrimGold);
            } else if (fullMaterial == LOTRMaterial.HALF_TROLL) {
                this.addAchievement(LOTRAchievement.wearFullHalfTroll);
            } else if (fullMaterial == LOTRMaterial.UTUMNO) {
                this.addAchievement(LOTRAchievement.wearFullUtumno);
            }
        }
    }

    public LOTRMaterial isPlayerWearingFull(EntityPlayer entityplayer) {
        LOTRMaterial fullMaterial = null;
        for (ItemStack itemstack : entityplayer.field_71071_by.field_70460_b) {
            if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemArmor) {
                LOTRItemArmor armor = (LOTRItemArmor)itemstack.func_77973_b();
                LOTRMaterial thisMaterial = armor.getLOTRArmorMaterial();
                if (fullMaterial == null) {
                    fullMaterial = thisMaterial;
                    continue;
                }
                if (fullMaterial == thisMaterial) continue;
                return null;
            }
            return null;
        }
        return fullMaterial;
    }

    private void sendAchievementPacket(EntityPlayerMP entityplayer, LOTRAchievement achievement, boolean display) {
        LOTRPacketAchievement packet = new LOTRPacketAchievement(achievement, display);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    private void sendAchievementRemovePacket(EntityPlayerMP entityplayer, LOTRAchievement achievement) {
        LOTRPacketAchievementRemove packet = new LOTRPacketAchievementRemove(achievement);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    public void setShield(LOTRShields lotrshield) {
        this.shield = lotrshield;
        this.markDirty();
    }

    public LOTRShields getShield() {
        return this.shield;
    }

    public void setStructuresBanned(boolean flag) {
        this.structuresBanned = flag;
        this.markDirty();
    }

    public boolean getStructuresBanned() {
        return this.structuresBanned;
    }

    private void sendOptionsPacket(int option, boolean flag) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketOptions packet = new LOTRPacketOptions(option, flag);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public boolean getFriendlyFire() {
        return this.friendlyFire;
    }

    public void setFriendlyFire(boolean flag) {
        this.friendlyFire = flag;
        this.markDirty();
        this.sendOptionsPacket(0, flag);
    }

    public boolean getEnableHiredDeathMessages() {
        return this.hiredDeathMessages;
    }

    public void setEnableHiredDeathMessages(boolean flag) {
        this.hiredDeathMessages = flag;
        this.markDirty();
        this.sendOptionsPacket(1, flag);
    }

    public boolean getHideAlignment() {
        return this.hideAlignment;
    }

    public void setHideAlignment(boolean flag) {
        this.hideAlignment = flag;
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
        }
    }

    private void sendFTBouncePacket(EntityPlayerMP entityplayer) {
        LOTRPacketFTBounceClient packet = new LOTRPacketFTBounceClient();
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    public void receiveFTBouncePacket() {
        if (this.targetFTWaypoint != null && this.ticksUntilFT <= 0) {
            this.fastTravelTo(this.targetFTWaypoint);
            this.setTargetFTWaypoint(null);
        }
    }

    private void fastTravelTo(LOTRAbstractWaypoint waypoint) {
        EntityPlayer player = this.getPlayer();
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayer = (EntityPlayerMP)player;
            WorldServer world = (WorldServer)entityplayer.field_70170_p;
            int startX = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
            int startZ = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
            double range = 256.0;
            List entities = world.func_72872_a(EntityLiving.class, entityplayer.field_70121_D.func_72314_b(range, range, range));
            HashSet<Object> entitiesToTransport = new HashSet<Object>();
            for (Object entity : entities) {
                EntityTameable entityTameable;
                if (entity instanceof LOTREntityNPC) {
                    LOTREntityGollum gollum;
                    LOTREntityNPC lOTREntityNPC = (LOTREntityNPC)entity;
                    if (lOTREntityNPC.hiredNPCInfo.isActive && lOTREntityNPC.hiredNPCInfo.getHiringPlayer() == entityplayer && lOTREntityNPC.hiredNPCInfo.shouldFollowPlayer()) {
                        entitiesToTransport.add(lOTREntityNPC);
                        continue;
                    }
                    if (lOTREntityNPC instanceof LOTREntityGollum && (gollum = (LOTREntityGollum)lOTREntityNPC).getGollumOwner() == entityplayer && !gollum.isGollumSitting()) {
                        entitiesToTransport.add(gollum);
                        continue;
                    }
                }
                if (entity instanceof EntityTameable && (entityTameable = (EntityTameable)entity).func_70902_q() == entityplayer && !entityTameable.func_70906_o()) {
                    entitiesToTransport.add(entityTameable);
                    continue;
                }
                if (!entity.func_110167_bD() || entity.func_110166_bE() != entityplayer) continue;
                entitiesToTransport.add(entity);
            }
            HashSet<EntityLiving> removes = new HashSet<EntityLiving>();
            for (EntityLiving entityLiving : entitiesToTransport) {
                Entity rider = entityLiving.field_70153_n;
                if (rider == null || !entitiesToTransport.contains(rider)) continue;
                removes.add(entityLiving);
            }
            entitiesToTransport.removeAll(removes);
            int i = waypoint.getXCoord();
            int n = waypoint.getZCoord();
            world.field_73059_b.func_73154_d(i >> 4, n >> 4);
            int j = waypoint.getYCoord((World)world, i, n);
            Entity playerMount = entityplayer.field_70154_o;
            entityplayer.func_70078_a(null);
            entityplayer.func_70634_a((double)i + 0.5, (double)j, (double)n + 0.5);
            entityplayer.field_70143_R = 0.0f;
            if (playerMount instanceof EntityLiving) {
                playerMount = this.fastTravelEntity(world, (EntityLiving)playerMount, i, j, n);
            }
            if (playerMount != null) {
                this.setUUIDToMount(playerMount.func_110124_au());
            }
            for (EntityLiving entityLiving : entitiesToTransport) {
                Entity mount = entityLiving.field_70154_o;
                entityLiving.func_70078_a(null);
                EntityLiving entityLiving2 = this.fastTravelEntity(world, entityLiving, i, j, n);
                if (!(mount instanceof EntityLiving)) continue;
                mount = this.fastTravelEntity(world, (EntityLiving)mount, i, j, n);
                entityLiving2.func_70078_a(mount);
            }
            this.sendFTPacket(entityplayer, waypoint, startX, startZ);
            this.setTimeSinceFT(0);
            this.incrementWPUseCount(waypoint);
            if (waypoint instanceof LOTRWaypoint) {
                this.lastWaypoint = (LOTRWaypoint)waypoint;
                this.markDirty();
            }
            if (waypoint instanceof LOTRCustomWaypoint) {
                LOTRCustomWaypointLogger.logTravel((EntityPlayer)entityplayer, (LOTRCustomWaypoint)waypoint);
            }
        }
    }

    private void sendFTPacket(EntityPlayerMP entityplayer, LOTRAbstractWaypoint waypoint, int startX, int startZ) {
        LOTRPacketFTScreen packet = new LOTRPacketFTScreen(waypoint, startX, startZ);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    private <T extends EntityLiving> T fastTravelEntity(WorldServer world, T entity, int i, int j, int k) {
        String entityID = EntityList.func_75621_b(entity);
        NBTTagCompound nbt = new NBTTagCompound();
        entity.func_70109_d(nbt);
        entity.func_70106_y();
        EntityLiving newEntity = (EntityLiving)EntityList.func_75620_a((String)entityID, (World)world);
        newEntity.func_70020_e(nbt);
        newEntity.func_70012_b((double)i + 0.5, (double)j, (double)k + 0.5, newEntity.field_70177_z, newEntity.field_70125_A);
        newEntity.field_70143_R = 0.0f;
        newEntity.func_70661_as().func_75499_g();
        newEntity.func_70624_b(null);
        world.func_72838_d((Entity)newEntity);
        world.func_72866_a((Entity)newEntity, false);
        return (T)newEntity;
    }

    public boolean canFastTravel() {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null) {
            World world = entityplayer.field_70170_p;
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                double range = 16.0;
                List entities = world.func_72872_a(EntityLiving.class, entityplayer.field_70121_D.func_72314_b(range, range, range));
                for (int l = 0; l < entities.size(); ++l) {
                    EntityLiving entityliving = (EntityLiving)entities.get(l);
                    if (entityliving.func_70638_az() != entityplayer) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int getTimeSinceFT() {
        return this.ftSinceTick;
    }

    public void setTimeSinceFT(int i) {
        EntityPlayer entityplayer;
        boolean bigChange;
        int preTick = this.ftSinceTick;
        this.ftSinceTick = i = Math.max(0, i);
        boolean bl = bigChange = (this.ftSinceTick == 0 || preTick == 0) && this.ftSinceTick != preTick || preTick < 0 && this.ftSinceTick >= 0;
        if (bigChange || LOTRPlayerData.isTimerAutosaveTick()) {
            this.markDirty();
        }
        if ((bigChange || this.ftSinceTick % 5 == 0) && (entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketFTTimer packet = new LOTRPacketFTTimer(this.ftSinceTick);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    private void setUUIDToMount(UUID uuid) {
        this.uuidToMount = uuid;
        this.uuidToMountTime = this.uuidToMount != null ? 10 : 0;
        this.markDirty();
    }

    public LOTRAbstractWaypoint getTargetFTWaypoint() {
        return this.targetFTWaypoint;
    }

    public void setTargetFTWaypoint(LOTRAbstractWaypoint wp) {
        this.targetFTWaypoint = wp;
        this.markDirty();
        if (wp != null) {
            this.setTicksUntilFT(ticksUntilFT_max);
        } else {
            this.setTicksUntilFT(0);
        }
    }

    public int getTicksUntilFT() {
        return this.ticksUntilFT;
    }

    public void setTicksUntilFT(int i) {
        if (this.ticksUntilFT != i) {
            this.ticksUntilFT = i;
            if (this.ticksUntilFT == ticksUntilFT_max || this.ticksUntilFT == 0) {
                this.markDirty();
            }
        }
    }

    public void cancelFastTravel() {
        if (this.targetFTWaypoint != null) {
            this.setTargetFTWaypoint(null);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.fastTravel.motion", new Object[0]));
            }
        }
    }

    public boolean isFTRegionUnlocked(LOTRWaypoint.Region region) {
        return this.unlockedFTRegions.contains((Object)region);
    }

    public void unlockFTRegion(LOTRWaypoint.Region region) {
        if (this.isSiegeActive()) {
            return;
        }
        if (this.unlockedFTRegions.add(region)) {
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketWaypointRegion packet = new LOTRPacketWaypointRegion(region, true);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        }
    }

    public void lockFTRegion(LOTRWaypoint.Region region) {
        if (this.unlockedFTRegions.remove((Object)region)) {
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketWaypointRegion packet = new LOTRPacketWaypointRegion(region, false);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        }
    }

    public List<LOTRAbstractWaypoint> getAllAvailableWaypoints() {
        ArrayList<LOTRAbstractWaypoint> waypoints = new ArrayList<LOTRAbstractWaypoint>();
        waypoints.addAll(LOTRWaypoint.listAllWaypoints());
        waypoints.addAll(this.getCustomWaypoints());
        waypoints.addAll(this.customWaypointsShared);
        return waypoints;
    }

    public List<LOTRCustomWaypoint> getCustomWaypoints() {
        return this.customWaypoints;
    }

    public LOTRCustomWaypoint getCustomWaypointByID(int ID) {
        for (LOTRCustomWaypoint waypoint : this.customWaypoints) {
            if (waypoint.getID() != ID) continue;
            return waypoint;
        }
        return null;
    }

    public void addCustomWaypoint(LOTRCustomWaypoint waypoint) {
        this.customWaypoints.add(waypoint);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketCreateCWPClient packet = waypoint.getClientPacket();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            LOTRCustomWaypoint shareCopy = waypoint.createCopyOfShared(this.playerUUID);
            List<UUID> sharedPlayers = shareCopy.getPlayersInAllSharedFellowships();
            for (UUID player : sharedPlayers) {
                LOTRLevelData.getData(player).addOrUpdateSharedCustomWaypoint(shareCopy);
            }
            LOTRCustomWaypointLogger.logCreate(entityplayer, waypoint);
        }
    }

    public void removeCustomWaypoint(LOTRCustomWaypoint waypoint) {
        if (this.customWaypoints.remove(waypoint)) {
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketDeleteCWPClient packet = waypoint.getClientDeletePacket();
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
                LOTRCustomWaypoint shareCopy = waypoint.createCopyOfShared(this.playerUUID);
                List<UUID> sharedPlayers = shareCopy.getPlayersInAllSharedFellowships();
                for (UUID player : sharedPlayers) {
                    LOTRLevelData.getData(player).removeSharedCustomWaypoint(shareCopy);
                }
                LOTRCustomWaypointLogger.logDelete(entityplayer, waypoint);
            }
        }
    }

    public void renameCustomWaypoint(LOTRCustomWaypoint waypoint, String newName) {
        waypoint.rename(newName);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketRenameCWPClient packet = waypoint.getClientRenamePacket();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            LOTRCustomWaypoint shareCopy = waypoint.createCopyOfShared(this.playerUUID);
            List<UUID> sharedPlayers = shareCopy.getPlayersInAllSharedFellowships();
            for (UUID player : sharedPlayers) {
                LOTRLevelData.getData(player).renameSharedCustomWaypoint(shareCopy, newName);
            }
            LOTRCustomWaypointLogger.logRename(entityplayer, waypoint);
        }
    }

    public void customWaypointAddSharedFellowship(LOTRCustomWaypoint waypoint, LOTRFellowship fs) {
        UUID fsID = fs.getFellowshipID();
        waypoint.addSharedFellowship(fsID);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketShareCWPClient packet = waypoint.getClientAddFellowshipPacket(fsID);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
        LOTRCustomWaypoint shareCopy = waypoint.createCopyOfShared(this.playerUUID);
        for (UUID player : fs.getAllPlayerUUIDs()) {
            if (player.equals(this.playerUUID)) continue;
            LOTRLevelData.getData(player).addOrUpdateSharedCustomWaypoint(shareCopy);
        }
    }

    public void customWaypointAddSharedFellowshipClient(LOTRCustomWaypoint waypoint, LOTRFellowshipClient fs) {
        waypoint.addSharedFellowship(fs.getFellowshipID());
    }

    public void customWaypointRemoveSharedFellowship(LOTRCustomWaypoint waypoint, LOTRFellowship fs) {
        UUID fsID = fs.getFellowshipID();
        waypoint.removeSharedFellowship(fsID);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketShareCWPClient packet = waypoint.getClientRemoveFellowshipPacket(fsID);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
        LOTRCustomWaypoint shareCopy = waypoint.createCopyOfShared(this.playerUUID);
        for (UUID player : fs.getAllPlayerUUIDs()) {
            if (player.equals(this.playerUUID)) continue;
            LOTRPlayerData pd = LOTRLevelData.getData(player);
            pd.addOrUpdateSharedCustomWaypoint(shareCopy);
            pd.removeSharedCustomWaypoints();
        }
    }

    public void customWaypointRemoveSharedFellowshipClient(LOTRCustomWaypoint waypoint, LOTRFellowshipClient fs) {
        waypoint.removeSharedFellowship(fs.getFellowshipID());
    }

    public int getMaxCustomWaypoints() {
        int achievements = this.getEarnedAchievements(LOTRDimension.MIDDLE_EARTH).size();
        return 5 + achievements / 5;
    }

    public LOTRCustomWaypoint getSharedCustomWaypointByID(UUID owner, int id) {
        for (LOTRCustomWaypoint waypoint : this.customWaypointsShared) {
            if (!waypoint.getSharingPlayerID().equals(owner) || waypoint.getID() != id) continue;
            return waypoint;
        }
        return null;
    }

    public void addOrUpdateSharedCustomWaypoint(LOTRCustomWaypoint waypoint) {
        if (!waypoint.isShared()) {
            FMLLog.warning((String)"LOTR: Warning! Tried to cache a shared custom waypoint with no owner!", (Object[])new Object[0]);
            return;
        }
        CWPSharedKey key = CWPSharedKey.keyFor(waypoint.getSharingPlayerID(), waypoint.getID());
        if (this.cwpSharedUnlocked.contains((Object)key)) {
            waypoint.setSharedUnlocked();
        }
        waypoint.setSharedHidden(this.cwpSharedHidden.contains((Object)key));
        LOTRCustomWaypoint existing = this.getSharedCustomWaypointByID(waypoint.getSharingPlayerID(), waypoint.getID());
        if (existing == null) {
            this.customWaypointsShared.add(waypoint);
        } else {
            if (existing.isSharedUnlocked()) {
                waypoint.setSharedUnlocked();
            }
            waypoint.setSharedHidden(existing.isSharedHidden());
            int i = this.customWaypointsShared.indexOf(existing);
            this.customWaypointsShared.set(i, waypoint);
        }
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketCreateCWPClient packet = waypoint.getClientPacketShared();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void removeSharedCustomWaypoint(LOTRCustomWaypoint waypoint) {
        if (!waypoint.isShared()) {
            FMLLog.warning((String)"LOTR: Warning! Tried to remove a shared custom waypoint with no owner!", (Object[])new Object[0]);
            return;
        }
        LOTRCustomWaypoint existing = null;
        existing = this.customWaypointsShared.contains(waypoint) ? waypoint : this.getSharedCustomWaypointByID(waypoint.getSharingPlayerID(), waypoint.getID());
        if (existing != null) {
            this.customWaypointsShared.remove(existing);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketDeleteCWPClient packet = waypoint.getClientDeletePacketShared();
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        } else {
            FMLLog.warning((String)"LOTR: Warning! Tried to remove a shared custom waypoint that does not exist!", (Object[])new Object[0]);
        }
    }

    public void renameSharedCustomWaypoint(LOTRCustomWaypoint waypoint, String newName) {
        if (!waypoint.isShared()) {
            FMLLog.warning((String)"LOTR: Warning! Tried to rename a shared custom waypoint with no owner!", (Object[])new Object[0]);
            return;
        }
        waypoint.rename(newName);
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketRenameCWPClient packet = waypoint.getClientRenamePacketShared();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void unlockSharedCustomWaypoint(LOTRCustomWaypoint waypoint) {
        if (!waypoint.isShared()) {
            FMLLog.warning((String)"LOTR: Warning! Tried to unlock a shared custom waypoint with no owner!", (Object[])new Object[0]);
            return;
        }
        waypoint.setSharedUnlocked();
        CWPSharedKey key = CWPSharedKey.keyFor(waypoint.getSharingPlayerID(), waypoint.getID());
        this.cwpSharedUnlocked.add(key);
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketCWPSharedUnlockClient packet = waypoint.getClientSharedUnlockPacket();
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void hideOrUnhideSharedCustomWaypoint(LOTRCustomWaypoint waypoint, boolean hide) {
        if (!waypoint.isShared()) {
            FMLLog.warning((String)"LOTR: Warning! Tried to unlock a shared custom waypoint with no owner!", (Object[])new Object[0]);
            return;
        }
        waypoint.setSharedHidden(hide);
        CWPSharedKey key = CWPSharedKey.keyFor(waypoint.getSharingPlayerID(), waypoint.getID());
        if (hide) {
            this.cwpSharedHidden.add(key);
        } else {
            this.cwpSharedHidden.remove((Object)key);
        }
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketCWPSharedHideClient packet = waypoint.getClientSharedHidePacket(hide);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public int getWaypointFTTime(LOTRAbstractWaypoint wp, EntityPlayer entityplayer) {
        int baseMin = LOTRLevelData.getWaypointCooldownMin();
        int baseMax = LOTRLevelData.getWaypointCooldownMax();
        int useCount = this.getWPUseCount(wp);
        double dist = entityplayer.func_70011_f((double)wp.getXCoord() + 0.5, (double)wp.getYCoordSaved(), (double)wp.getZCoord() + 0.5);
        double time = baseMin;
        double added = (double)(baseMax - baseMin) * Math.pow(0.9, useCount);
        time += added;
        int seconds = (int)Math.round(time *= Math.max(1.0, dist * 1.2E-5));
        seconds = Math.max(seconds, 0);
        return seconds * 20;
    }

    public int getWPUseCount(LOTRAbstractWaypoint wp) {
        if (wp instanceof LOTRCustomWaypoint) {
            LOTRCustomWaypoint cwp = (LOTRCustomWaypoint)wp;
            int ID = cwp.getID();
            if (cwp.isShared()) {
                UUID sharingPlayer = cwp.getSharingPlayerID();
                CWPSharedKey key = CWPSharedKey.keyFor(sharingPlayer, ID);
                if (this.cwpSharedUseCounts.containsKey((Object)key)) {
                    return this.cwpSharedUseCounts.get((Object)key);
                }
            } else if (this.cwpUseCounts.containsKey(ID)) {
                return this.cwpUseCounts.get(ID);
            }
        } else if (this.wpUseCounts.containsKey(wp)) {
            return this.wpUseCounts.get(wp);
        }
        return 0;
    }

    public void setWPUseCount(LOTRAbstractWaypoint wp, int count) {
        if (wp instanceof LOTRCustomWaypoint) {
            LOTRCustomWaypoint cwp = (LOTRCustomWaypoint)wp;
            int ID = cwp.getID();
            if (cwp.isShared()) {
                UUID sharingPlayer = cwp.getSharingPlayerID();
                CWPSharedKey key = CWPSharedKey.keyFor(sharingPlayer, ID);
                this.cwpSharedUseCounts.put(key, count);
            } else {
                this.cwpUseCounts.put(ID, count);
            }
        } else {
            this.wpUseCounts.put((LOTRWaypoint)wp, count);
        }
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketWaypointUseCount packet = new LOTRPacketWaypointUseCount(wp, count);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void incrementWPUseCount(LOTRAbstractWaypoint wp) {
        this.setWPUseCount(wp, this.getWPUseCount(wp) + 1);
    }

    public int getNextCwpID() {
        return this.nextCwpID;
    }

    public void incrementNextCwpID() {
        ++this.nextCwpID;
        this.markDirty();
    }

    private void addSharedCustomWaypoints(UUID oneFellowshipID) {
        List<UUID> checkFellowshipIDs;
        ArrayList<UUID> fellowPlayerIDs = new ArrayList<UUID>();
        if (oneFellowshipID != null) {
            checkFellowshipIDs = new ArrayList<UUID>();
            checkFellowshipIDs.add(oneFellowshipID);
        } else {
            checkFellowshipIDs = this.fellowshipIDs;
        }
        for (UUID fsID : checkFellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null) continue;
            List<UUID> playerIDs = fs.getAllPlayerUUIDs();
            for (UUID player : playerIDs) {
                if (player.equals(this.playerUUID) || fellowPlayerIDs.contains(player)) continue;
                fellowPlayerIDs.add(player);
            }
        }
        for (UUID player : fellowPlayerIDs) {
            LOTRPlayerData pd = LOTRLevelData.getData(player);
            List<LOTRCustomWaypoint> cwps = pd.getCustomWaypoints();
            for (LOTRCustomWaypoint waypoint : cwps) {
                boolean inSharedFellowship = false;
                for (UUID fsID : checkFellowshipIDs) {
                    if (!waypoint.hasSharedFellowship(fsID)) continue;
                    inSharedFellowship = true;
                    break;
                }
                if (!inSharedFellowship) continue;
                this.addOrUpdateSharedCustomWaypoint(waypoint.createCopyOfShared(player));
            }
        }
    }

    private void removeSharedCustomWaypoints() {
        ArrayList<LOTRCustomWaypoint> removes = new ArrayList<LOTRCustomWaypoint>();
        for (LOTRCustomWaypoint waypoint : this.customWaypointsShared) {
            List<UUID> sharedFellowPlayers;
            LOTRCustomWaypoint wpOriginal = LOTRLevelData.getData(waypoint.getSharingPlayerID()).getCustomWaypointByID(waypoint.getID());
            if (wpOriginal == null || (sharedFellowPlayers = wpOriginal.getPlayersInAllSharedFellowships()).contains(this.playerUUID)) continue;
            removes.add(waypoint);
        }
        for (LOTRCustomWaypoint waypoint : removes) {
            this.removeSharedCustomWaypoint(waypoint);
        }
    }

    private void unlockSharedCustomWaypoints(EntityPlayer entityplayer) {
        if (this.pdTick % 20 == 0 && entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) {
            ArrayList<LOTRCustomWaypoint> unlockWaypoints = new ArrayList<LOTRCustomWaypoint>();
            for (LOTRCustomWaypoint waypoint : this.customWaypointsShared) {
                if (!waypoint.isShared() || waypoint.isSharedUnlocked() || !waypoint.canUnlockShared(entityplayer)) continue;
                unlockWaypoints.add(waypoint);
            }
            for (LOTRCustomWaypoint waypoint : unlockWaypoints) {
                this.unlockSharedCustomWaypoint(waypoint);
            }
        }
    }

    public List<UUID> getFellowshipIDs() {
        return this.fellowshipIDs;
    }

    public List<LOTRFellowship> getFellowships() {
        ArrayList<LOTRFellowship> fellowships = new ArrayList<LOTRFellowship>();
        for (UUID fsID : this.fellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null || fs.isDisbanded()) continue;
            fellowships.add(fs);
        }
        return fellowships;
    }

    public LOTRFellowship getFellowshipByName(String fsName) {
        for (UUID fsID : this.fellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null || fs.isDisbanded() || !fs.getName().equalsIgnoreCase(fsName)) continue;
            return fs;
        }
        return null;
    }

    public List<String> listAllFellowshipNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (UUID fsID : this.fellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null || fs.isDisbanded() || !fs.containsPlayer(this.playerUUID)) continue;
            list.add(fs.getName());
        }
        return list;
    }

    public List<String> listAllLeadingFellowshipNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (UUID fsID : this.fellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null || fs.isDisbanded() || !fs.isOwner(this.playerUUID)) continue;
            list.add(fs.getName());
        }
        return list;
    }

    public void addFellowship(LOTRFellowship fs) {
        UUID fsID;
        if (fs.containsPlayer(this.playerUUID) && !this.fellowshipIDs.contains(fsID = fs.getFellowshipID())) {
            this.fellowshipIDs.add(fsID);
            this.markDirty();
            this.sendFellowshipPacket(fs);
            this.addSharedCustomWaypoints(fs.getFellowshipID());
        }
    }

    public void removeFellowship(LOTRFellowship fs) {
        UUID fsID;
        if ((fs.isDisbanded() || !fs.containsPlayer(this.playerUUID)) && this.fellowshipIDs.contains(fsID = fs.getFellowshipID())) {
            this.fellowshipIDs.remove(fsID);
            this.markDirty();
            this.sendFellowshipRemovePacket(fs);
            this.removeSharedCustomWaypoints();
        }
    }

    public void updateFellowship(LOTRFellowship fs, FellowshipUpdateType updateType) {
        if (updateType == FellowshipUpdateType.FULL) {
            this.sendFellowshipPacket(fs);
        } else {
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketFellowshipPartialUpdate partialUpdatePacket = null;
                if (updateType == FellowshipUpdateType.RENAME) {
                    partialUpdatePacket = new LOTRPacketFellowshipPartialUpdate.Rename(fs);
                } else if (updateType == FellowshipUpdateType.CHANGE_ICON) {
                    partialUpdatePacket = new LOTRPacketFellowshipPartialUpdate.ChangeIcon(fs);
                } else if (updateType == FellowshipUpdateType.TOGGLE_PVP) {
                    partialUpdatePacket = new LOTRPacketFellowshipPartialUpdate.TogglePvp(fs);
                } else if (updateType == FellowshipUpdateType.TOGGLE_HIRED_FRIENDLY_FIRE) {
                    partialUpdatePacket = new LOTRPacketFellowshipPartialUpdate.ToggleHiredFriendlyFire(fs);
                } else if (updateType == FellowshipUpdateType.TOGGLE_SHOW_MAP_LOCATIONS) {
                    partialUpdatePacket = new LOTRPacketFellowshipPartialUpdate.ToggleShowMap(fs);
                }
                if (partialUpdatePacket != null) {
                    LOTRPacketHandler.networkWrapper.sendTo((IMessage)partialUpdatePacket, (EntityPlayerMP)entityplayer);
                } else {
                    LOTRLog.logger.error("No associated packet for fellowship partial update type " + updateType.name());
                }
            }
        }
        this.addSharedCustomWaypoints(fs.getFellowshipID());
        this.removeSharedCustomWaypoints();
    }

    public void createFellowship(String name, boolean normalCreation) {
        if (!(!normalCreation || LOTRConfig.enableFellowshipCreation && this.canCreateFellowships(false))) {
            return;
        }
        if (!this.anyMatchingFellowshipNames(name, false)) {
            LOTRFellowship fellowship = new LOTRFellowship(this.playerUUID, name);
            fellowship.createAndRegister();
        }
    }

    public boolean canCreateFellowships(boolean client) {
        int max = this.getMaxLeadingFellowships();
        int leading = 0;
        if (client) {
            for (LOTRFellowshipClient fs : this.fellowshipsClient) {
                if (!fs.isOwned() || ++leading < max) continue;
                return false;
            }
        } else {
            for (UUID fsID : this.fellowshipIDs) {
                LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
                if (fs == null || fs.isDisbanded() || !fs.isOwner(this.playerUUID) || ++leading < max) continue;
                return false;
            }
        }
        return leading < max;
    }

    private int getMaxLeadingFellowships() {
        int achievements = this.getEarnedAchievements(LOTRDimension.MIDDLE_EARTH).size();
        return 1 + achievements / 20;
    }

    public void disbandFellowship(LOTRFellowship fs) {
        if (fs.isOwner(this.playerUUID)) {
            ArrayList<UUID> memberUUIDs = new ArrayList<UUID>(fs.getMemberUUIDs());
            fs.disband();
            this.removeFellowship(fs);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                for (UUID memberID : memberUUIDs) {
                    EntityPlayer member = this.getOtherPlayer(memberID);
                    if (member == null) continue;
                    fs.sendNotification(member, "lotr.gui.fellowships.notifyDisband", entityplayer.func_70005_c_());
                }
            }
        }
    }

    public void invitePlayerToFellowship(LOTRFellowship fs, UUID player) {
        if (fs.isOwner(this.playerUUID) || fs.isAdmin(this.playerUUID)) {
            LOTRLevelData.getData(player).addFellowshipInvite(fs, this.playerUUID);
        }
    }

    public void removePlayerFromFellowship(LOTRFellowship fs, UUID player) {
        if (fs.isOwner(this.playerUUID) || fs.isAdmin(this.playerUUID)) {
            EntityPlayer removed;
            fs.removeMember(player);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K && (removed = this.getOtherPlayer(player)) != null) {
                fs.sendNotification(removed, "lotr.gui.fellowships.notifyRemove", entityplayer.func_70005_c_());
            }
        }
    }

    public void transferFellowship(LOTRFellowship fs, UUID player) {
        if (fs.isOwner(this.playerUUID)) {
            EntityPlayer newOwner;
            fs.setOwner(player);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K && (newOwner = this.getOtherPlayer(player)) != null) {
                fs.sendNotification(newOwner, "lotr.gui.fellowships.notifyTransfer", entityplayer.func_70005_c_());
            }
        }
    }

    public void setFellowshipAdmin(LOTRFellowship fs, UUID player, boolean flag) {
        if (fs.isOwner(this.playerUUID)) {
            EntityPlayer otherPlayer;
            fs.setAdmin(player, flag);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K && (otherPlayer = this.getOtherPlayer(player)) != null) {
                if (flag) {
                    fs.sendNotification(otherPlayer, "lotr.gui.fellowships.notifyOp", entityplayer.func_70005_c_());
                } else {
                    fs.sendNotification(otherPlayer, "lotr.gui.fellowships.notifyDeop", entityplayer.func_70005_c_());
                }
            }
        }
    }

    public void renameFellowship(LOTRFellowship fs, String name) {
        if (fs.isOwner(this.playerUUID)) {
            fs.setName(name);
        }
    }

    public void setFellowshipIcon(LOTRFellowship fs, ItemStack itemstack) {
        if (fs.isOwner(this.playerUUID) || fs.isAdmin(this.playerUUID)) {
            fs.setIcon(itemstack);
        }
    }

    public void setFellowshipPreventPVP(LOTRFellowship fs, boolean prevent) {
        if (fs.isOwner(this.playerUUID) || fs.isAdmin(this.playerUUID)) {
            fs.setPreventPVP(prevent);
        }
    }

    public void setFellowshipPreventHiredFF(LOTRFellowship fs, boolean prevent) {
        if (fs.isOwner(this.playerUUID) || fs.isAdmin(this.playerUUID)) {
            fs.setPreventHiredFriendlyFire(prevent);
        }
    }

    public void setFellowshipShowMapLocations(LOTRFellowship fs, boolean show) {
        if (fs.isOwner(this.playerUUID)) {
            fs.setShowMapLocations(show);
        }
    }

    public void leaveFellowship(LOTRFellowship fs) {
        if (!fs.isOwner(this.playerUUID)) {
            EntityPlayer owner;
            EntityPlayer entityplayer;
            fs.removeMember(this.playerUUID);
            if (this.fellowshipIDs.contains(fs.getFellowshipID())) {
                this.removeFellowship(fs);
            }
            if ((entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K && (owner = this.getOtherPlayer(fs.getOwner())) != null) {
                fs.sendNotification(owner, "lotr.gui.fellowships.notifyLeave", entityplayer.func_70005_c_());
            }
        }
    }

    private void sendFellowshipPacket(LOTRFellowship fs) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketFellowship packet = new LOTRPacketFellowship(this, fs, false);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    private void sendFellowshipRemovePacket(LOTRFellowship fs) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketFellowshipRemove packet = new LOTRPacketFellowshipRemove(fs, false);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public List<LOTRFellowshipClient> getClientFellowships() {
        return this.fellowshipsClient;
    }

    public boolean anyMatchingFellowshipNames(String name, boolean client) {
        name = StringUtils.strip((String)name).toLowerCase();
        if (client) {
            for (LOTRFellowshipClient fs : this.fellowshipsClient) {
                String otherName = fs.getName();
                if (!name.equals(otherName = StringUtils.strip((String)otherName).toLowerCase())) continue;
                return true;
            }
        } else {
            for (UUID fsID : this.fellowshipIDs) {
                LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
                if (fs == null || fs.isDisbanded()) continue;
                String otherName = fs.getName();
                if (!name.equals(otherName = StringUtils.strip((String)otherName).toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public void addOrUpdateClientFellowship(LOTRFellowshipClient fs) {
        UUID fsID = fs.getFellowshipID();
        LOTRFellowshipClient inList = null;
        for (LOTRFellowshipClient fsInList : this.fellowshipsClient) {
            if (!fsInList.getFellowshipID().equals(fsID)) continue;
            inList = fsInList;
            break;
        }
        if (inList != null) {
            inList.updateDataFrom(fs);
        } else {
            this.fellowshipsClient.add(fs);
        }
    }

    public void removeClientFellowship(UUID fsID) {
        LOTRFellowshipClient inList = null;
        for (LOTRFellowshipClient fsInList : this.fellowshipsClient) {
            if (!fsInList.getFellowshipID().equals(fsID)) continue;
            inList = fsInList;
            break;
        }
        if (inList != null) {
            this.fellowshipsClient.remove(inList);
        }
    }

    public LOTRFellowshipClient getClientFellowshipByName(String fsName) {
        for (LOTRFellowshipClient fs : this.fellowshipsClient) {
            if (!fs.getName().equalsIgnoreCase(fsName)) continue;
            return fs;
        }
        return null;
    }

    public LOTRFellowshipClient getClientFellowshipByID(UUID fsID) {
        for (LOTRFellowshipClient fs : this.fellowshipsClient) {
            if (!fs.getFellowshipID().equals(fsID)) continue;
            return fs;
        }
        return null;
    }

    public void addFellowshipInvite(LOTRFellowship fs, UUID inviterUUID) {
        UUID fsID = fs.getFellowshipID();
        boolean contains = false;
        for (LOTRFellowshipInvite invite : this.fellowshipInvites) {
            if (!invite.fellowshipID.equals(fsID)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            EntityPlayer inviter;
            this.fellowshipInvites.add(new LOTRFellowshipInvite(fsID, inviterUUID));
            this.markDirty();
            this.sendFellowshipInvitePacket(fs);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K && (inviter = this.getOtherPlayer(inviterUUID)) != null) {
                fs.sendNotification(entityplayer, "lotr.gui.fellowships.notifyInvite", inviter.func_70005_c_());
            }
        }
    }

    public void acceptFellowshipInvite(LOTRFellowship fs) {
        UUID fsID = fs.getFellowshipID();
        LOTRFellowshipInvite existingInvite = null;
        for (LOTRFellowshipInvite invite : this.fellowshipInvites) {
            if (!invite.fellowshipID.equals(fsID)) continue;
            existingInvite = invite;
            break;
        }
        if (existingInvite != null) {
            EntityPlayer entityplayer;
            if (!fs.isDisbanded()) {
                fs.addMember(this.playerUUID);
            }
            this.fellowshipInvites.remove(existingInvite);
            this.markDirty();
            this.sendFellowshipInviteRemovePacket(fs);
            if (!fs.isDisbanded() && (entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
                EntityPlayer inviter;
                UUID inviterID = existingInvite.inviterID;
                if (inviterID == null) {
                    inviterID = fs.getOwner();
                }
                if ((inviter = this.getOtherPlayer(inviterID)) != null) {
                    fs.sendNotification(inviter, "lotr.gui.fellowships.notifyAccept", entityplayer.func_70005_c_());
                }
            }
        }
    }

    public void rejectFellowshipInvite(LOTRFellowship fs) {
        UUID fsID = fs.getFellowshipID();
        LOTRFellowshipInvite existingInvite = null;
        for (LOTRFellowshipInvite invite : this.fellowshipInvites) {
            if (!invite.fellowshipID.equals(fsID)) continue;
            existingInvite = invite;
            break;
        }
        if (existingInvite != null) {
            this.fellowshipInvites.remove(existingInvite);
            this.markDirty();
            this.sendFellowshipInviteRemovePacket(fs);
        }
    }

    private void sendFellowshipInvitePacket(LOTRFellowship fs) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketFellowship packet = new LOTRPacketFellowship(this, fs, true);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    private void sendFellowshipInviteRemovePacket(LOTRFellowship fs) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketFellowshipRemove packet = new LOTRPacketFellowshipRemove(fs, true);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public List<LOTRFellowshipClient> getClientFellowshipInvites() {
        return this.fellowshipInvitesClient;
    }

    public void addOrUpdateClientFellowshipInvite(LOTRFellowshipClient fs) {
        UUID fsID = fs.getFellowshipID();
        LOTRFellowshipClient inList = null;
        for (LOTRFellowshipClient fsInList : this.fellowshipInvitesClient) {
            if (!fsInList.getFellowshipID().equals(fsID)) continue;
            inList = fsInList;
            break;
        }
        if (inList != null) {
            inList.updateDataFrom(fs);
        } else {
            this.fellowshipInvitesClient.add(fs);
        }
    }

    public void removeClientFellowshipInvite(UUID fsID) {
        LOTRFellowshipClient inList = null;
        for (LOTRFellowshipClient fsInList : this.fellowshipInvitesClient) {
            if (!fsInList.getFellowshipID().equals(fsID)) continue;
            inList = fsInList;
            break;
        }
        if (inList != null) {
            this.fellowshipInvitesClient.remove(inList);
        }
    }

    public UUID getChatBoundFellowshipID() {
        return this.chatBoundFellowshipID;
    }

    public LOTRFellowship getChatBoundFellowship() {
        LOTRFellowship fs;
        if (this.chatBoundFellowshipID != null && (fs = LOTRFellowshipData.getFellowship(this.chatBoundFellowshipID)) != null) {
            return fs;
        }
        return null;
    }

    public void setChatBoundFellowshipID(UUID fsID) {
        this.chatBoundFellowshipID = fsID;
        this.markDirty();
    }

    public void setChatBoundFellowship(LOTRFellowship fs) {
        this.setChatBoundFellowshipID(fs.getFellowshipID());
    }

    public void setSiegeActive(int duration) {
        this.siegeActiveTime = Math.max(this.siegeActiveTime, duration);
    }

    public boolean isSiegeActive() {
        return this.siegeActiveTime > 0;
    }

    public LOTRFaction getViewingFaction() {
        return this.viewingFaction;
    }

    public void setViewingFaction(LOTRFaction faction) {
        if (faction != null) {
            this.viewingFaction = faction;
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketUpdateViewingFaction packet = new LOTRPacketUpdateViewingFaction(this.viewingFaction);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        }
    }

    public LOTRFaction getRegionLastViewedFaction(LOTRDimension.DimensionRegion region) {
        LOTRFaction fac = this.prevRegionFactions.get((Object)region);
        if (fac == null) {
            fac = region.factionList.get(0);
            this.prevRegionFactions.put(region, fac);
        }
        return fac;
    }

    public void setRegionLastViewedFaction(LOTRDimension.DimensionRegion region, LOTRFaction fac) {
        if (region.factionList.contains((Object)fac)) {
            this.prevRegionFactions.put(region, fac);
            this.markDirty();
        }
    }

    public boolean showWaypoints() {
        return this.showWaypoints;
    }

    public void setShowWaypoints(boolean flag) {
        this.showWaypoints = flag;
        this.markDirty();
    }

    public boolean showCustomWaypoints() {
        return this.showCustomWaypoints;
    }

    public void setShowCustomWaypoints(boolean flag) {
        this.showCustomWaypoints = flag;
        this.markDirty();
    }

    public boolean showHiddenSharedWaypoints() {
        return this.showHiddenSharedWaypoints;
    }

    public void setShowHiddenSharedWaypoints(boolean flag) {
        this.showHiddenSharedWaypoints = flag;
        this.markDirty();
    }

    public boolean getHideMapLocation() {
        return this.hideOnMap;
    }

    public void setHideMapLocation(boolean flag) {
        this.hideOnMap = flag;
        this.markDirty();
        this.sendOptionsPacket(3, flag);
    }

    public boolean getAdminHideMap() {
        return this.adminHideMap;
    }

    public void setAdminHideMap(boolean flag) {
        this.adminHideMap = flag;
        this.markDirty();
    }

    public boolean getEnableConquestKills() {
        return this.conquestKills;
    }

    public void setEnableConquestKills(boolean flag) {
        this.conquestKills = flag;
        this.markDirty();
        this.sendOptionsPacket(5, flag);
    }

    public boolean getTeleportedME() {
        return this.teleportedME;
    }

    public void setTeleportedME(boolean flag) {
        this.teleportedME = flag;
        this.markDirty();
    }

    public ChunkCoordinates getDeathPoint() {
        return this.deathPoint;
    }

    public void setDeathPoint(int i, int j, int k) {
        this.deathPoint = new ChunkCoordinates(i, j, k);
        this.markDirty();
    }

    public int getDeathDimension() {
        return this.deathDim;
    }

    public void setDeathDimension(int dim) {
        this.deathDim = dim;
        this.markDirty();
    }

    public int getAlcoholTolerance() {
        return this.alcoholTolerance;
    }

    public void setAlcoholTolerance(int i) {
        EntityPlayer entityplayer;
        this.alcoholTolerance = i;
        this.markDirty();
        if (this.alcoholTolerance >= 250 && (entityplayer = this.getPlayer()) != null && !entityplayer.field_70170_p.field_72995_K) {
            this.addAchievement(LOTRAchievement.gainHighAlcoholTolerance);
        }
    }

    public List<LOTRMiniQuest> getMiniQuests() {
        return this.miniQuests;
    }

    public List<LOTRMiniQuest> getMiniQuestsCompleted() {
        return this.miniQuestsCompleted;
    }

    public void addMiniQuest(LOTRMiniQuest quest) {
        this.miniQuests.add(quest);
        this.updateMiniQuest(quest);
    }

    public void addMiniQuestCompleted(LOTRMiniQuest quest) {
        this.miniQuestsCompleted.add(quest);
        this.markDirty();
    }

    public void removeMiniQuest(LOTRMiniQuest quest, boolean completed) {
        List<LOTRMiniQuest> removeList = completed ? this.miniQuestsCompleted : this.miniQuests;
        if (removeList.remove(quest)) {
            this.markDirty();
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketMiniquestRemove packet = new LOTRPacketMiniquestRemove(quest, quest.isCompleted(), false);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        } else {
            FMLLog.warning((String)"Warning: Attempted to remove a miniquest which does not belong to the player data", (Object[])new Object[0]);
        }
    }

    public void updateMiniQuest(LOTRMiniQuest quest) {
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            try {
                this.sendMiniQuestPacket((EntityPlayerMP)entityplayer, quest, false);
            }
            catch (IOException e) {
                FMLLog.severe((String)("Error sending miniquest packet to player " + entityplayer.func_70005_c_()), (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void completeMiniQuest(LOTRMiniQuest quest) {
        if (this.miniQuests.remove(quest)) {
            this.addMiniQuestCompleted(quest);
            ++this.completedMiniquestCount;
            this.getFactionData(quest.entityFaction).completeMiniQuest();
            this.markDirty();
            LOTRMod.proxy.setTrackedQuest(quest);
            EntityPlayer entityplayer = this.getPlayer();
            if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
                LOTRPacketMiniquestRemove packet = new LOTRPacketMiniquestRemove(quest, false, true);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        } else {
            FMLLog.warning((String)"Warning: Attempted to remove a miniquest which does not belong to the player data", (Object[])new Object[0]);
        }
    }

    private void sendMiniQuestPacket(EntityPlayerMP entityplayer, LOTRMiniQuest quest, boolean completed) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        quest.writeToNBT(nbt);
        LOTRPacketMiniquest packet = new LOTRPacketMiniquest(nbt, completed);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    public LOTRMiniQuest getMiniQuestForID(UUID id, boolean completed) {
        ArrayList<LOTRMiniQuest> threadSafe = completed ? new ArrayList<LOTRMiniQuest>(this.miniQuestsCompleted) : new ArrayList<LOTRMiniQuest>(this.miniQuests);
        for (LOTRMiniQuest quest : threadSafe) {
            if (!quest.questUUID.equals(id)) continue;
            return quest;
        }
        return null;
    }

    public List<LOTRMiniQuest> getActiveMiniQuests() {
        return this.selectMiniQuests(new MiniQuestSelector.OptionalActive().setActiveOnly());
    }

    public List<LOTRMiniQuest> getMiniQuestsForEntity(LOTREntityNPC npc, boolean activeOnly) {
        return this.getMiniQuestsForEntityID(npc.func_110124_au(), activeOnly);
    }

    public List<LOTRMiniQuest> getMiniQuestsForEntityID(UUID npcID, boolean activeOnly) {
        MiniQuestSelector.EntityId sel = new MiniQuestSelector.EntityId(npcID);
        if (activeOnly) {
            sel.setActiveOnly();
        }
        return this.selectMiniQuests(sel);
    }

    public List<LOTRMiniQuest> getMiniQuestsForFaction(final LOTRFaction f, boolean activeOnly) {
        MiniQuestSelector.Faction sel = new MiniQuestSelector.Faction(new Supplier<LOTRFaction>(){

            public LOTRFaction get() {
                return f;
            }
        });
        if (activeOnly) {
            sel.setActiveOnly();
        }
        return this.selectMiniQuests(sel);
    }

    public List<LOTRMiniQuest> selectMiniQuests(MiniQuestSelector selector) {
        ArrayList<LOTRMiniQuest> ret = new ArrayList<LOTRMiniQuest>();
        ArrayList<LOTRMiniQuest> threadSafe = new ArrayList<LOTRMiniQuest>(this.miniQuests);
        for (LOTRMiniQuest quest : threadSafe) {
            if (!selector.include(quest)) continue;
            ret.add(quest);
        }
        return ret;
    }

    public int getCompletedMiniQuestsTotal() {
        return this.completedMiniquestCount;
    }

    public int getCompletedBountyQuests() {
        return this.completedBountyQuests;
    }

    public void addCompletedBountyQuest() {
        ++this.completedBountyQuests;
        this.markDirty();
    }

    public boolean hasActiveOrCompleteMQType(Class<? extends LOTRMiniQuest> type) {
        List<LOTRMiniQuest> quests = this.getMiniQuests();
        List<LOTRMiniQuest> questsComplete = this.getMiniQuestsCompleted();
        ArrayList<LOTRMiniQuest> allQuests = new ArrayList<LOTRMiniQuest>();
        for (LOTRMiniQuest q : quests) {
            if (!q.isActive()) continue;
            allQuests.add(q);
        }
        allQuests.addAll(questsComplete);
        for (LOTRMiniQuest q : allQuests) {
            if (!type.isAssignableFrom(q.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyGWQuest() {
        return this.hasActiveOrCompleteMQType(LOTRMiniQuestWelcome.class);
    }

    public void distributeMQEvent(LOTRMiniQuestEvent event) {
        for (LOTRMiniQuest quest : this.miniQuests) {
            if (!quest.isActive()) continue;
            quest.handleEvent(event);
        }
    }

    public LOTRMiniQuest getTrackingMiniQuest() {
        if (this.trackingMiniQuestID == null) {
            return null;
        }
        return this.getMiniQuestForID(this.trackingMiniQuestID, false);
    }

    public void setTrackingMiniQuest(LOTRMiniQuest quest) {
        this.setTrackingMiniQuestID(quest == null ? null : quest.questUUID);
    }

    public void setTrackingMiniQuestID(UUID npcID) {
        this.trackingMiniQuestID = npcID;
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketMiniquestTrackClient packet = new LOTRPacketMiniquestTrackClient(this.trackingMiniQuestID);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public void placeBountyFor(LOTRFaction f) {
        this.bountiesPlaced.add(f);
        this.markDirty();
    }

    public LOTRWaypoint getLastKnownWaypoint() {
        return this.lastWaypoint;
    }

    public LOTRBiome getLastKnownBiome() {
        return this.lastBiome;
    }

    public void sendMessageIfNotReceived(LOTRGuiMessageTypes message) {
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            Boolean sent = this.sentMessageTypes.get((Object)message);
            if (sent == null) {
                sent = false;
                this.sentMessageTypes.put(message, sent);
            }
            if (!sent.booleanValue()) {
                this.sentMessageTypes.put(message, true);
                this.markDirty();
                LOTRPacketMessage packet = new LOTRPacketMessage(message);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
            }
        }
    }

    public LOTRTitle.PlayerTitle getPlayerTitle() {
        return this.playerTitle;
    }

    public void setPlayerTitle(LOTRTitle.PlayerTitle title) {
        this.playerTitle = title;
        this.markDirty();
        EntityPlayer entityplayer = this.getPlayer();
        if (entityplayer != null && !entityplayer.field_70170_p.field_72995_K) {
            LOTRPacketTitle packet = new LOTRPacketTitle(this.playerTitle);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
        for (UUID fsID : this.fellowshipIDs) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null) continue;
            fs.updateForAllMembers(FellowshipUpdateType.FULL);
        }
    }

    public boolean getFemRankOverride() {
        return this.femRankOverride;
    }

    public void setFemRankOverride(boolean flag) {
        this.femRankOverride = flag;
        this.markDirty();
        this.sendOptionsPacket(4, flag);
    }

    public boolean useFeminineRanks() {
        if (this.femRankOverride) {
            return true;
        }
        if (this.playerTitle != null) {
            LOTRTitle title = this.playerTitle.getTitle();
            return title.isFeminineRank();
        }
        return false;
    }

    public LOTRPlayerQuestData getQuestData() {
        return this.questData;
    }

    private static class CWPSharedKey
    extends Pair<UUID, Integer> {
        public final UUID sharingPlayer;
        public final int waypointID;

        private CWPSharedKey(UUID player, int id) {
            this.sharingPlayer = player;
            this.waypointID = id;
        }

        public static CWPSharedKey keyFor(UUID player, int id) {
            return new CWPSharedKey(player, id);
        }

        public Integer setValue(Integer value) {
            throw new UnsupportedOperationException();
        }

        public UUID getLeft() {
            return this.sharingPlayer;
        }

        public Integer getRight() {
            return this.waypointID;
        }
    }
}

