/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.item.LOTRItemEntDraught;
import lotr.common.item.LOTRItemMug;
import lotr.common.recipe.LOTREntJarRecipes;
import lotr.common.tileentity.LOTRTileEntityEntJar;
import lotr.common.world.biome.LOTRBiomeGenFangorn;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class LOTRBlockEntJar
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] jarIcons;

    public LOTRBlockEntJar() {
        super(Material.field_151571_B);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.875f, 0.75f);
        this.func_149647_a(LOTRCreativeTabs.tabUtil);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new LOTRTileEntityEntJar();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return LOTRMod.proxy.getEntJarRenderID();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        return i == 0 || i == 1 ? this.jarIcons[0] : this.jarIcons[1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconregister) {
        this.jarIcons = new IIcon[2];
        this.jarIcons[0] = iconregister.func_94245_a(this.func_149641_N() + "_top");
        this.jarIcons[1] = iconregister.func_94245_a(this.func_149641_N() + "_side");
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        return world.func_147439_a(i, j - 1, k).isSideSolid((IBlockAccess)world, i, j - 1, k, ForgeDirection.UP);
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return this.func_149718_j(world, i, j, k);
    }

    public void func_149695_a(World world, int i, int j, int k, Block block) {
        if (!this.func_149718_j(world, i, j, k)) {
            this.func_149697_b(world, i, j, k, world.func_72805_g(i, j, k), 0);
            world.func_147468_f(i, j, k);
        }
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float f, float f1, float f2) {
        ItemStack itemstack = entityplayer.func_70694_bm();
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity instanceof LOTRTileEntityEntJar) {
            LOTRTileEntityEntJar jar = (LOTRTileEntityEntJar)tileentity;
            if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemEntDraught && jar.fillFromBowl(itemstack)) {
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151054_z));
                }
                world.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return true;
            }
            if (jar.drinkMeta >= 0) {
                ItemStack drink = new ItemStack(LOTRMod.entDraught, 1, jar.drinkMeta);
                if (itemstack != null && itemstack.func_77973_b() == Items.field_151054_z) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                    }
                    if (itemstack.field_77994_a <= 0) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, drink.func_77946_l());
                    } else if (!entityplayer.field_71071_by.func_70441_a(drink.func_77946_l())) {
                        entityplayer.func_71019_a(drink.func_77946_l(), false);
                    }
                    world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                    jar.consume();
                    return true;
                }
            } else if (itemstack != null) {
                ItemStack vesselFull;
                ItemStack vesselEmpty;
                ItemStack draught;
                BiomeGenBase biome = world.func_72807_a(i, k);
                if (biome instanceof LOTRBiomeGenFangorn && jar.drinkAmount > 0 && (draught = LOTREntJarRecipes.findMatchingRecipe(itemstack)) != null) {
                    jar.drinkMeta = draught.func_77960_j();
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                    }
                    if (!world.field_72995_K) {
                        world.func_72926_e(2005, i, j, k, 0);
                    }
                    return true;
                }
                if (jar.drinkAmount > 0) {
                    if (this.tryTakeWaterFromJar(jar, world, entityplayer, new ItemStack(Items.field_151133_ar), new ItemStack(Items.field_151131_as), LOTRTileEntityEntJar.MAX_CAPACITY)) {
                        return true;
                    }
                    for (LOTRItemMug.Vessel vessel : LOTRItemMug.Vessel.values()) {
                        vesselEmpty = vessel.getEmptyVessel();
                        vesselFull = new ItemStack(LOTRMod.mugWater);
                        LOTRItemMug.setVessel(vesselFull, vessel, true);
                        if (!this.tryTakeWaterFromJar(jar, world, entityplayer, vesselEmpty, vesselFull, 1)) continue;
                        return true;
                    }
                }
                if (jar.drinkAmount < LOTRTileEntityEntJar.MAX_CAPACITY) {
                    if (this.tryAddWaterToJar(jar, world, entityplayer, new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151133_ar), LOTRTileEntityEntJar.MAX_CAPACITY)) {
                        return true;
                    }
                    for (LOTRItemMug.Vessel vessel : LOTRItemMug.Vessel.values()) {
                        vesselEmpty = vessel.getEmptyVessel();
                        vesselFull = new ItemStack(LOTRMod.mugWater);
                        LOTRItemMug.setVessel(vesselFull, vessel, true);
                        if (!this.tryAddWaterToJar(jar, world, entityplayer, vesselFull, vesselEmpty, 1)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean tryTakeWaterFromJar(LOTRTileEntityEntJar jar, World world, EntityPlayer entityplayer, ItemStack container, ItemStack filled, int amount) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack.func_77973_b() != container.func_77973_b() || itemstack.func_77960_j() != container.func_77960_j()) {
            return false;
        }
        for (int i = 0; i < amount; ++i) {
            jar.consume();
        }
        world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled.func_77946_l());
            } else if (!entityplayer.field_71071_by.func_70441_a(filled.func_77946_l())) {
                entityplayer.func_71019_a(filled.func_77946_l(), false);
            }
        }
        return true;
    }

    private boolean tryAddWaterToJar(LOTRTileEntityEntJar jar, World world, EntityPlayer entityplayer, ItemStack filled, ItemStack container, int amount) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack.func_77973_b() != filled.func_77973_b() || itemstack.func_77960_j() != filled.func_77960_j()) {
            return false;
        }
        for (int i = 0; i < amount; ++i) {
            jar.fillWithWater();
        }
        world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, container.func_77946_l());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random random) {
        TileEntity tileentity;
        if (random.nextInt(4) == 0 && (tileentity = world.func_147438_o(i, j, k)) instanceof LOTRTileEntityEntJar) {
            LOTRTileEntityEntJar jar = (LOTRTileEntityEntJar)tileentity;
            if (jar.drinkMeta >= 0) {
                double d = (double)i + 0.25 + (double)(random.nextFloat() * 0.5f);
                double d1 = (double)j + 1.0;
                double d2 = (double)k + 0.25 + (double)(random.nextFloat() * 0.5f);
                world.func_72869_a("happyVillager", d, d1, d2, 0.0, 0.2, 0.0);
            }
        }
    }
}

