/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityGaladhrimWarrior;
import lotr.common.entity.npc.LOTRUnitTradeEntries;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.world.spawning.LOTRInvasions;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityGaladhrimLord
extends LOTREntityGaladhrimWarrior
implements LOTRUnitTradeable {
    public LOTREntityGaladhrimLord(World world) {
        super(world);
        this.addTargetTasks(false);
        this.npcCape = LOTRCapes.GALADHRIM;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.swordElven));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsElven));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsElven));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyElven));
        this.func_70062_b(4, null);
        return data;
    }

    @Override
    public float getAlignmentBonus() {
        return 5.0f;
    }

    @Override
    public LOTRUnitTradeEntries getUnits() {
        return LOTRUnitTradeEntries.ELF_LORD;
    }

    @Override
    public LOTRInvasions getWarhorn() {
        return LOTRInvasions.GALADHRIM;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 300.0f && this.isFriendlyAndAligned(entityplayer);
    }

    @Override
    public void onUnitTrade(EntityPlayer entityplayer) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeElfLord);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "galadhrim/lord/friendly";
            }
            return "galadhrim/lord/neutral";
        }
        return "galadhrim/warrior/hostile";
    }
}

