/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRCapes;
import lotr.common.LOTRGreyWandererTracker;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIGandalfSmoke;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.npc.LOTREntityBalrog;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntitySaruman;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestWelcome;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityGandalf
extends LOTREntityNPC {
    private static final double msgRange = 64.0;

    public LOTREntityGandalf(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.8, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIGandalfSmoke(this, 3000));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int target = this.addTargetTasks(false);
        this.field_70715_bh.func_75776_a(target + 1, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntityBalrog.class, 0, true));
        this.field_70715_bh.func_75776_a(target + 2, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntitySaruman.class, 0, true));
        this.npcCape = LOTRCapes.GANDALF;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.glamdring));
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.gandalfStaffGrey));
        return data;
    }

    @Override
    public void onArtificalSpawn() {
        LOTRGreyWandererTracker.addNewWanderer(this.func_110124_au());
        this.arriveAt(null);
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public ItemStack getHeldItemLeft() {
        ItemStack heldItem = this.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == LOTRMod.glamdring) {
            return new ItemStack(LOTRMod.gandalfStaffGrey);
        }
        return super.getHeldItemLeft();
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.UNALIGNED;
    }

    @Override
    public boolean canBeFreelyTargetedBy(EntityLiving attacker) {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return super.func_70097_a(damagesource, f);
        }
        f = 0.0f;
        return super.func_70097_a(damagesource, f);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !LOTRGreyWandererTracker.isWandererActive(this.func_110124_au()) && this.func_70638_az() == null) {
            this.depart();
        }
    }

    private void doGandalfFX() {
        this.func_85030_a("random.pop", 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 16) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70165_t + (double)(MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-1.0f, (float)1.0f) * this.field_70130_N);
                double d1 = this.field_70163_u + (double)(MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)1.0f) * this.field_70131_O);
                double d2 = this.field_70161_v + (double)(MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-1.0f, (float)1.0f) * this.field_70130_N);
                double d3 = this.field_70146_Z.nextGaussian() * 0.02;
                double d4 = 0.05 + this.field_70146_Z.nextGaussian() * 0.02;
                double d5 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a("explode", d0, d1, d2, d3, d4, d5);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    public void arriveAt(EntityPlayer entityplayer) {
        ArrayList<EntityPlayer> msgPlayers = new ArrayList<EntityPlayer>();
        if (entityplayer != null) {
            msgPlayers.add(entityplayer);
        }
        List worldPlayers = this.field_70170_p.field_73010_i;
        for (Object obj : worldPlayers) {
            EntityPlayer player = (EntityPlayer)obj;
            if (msgPlayers.contains(player)) continue;
            double d = 64.0;
            double dSq = d * d;
            if (!(this.func_70068_e((Entity)player) < dSq)) continue;
            msgPlayers.add(player);
        }
        for (EntityPlayer player : msgPlayers) {
            LOTRSpeech.sendSpeechBankWithChatMsg(player, this, "char/gandalf/arrive");
        }
        this.doGandalfFX();
    }

    private void depart() {
        ArrayList<EntityPlayer> msgPlayers = new ArrayList<EntityPlayer>();
        List worldPlayers = this.field_70170_p.field_73010_i;
        for (Object obj : worldPlayers) {
            EntityPlayer player = (EntityPlayer)obj;
            if (msgPlayers.contains(player)) continue;
            double d = 64.0;
            double dSq = d * d;
            if (!(this.func_70068_e((Entity)player) < dSq)) continue;
            msgPlayers.add(player);
        }
        for (EntityPlayer player : msgPlayers) {
            LOTRSpeech.sendSpeechBankWithChatMsg(player, this, "char/gandalf/depart");
        }
        this.doGandalfFX();
        this.func_70106_y();
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "char/gandalf/friendly";
        }
        return "char/gandalf/hostile";
    }

    @Override
    public boolean speakTo(EntityPlayer entityplayer) {
        if (LOTRGreyWandererTracker.isWandererActive(this.func_110124_au())) {
            if (this.questInfo.getOfferFor(entityplayer) != null) {
                return super.speakTo(entityplayer);
            }
            if (this.addMQOfferFor(entityplayer)) {
                LOTRGreyWandererTracker.setWandererActive(this.func_110124_au());
                String speechBank = "char/gandalf/welcome";
                this.sendSpeechBank(entityplayer, speechBank);
                return true;
            }
        }
        return super.speakTo(entityplayer);
    }

    private boolean addMQOfferFor(EntityPlayer entityplayer) {
        LOTRMiniQuestWelcome quest;
        LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
        if (pd.getMiniQuestsForEntity(this, true).isEmpty() && ((LOTRMiniQuest)(quest = new LOTRMiniQuestWelcome(null, this))).canPlayerAccept(entityplayer)) {
            this.questInfo.setPlayerSpecificOffer(entityplayer, quest);
            return true;
        }
        return false;
    }

    @Override
    public int getMiniquestColor() {
        return 0xA0A0A0;
    }
}

