/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIGollumAvoidEntity;
import lotr.common.entity.ai.LOTREntityAIGollumFishing;
import lotr.common.entity.ai.LOTREntityAIGollumFollowOwner;
import lotr.common.entity.ai.LOTREntityAIGollumPanic;
import lotr.common.entity.ai.LOTREntityAIGollumRemainStill;
import lotr.common.entity.npc.LOTRCharacter;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.inventory.LOTRInventoryNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class LOTREntityGollum
extends LOTREntityNPC
implements LOTRCharacter {
    public static int INV_ROWS = 3;
    private int eatingTick;
    public int prevFishTime = 400;
    public boolean isFishing;
    public LOTRInventoryNPC inventory = new LOTRInventoryNPC("gollum", this, INV_ROWS * 9);
    public int prevFishRequired;
    public int fishRequired = this.prevFishRequired = 20;

    public LOTREntityGollum(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.2f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIGollumRemainStill(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIGollumPanic(this, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIGollumAvoidEntity(this, LOTREntityOrc.class, 8.0f, 1.2, 1.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIGollumAvoidEntity(this, LOTREntityElf.class, 8.0f, 1.2, 1.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIGollumFishing(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIGollumFollowOwner(this, 1.2, 6.0f, 4.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.1f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public String getGollumOwnerUUID() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setGollumOwnerUUID(String s) {
        this.field_70180_af.func_75692_b(17, (Object)s);
    }

    public EntityPlayer getGollumOwner() {
        try {
            UUID uuid = UUID.fromString(this.getGollumOwnerUUID());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isGollumFleeing() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setGollumFleeing(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)(flag ? (byte)1 : 0));
    }

    public boolean isGollumSitting() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public void setGollumSitting(boolean flag) {
        this.field_70180_af.func_75692_b(19, (Object)(flag ? (byte)1 : 0));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.inventory.writeToNBT(nbt);
        nbt.func_74778_a("GollumOwnerUUID", this.getGollumOwnerUUID());
        nbt.func_74757_a("GollumSitting", this.isGollumSitting());
        nbt.func_74768_a("GollumFishTime", this.prevFishTime);
        nbt.func_74768_a("FishReq", this.fishRequired);
        nbt.func_74768_a("FishReqPrev", this.prevFishRequired);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.inventory.readFromNBT(nbt);
        if (nbt.func_74764_b("GollumOwnerUUID")) {
            this.setGollumOwnerUUID(nbt.func_74779_i("GollumOwnerUUID"));
        }
        this.setGollumSitting(nbt.func_74767_n("GollumSitting"));
        this.prevFishTime = nbt.func_74762_e("GollumFishTime");
        if (nbt.func_74764_b("FishReq")) {
            this.fishRequired = nbt.func_74762_e("FishReq");
            this.prevFishRequired = nbt.func_74762_e("FishReqPrev");
        }
    }

    @Override
    public void func_70636_d() {
        double d;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(500) == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.eatingTick > 0) {
            if (this.eatingTick % 4 == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            --this.eatingTick;
        }
        if (this.prevFishTime > 0) {
            --this.prevFishTime;
        }
        if (this.isGollumSitting() && !this.field_70170_p.field_72995_K && this.field_70122_E) {
            this.func_70683_ar().func_75660_a();
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) != null && this.getGollumOwner() != null && (d = this.func_70068_e((Entity)this.getGollumOwner())) < 4.0) {
            this.func_70671_ap().func_75651_a((Entity)this.getGollumOwner(), 100.0f, 100.0f);
            this.func_70671_ap().func_75649_a();
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.func_71124_b(0));
            entityitem.field_145804_b = 40;
            float f = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f1 = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w += Math.cos(f1) * (double)(f *= this.field_70146_Z.nextFloat());
            entityitem.field_70181_x += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f1) * (double)f;
            this.field_70170_p.func_72838_d((Entity)entityitem);
            this.func_70062_b(0, null);
        }
        if (!this.field_70170_p.field_72995_K && StringUtils.func_151246_b((String)this.getGollumOwnerUUID()) && this.field_70146_Z.nextInt(40) == 0) {
            List nearbyPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(80.0, 80.0, 80.0));
            for (EntityPlayer entityplayer : nearbyPlayers) {
                double d2 = this.func_70032_d((Entity)entityplayer);
                int chance = (int)(d2 / 8.0);
                if (this.field_70146_Z.nextInt(chance = Math.max(2, chance)) != 0) continue;
                this.field_70170_p.func_72956_a((Entity)entityplayer, this.func_70639_aQ(), this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getGollumOwner() != null && entityplayer == this.getGollumOwner()) {
                ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
                if (itemstack != null && itemstack.func_77973_b() instanceof ItemFood && this.canGollumEat(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                        if (itemstack.field_77994_a <= 0) {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                        }
                    }
                    this.func_70691_i(((ItemFood)itemstack.func_77973_b()).func_150905_g(itemstack));
                    this.eatingTick = 20;
                    return true;
                }
                if (entityplayer.func_70093_af()) {
                    entityplayer.openGui((Object)LOTRMod.instance, 10, this.field_70170_p, this.func_145782_y(), 0, 0);
                    return true;
                }
                this.setGollumSitting(!this.isGollumSitting());
                if (this.isGollumSitting()) {
                    LOTRSpeech.sendSpeech(this.getGollumOwner(), this, LOTRSpeech.getRandomSpeechForPlayer(this, "char/gollum/stay", this.getGollumOwner()));
                } else {
                    LOTRSpeech.sendSpeech(this.getGollumOwner(), this, LOTRSpeech.getRandomSpeechForPlayer(this, "char/gollum/follow", this.getGollumOwner()));
                }
                return true;
            }
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151115_aP) {
                boolean tamed = false;
                if (itemstack.field_77994_a >= this.fishRequired) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        itemstack.field_77994_a -= this.fishRequired;
                        if (itemstack.field_77994_a <= 0) {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                        }
                    }
                    this.fishRequired = 0;
                } else {
                    this.fishRequired -= itemstack.field_77994_a;
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                    }
                }
                this.eatingTick = 20;
                if (this.fishRequired <= 0) {
                    this.setGollumOwnerUUID(entityplayer.func_110124_au().toString());
                    LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tameGollum);
                    LOTRSpeech.sendSpeech(entityplayer, this, LOTRSpeech.getRandomSpeechForPlayer(this, "char/gollum/tame", entityplayer));
                    LOTRSpeech.messageAllPlayers((IChatComponent)new ChatComponentTranslation("chat.lotr.tameGollum", new Object[]{entityplayer.func_70005_c_(), this.func_70005_c_()}));
                    this.spawnHearts();
                    this.prevFishRequired = this.fishRequired = Math.round((float)this.prevFishRequired * (1.5f + this.field_70146_Z.nextFloat() * 0.25f));
                } else {
                    LOTRSpeech.sendSpeech(entityplayer, this, LOTRSpeech.getRandomSpeechForPlayer(this, "char/gollum/tameProgress", entityplayer));
                }
                return true;
            }
        }
        return super.func_70085_c(entityplayer);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (!this.isGollumFleeing()) {
            return "char/gollum/say";
        }
        return super.getSpeechBank(entityplayer);
    }

    private boolean canGollumEat(ItemStack itemstack) {
        if (itemstack.func_77973_b() == Items.field_151115_aP || itemstack.func_77973_b() == Items.field_151101_aQ) {
            return true;
        }
        ItemFood food = (ItemFood)itemstack.func_77973_b();
        return food.func_77845_h();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        EntityPlayer owner = this.getGollumOwner();
        if (owner != null && damagesource.func_76346_g() == owner) {
            f = 0.0f;
            if (!this.field_70170_p.field_72995_K) {
                LOTRSpeech.sendSpeech(owner, this, LOTRSpeech.getRandomSpeechForPlayer(this, "char/gollum/hurt", owner));
            }
        }
        if (super.func_70097_a(damagesource, f)) {
            this.setGollumSitting(false);
            return true;
        }
        return false;
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K && !StringUtils.func_151246_b((String)this.getGollumOwnerUUID())) {
            LOTRSpeech.messageAllPlayers(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K) {
            this.inventory.dropAllItems();
            LOTRLevelData.setGollumSpawned(false);
        }
    }

    @Override
    public boolean canDropRares() {
        return false;
    }

    public String func_70639_aQ() {
        return "lotr:gollum.say";
    }

    public String func_70621_aR() {
        return "lotr:gollum.hurt";
    }

    public String func_70673_aS() {
        return "lotr:gollum.death";
    }

    public String func_145777_O() {
        return super.func_145777_O();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            for (int i = 0; i < 4; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a(this.field_70146_Z.nextBoolean() ? "bubble" : "splash", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        return false;
    }
}

