/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIFarm;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAINPCHurtByTarget;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRFarmhand;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class LOTREntityHaradSlave
extends LOTREntityMan
implements LOTRFarmhand {
    public Item seedsItem;

    public LOTREntityHaradSlave(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.3, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFarm(this, 1.0, 1.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIEat(this, LOTRFoods.HARAD_SLAVE, 12000));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIDrink(this, LOTRFoods.HARAD_SLAVE_DRINK, 8000));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAINPCHurtByTarget(this, false));
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    public void setupNPCName() {
        this.field_70180_af.func_75682_a(20, (Object)0);
        float f = this.field_70146_Z.nextFloat();
        if (f < 0.05f) {
            this.setSlaveType(SlaveType.TAURETHRIM);
        } else if (f < 0.2f) {
            this.setSlaveType(SlaveType.MORWAITH);
        } else if (f < 0.7f) {
            this.setSlaveType(SlaveType.NEAR_HARAD);
        } else {
            this.setSlaveType(SlaveType.GONDOR);
        }
        SlaveType type = this.getSlaveType();
        if (type == SlaveType.GONDOR) {
            this.familyInfo.setName(LOTRNames.getGondorName(this.field_70146_Z, this.familyInfo.isMale()));
        } else if (type == SlaveType.NEAR_HARAD) {
            if (this.field_70146_Z.nextBoolean()) {
                this.familyInfo.setName(LOTRNames.getHarnennorName(this.field_70146_Z, this.familyInfo.isMale()));
            } else {
                this.familyInfo.setName(LOTRNames.getNomadName(this.field_70146_Z, this.familyInfo.isMale()));
            }
        } else if (type == SlaveType.MORWAITH) {
            this.familyInfo.setName(LOTRNames.getMoredainName(this.field_70146_Z, this.familyInfo.isMale()));
        } else if (type == SlaveType.TAURETHRIM) {
            this.familyInfo.setName(LOTRNames.getTauredainName(this.field_70146_Z, this.familyInfo.isMale()));
        }
    }

    public SlaveType getSlaveType() {
        int i = this.field_70180_af.func_75683_a(20);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)SlaveType.values().length);
        return SlaveType.values()[i];
    }

    public void setSlaveType(SlaveType t) {
        int i = t.ordinal();
        this.field_70180_af.func_75692_b(20, (Object)((byte)i));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.hoeBronze));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        return data;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public IPlantable getUnhiredSeeds() {
        if (this.seedsItem == null) {
            return (IPlantable)Items.field_151014_N;
        }
        return (IPlantable)this.seedsItem;
    }

    @Override
    public LOTRFaction getFaction() {
        return this.getSlaveType().faction;
    }

    @Override
    public LOTRFaction getHiringFaction() {
        return LOTRFaction.NEAR_HARAD;
    }

    @Override
    public boolean canBeFreelyTargetedBy(EntityLiving attacker) {
        if (!LOTRMod.getNPCFaction((Entity)attacker).isBadRelation(this.getHiringFaction())) {
            return false;
        }
        return super.canBeFreelyTargetedBy(attacker);
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("SlaveType", this.getSlaveType().saveName());
        if (this.seedsItem != null) {
            nbt.func_74768_a("SeedsID", Item.func_150891_b((Item)this.seedsItem));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        Item item;
        SlaveType type;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("SlaveType") && (type = SlaveType.forName(nbt.func_74779_i("SlaveType"))) != null) {
            this.setSlaveType(type);
        }
        if (nbt.func_74764_b("SeedsID") && (item = Item.func_150899_d((int)nbt.func_74762_e("SeedsID"))) != null && item instanceof IPlantable) {
            this.seedsItem = item;
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
            return "nearHarad/slave/hired";
        }
        return "nearHarad/slave/neutral";
    }

    public static enum SlaveType {
        GONDOR(LOTRFaction.GONDOR, "gondor"),
        NEAR_HARAD(LOTRFaction.NEAR_HARAD, "nearHarad"),
        MORWAITH(LOTRFaction.MORWAITH, "morwaith"),
        TAURETHRIM(LOTRFaction.TAURETHRIM, "taurethrim");

        public LOTRFaction faction;
        public String skinDir;

        private SlaveType(LOTRFaction f, String s) {
            this.faction = f;
            this.skinDir = s;
        }

        public String saveName() {
            return this.name();
        }

        public static SlaveType forName(String s) {
            for (SlaveType type : SlaveType.values()) {
                if (!type.saveName().equals(s)) continue;
                return type;
            }
            return null;
        }
    }
}

