/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.projectile.LOTREntityMarshWraithBall;
import lotr.common.fac.LOTRFaction;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityMarshWraith
extends LOTREntityNPC {
    public UUID attackTargetUUID;
    private boolean checkedForAttackTarget;
    private int timeUntilDespawn = -1;
    private static final int maxTimeUntilDespawn = 100;

    public LOTREntityMarshWraith(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LOTREntityAIRangedAttack(this, 1.6, 40, 12.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70158_ak = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public int getSpawnFadeTime() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setSpawnFadeTime(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    public int getDeathFadeTime() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setDeathFadeTime(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOSTILE;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("SpawnFadeTime", this.getSpawnFadeTime());
        nbt.func_74768_a("DeathFadeTime", this.getDeathFadeTime());
        if (this.attackTargetUUID != null) {
            nbt.func_74772_a("TargetUUIDMost", this.attackTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("TargetUUIDLeast", this.attackTargetUUID.getLeastSignificantBits());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSpawnFadeTime(nbt.func_74762_e("SpawnFadeTime"));
        this.setDeathFadeTime(nbt.func_74762_e("DeathFadeTime"));
        if (nbt.func_74764_b("TargetUUIDMost") && nbt.func_74764_b("TargetUUIDLeast")) {
            this.attackTargetUUID = new UUID(nbt.func_74763_f("TargetUUIDMost"), nbt.func_74763_f("TargetUUIDLeast"));
        }
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            int hover = 2;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            double newY = this.field_70163_u;
            for (int j1 = 0; j1 <= hover; ++j1) {
                int j2 = j - j1;
                Block block = this.field_70170_p.func_147439_a(i, j2, k);
                Material material = block.func_149688_o();
                if (!material.func_76220_a() && !material.func_76224_d()) continue;
                newY = Math.max(newY, (double)(j + j1 + 1));
            }
            this.field_70181_x += (newY - this.field_70163_u) * 0.04;
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            int i;
            if (this.func_70638_az() == null && this.attackTargetUUID != null && !this.checkedForAttackTarget) {
                for (i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (!(entity instanceof EntityLiving) || !entity.func_110124_au().equals(this.attackTargetUUID)) continue;
                    this.func_70624_b((EntityLivingBase)((EntityLiving)entity));
                    break;
                }
                this.checkedForAttackTarget = true;
            }
            if (this.getSpawnFadeTime() < 30) {
                this.setSpawnFadeTime(this.getSpawnFadeTime() + 1);
            }
            if (this.getDeathFadeTime() > 0) {
                this.setDeathFadeTime(this.getDeathFadeTime() - 1);
            }
            if (this.getSpawnFadeTime() == 30 && this.getDeathFadeTime() == 0) {
                if (this.func_70638_az() == null || this.func_70638_az().field_70128_L) {
                    this.setDeathFadeTime(30);
                } else {
                    int k;
                    int j;
                    if (this.timeUntilDespawn == -1) {
                        this.timeUntilDespawn = 100;
                    }
                    if (this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.func_70638_az().field_70165_t), j = MathHelper.func_76128_c((double)this.func_70638_az().field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.func_70638_az().field_70161_v)).func_149688_o() == Material.field_151586_h || this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o() == Material.field_151586_h) {
                        this.timeUntilDespawn = 100;
                    } else if (this.timeUntilDespawn > 0) {
                        --this.timeUntilDespawn;
                    } else {
                        this.setDeathFadeTime(30);
                        this.func_70624_b(null);
                    }
                }
            }
            if (this.getDeathFadeTime() == 1) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        if (this.getSpawnFadeTime() == 30 && this.getDeathFadeTime() == 0) {
            LOTREntityMarshWraithBall ball = new LOTREntityMarshWraithBall(this.field_70170_p, (EntityLivingBase)this, target);
            this.func_85030_a("lotr:wraith.marshWraith_shoot", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        ItemStack itemstack;
        boolean vulnerable = false;
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof EntityLivingBase && entity == damagesource.func_76364_f() && (itemstack = ((EntityLivingBase)entity).func_70694_bm()) != null && LOTREnchantmentHelper.hasEnchant(itemstack, LOTREnchantment.baneWraith)) {
            vulnerable = true;
        }
        if (vulnerable && this.getDeathFadeTime() == 0) {
            boolean flag = super.func_70097_a(damagesource, f);
            if (flag) {
                this.timeUntilDespawn = 100;
            }
            return flag;
        }
        return false;
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K) {
            this.setDeathFadeTime(30);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int flesh = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < flesh; ++l) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        this.dropChestContents(LOTRChestContents.MARSH_REMAINS, 1, 3 + i);
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killMarshWraith;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected String func_70621_aR() {
        return "lotr:wight.hurt";
    }

    protected String func_70673_aS() {
        return "lotr:wight.death";
    }

    public boolean func_70072_I() {
        return false;
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        return false;
    }
}

