/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityRanger;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenIthilien;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityRangerIthilien
extends LOTREntityRanger {
    public LOTREntityRangerIthilien(World world) {
        super(world);
        this.npcCape = LOTRCapes.RANGER_ITHILIEN;
    }

    @Override
    protected LOTRFoods getDunedainFoods() {
        return LOTRFoods.GONDOR;
    }

    @Override
    protected LOTRFoods getDunedainDrinks() {
        return LOTRFoods.GONDOR_DRINK;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(4);
        if (i == 0 || i == 1 || i == 2) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerGondor));
        } else if (i == 3) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.swordGondor));
        }
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.gondorBow));
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsRangerIthilien));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsRangerIthilien));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyRangerIthilien));
        this.func_70062_b(4, new ItemStack(LOTRMod.helmetRangerIthilien));
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.GONDOR;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = super.func_70783_a(i, j, k);
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenIthilien) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    protected void dropDunedainItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.dropChestContents(LOTRChestContents.GONDOR_HOUSE, 1, 2 + i);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killRangerIthilien;
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "gondor/ranger/hired";
            }
            return "gondor/ranger/friendly";
        }
        return "gondor/ranger/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.GONDOR.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.GONDOR;
    }
}

