/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.awt.Color;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRDimension;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemLeatherHat;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityScrapTrader
extends LOTREntityMan
implements LOTRTravellingTrader,
LOTRTradeable.Smith {
    private int timeUntilFadeOut;
    public static final int maxFadeoutTick = 60;

    public LOTREntityScrapTrader(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.3, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIEat(this, LOTRFoods.DUNLENDING, 8000));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIDrink(this, LOTRFoods.DUNLENDING_DRINK, 8000));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 10.0f, 0.1f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(false);
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.SCRAP_TRADER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.SCRAP_TRADER_SELL;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)-1);
    }

    public int getFadeoutTick() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setFadeoutTick(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public float getFadeoutProgress(float f) {
        int i = this.getFadeoutTick();
        if (i >= 0) {
            return ((float)(60 - i) + f) / 60.0f;
        }
        return 0.0f;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    public void setupNPCName() {
        int i = this.field_70146_Z.nextInt(4);
        if (i == 0) {
            this.familyInfo.setName(LOTRNames.getBreeName(this.field_70146_Z, this.familyInfo.isMale()));
        } else if (i == 1) {
            this.familyInfo.setName(LOTRNames.getDunlendingName(this.field_70146_Z, this.familyInfo.isMale()));
        } else if (i == 2) {
            this.familyInfo.setName(LOTRNames.getRohirricName(this.field_70146_Z, this.familyInfo.isMale()));
        } else if (i == 3) {
            this.familyInfo.setName(LOTRNames.getGondorName(this.field_70146_Z, this.familyInfo.isMale()));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int weapon = this.field_70146_Z.nextInt(2);
        if (weapon == 0) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerIron));
        } else if (weapon == 1) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerBronze));
        }
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.shireHeather));
        ItemStack hat = new ItemStack(LOTRMod.leatherHat);
        float h = 0.06111111f;
        float s = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)0.5f);
        float b = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)0.5f);
        int hatColor = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        LOTRItemLeatherHat.setHatColor(hat, hatColor);
        if (this.field_70146_Z.nextInt(3) == 0) {
            h = this.field_70146_Z.nextFloat();
            s = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.7f, (float)0.9f);
            b = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.8f, (float)1.0f);
        } else {
            h = 0.0f;
            s = 0.0f;
            b = this.field_70146_Z.nextFloat();
        }
        int featherColor = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        LOTRItemLeatherHat.setFeatherColor(hat, featherColor);
        this.func_70062_b(4, hat);
        return data;
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.UNALIGNED;
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return null;
    }

    @Override
    public String getDepartureSpeech() {
        return "misc/scrapTrader/departure";
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    public int func_70658_aO() {
        return 5;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        boolean flag = super.func_70085_c(entityplayer);
        if (flag && !this.field_70170_p.field_72995_K && LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) == LOTRDimension.UTUMNO && this.timeUntilFadeOut <= 0) {
            this.timeUntilFadeOut = 100;
        }
        return flag;
    }

    @Override
    public boolean canBeFreelyTargetedBy(EntityLiving attacker) {
        if (LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) == LOTRDimension.UTUMNO) {
            return false;
        }
        return super.canBeFreelyTargetedBy(attacker);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        if (damagesource.func_76346_g() != null && LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) == LOTRDimension.UTUMNO) {
            if (!this.field_70170_p.field_72995_K && this.getFadeoutTick() < 0) {
                this.setFadeoutTick(60);
            }
            return false;
        }
        return super.func_70097_a(damagesource, f);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) == LOTRDimension.UTUMNO) {
            if (this.timeUntilFadeOut > 0) {
                --this.timeUntilFadeOut;
                if (this.timeUntilFadeOut <= 0) {
                    this.setFadeoutTick(60);
                }
            }
            if (this.getFadeoutTick() > 0) {
                this.setFadeoutTick(this.getFadeoutTick() - 1);
                if (this.getFadeoutTick() <= 0) {
                    this.func_70106_y();
                }
            }
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 0.0f;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return this.isFriendlyAndAligned(entityplayer) && LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) != LOTRDimension.UTUMNO;
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeScrapTrader);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (LOTRDimension.getCurrentDimensionWithFallback(this.field_70170_p) == LOTRDimension.UTUMNO) {
                return "misc/scrapTrader/utumno";
            }
            return "misc/scrapTrader/friendly";
        }
        return "misc/scrapTrader/hostile";
    }

    public String getSmithSpeechBank() {
        return "misc/scrapTrader/smith";
    }
}

