/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.projectile.LOTREntityTrollSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class LOTREntitySnowTroll
extends LOTREntityTroll {
    private EntityAIBase rangedAttackAI = this.getTrollRangedAttackAI();
    private EntityAIBase meleeAttackAI;

    public LOTREntitySnowTroll(World world) {
        super(world);
        this.isImmuneToFrost = true;
    }

    @Override
    public float getTrollScale() {
        return 0.8f;
    }

    @Override
    public EntityAIBase getTrollAttackAI() {
        this.meleeAttackAI = new LOTREntityAIAttackOnCollide(this, 1.6, false);
        return this.meleeAttackAI;
    }

    protected EntityAIBase getTrollRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.2, 20, 30, 24.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public boolean isThrowingSnow() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    public void setThrowingSnow(boolean flag) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? (byte)1 : 0));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    @Override
    protected boolean hasTrollName() {
        return false;
    }

    @Override
    protected boolean canTrollBeTickled(EntityPlayer entityplayer) {
        return false;
    }

    @Override
    public double getMeleeRange() {
        return 12.0;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.setThrowingSnow(false);
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(3, this.meleeAttackAI);
            this.setThrowingSnow(false);
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(3, this.rangedAttackAI);
            this.setThrowingSnow(true);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            int difficulty;
            int duration;
            if (entity instanceof EntityLivingBase && (duration = (difficulty = this.field_70170_p.field_73013_u.func_151525_a()) * (difficulty + 5) / 2) > 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration * 20, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow template = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, f * 1.6f, 0.5f);
        LOTREntityTrollSnowball snowball = new LOTREntityTrollSnowball(this.field_70170_p, (EntityLivingBase)this);
        snowball.func_70012_b(template.field_70165_t, template.field_70163_u, template.field_70161_v, template.field_70177_z, template.field_70125_A);
        snowball.field_70159_w = template.field_70159_w;
        snowball.field_70181_x = template.field_70181_x;
        snowball.field_70179_y = template.field_70179_y;
        this.field_70170_p.func_72838_d((Entity)snowball);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.func_71038_i();
    }

    @Override
    public void onTrollDeathBySun() {
        this.field_70170_p.func_72956_a((Entity)this, "lotr:troll.transform", this.func_70599_aP(), this.func_70647_i());
        this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        this.func_70106_y();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            super.func_70103_a(b);
            for (int l = 0; l < 64; ++l) {
                this.field_70170_p.func_72869_a("snowballpoof", this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int furs = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < furs; ++l) {
            this.func_145779_a(LOTRMod.fur, 1);
        }
        int snows = 2 + this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(i * 2 + 1);
        for (int l = 0; l < snows; ++l) {
            this.func_145779_a(Items.field_151126_ay, 1);
        }
    }

    @Override
    public void dropTrollItems(boolean flag, int i) {
        if (this.field_70146_Z.nextBoolean()) {
            super.dropTrollItems(flag, i);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killSnowTroll;
    }

    @Override
    public float getAlignmentBonus() {
        return 3.0f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        return null;
    }
}

