/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityWickedDwarf
extends LOTREntityDwarf
implements LOTRTradeable.Smith {
    private static ItemStack[] wickedWeapons = new ItemStack[]{new ItemStack(LOTRMod.swordDwarven), new ItemStack(LOTRMod.battleaxeDwarven), new ItemStack(LOTRMod.hammerDwarven)};

    public static LOTRFaction[] getTradeFactions() {
        return new LOTRFaction[]{LOTRFaction.MORDOR, LOTRFaction.ANGMAR, LOTRFaction.RHUDEL};
    }

    public LOTREntityWickedDwarf(World world) {
        super(world);
        this.addTargetTasks(true);
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.WICKED_DWARF_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.WICKED_DWARF_SELL;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(wickedWeapons.length);
        this.npcItemsInv.setMeleeWeapon(wickedWeapons[i].func_77946_l());
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.pickaxeDwarven));
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsDwarven));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsDwarven));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyDwarven));
        } else {
            this.func_70062_b(1, null);
            this.func_70062_b(2, null);
            this.func_70062_b(3, null);
        }
        this.func_70062_b(4, null);
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.MORDOR;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killWickedDwarf;
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        boolean hasSuitableAlignment = false;
        for (LOTRFaction f : LOTREntityWickedDwarf.getTradeFactions()) {
            if (!(LOTRLevelData.getData(entityplayer).getAlignment(f) >= 100.0f)) continue;
            hasSuitableAlignment = true;
            break;
        }
        return hasSuitableAlignment && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeWickedDwarf);
    }

    @Override
    protected boolean canDwarfSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A;
    }

    @Override
    protected boolean canDwarfSpawnAboveGround() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "dwarf/wicked/friendly";
            }
            return "dwarf/wicked/neutral";
        }
        return "dwarf/wicked/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return null;
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return null;
    }
}

