/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.inventory.LOTRContainerTrade;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketTraderInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class LOTRTraderNPCInfo {
    private LOTREntityNPC theEntity;
    private LOTRTradeEntry[] buyTrades;
    private LOTRTradeEntry[] sellTrades;
    private int timeUntilAdvertisement;
    private int timeSinceTrade;
    private boolean shouldLockTrades = true;
    private int lockTradeAtValue = 200;
    private static final int defaultLockTradeAtValue = 200;
    private int lockValueDecayTicks = 60;
    private static final int defaultLockValueDecayTicks = 60;
    private boolean shouldRefresh = true;
    private int valueSinceRefresh;
    private int refreshAtValue = 5000;
    private static final int defaultRefreshAtValue = 5000;
    private int lockTicksAfterRefresh = 6000;
    private static final int defaultLockTicksAfterRefresh = 6000;

    public LOTRTraderNPCInfo(LOTREntityNPC npc) {
        this.theEntity = npc;
        if (this.theEntity instanceof LOTRTradeable && !this.theEntity.field_70170_p.field_72995_K) {
            this.refreshTrades();
        }
    }

    public LOTRTradeEntry[] getBuyTrades() {
        return this.buyTrades;
    }

    public LOTRTradeEntry[] getSellTrades() {
        return this.sellTrades;
    }

    private void setBuyTrades(LOTRTradeEntry[] trades) {
        for (LOTRTradeEntry trade : trades) {
            trade.setOwningTrader(this);
        }
        this.buyTrades = trades;
    }

    private void setSellTrades(LOTRTradeEntry[] trades) {
        for (LOTRTradeEntry trade : trades) {
            trade.setOwningTrader(this);
        }
        this.sellTrades = trades;
    }

    protected boolean shouldLockTrades() {
        return this.shouldLockTrades;
    }

    protected int getLockTradeAtValue() {
        return this.lockTradeAtValue;
    }

    protected int getValueDecayTicks() {
        return this.lockValueDecayTicks;
    }

    public void onTrade(EntityPlayer entityplayer, LOTRTradeEntry trade, LOTRTradeEntries.TradeType type, int value) {
        ((LOTRTradeable)((Object)this.theEntity)).onPlayerTrade(entityplayer, type, trade.createTradeItem());
        LOTRLevelData.getData(entityplayer).getFactionData(this.theEntity.getFaction()).addTrade();
        trade.doTransaction(value);
        this.timeSinceTrade = 0;
        this.valueSinceRefresh += value;
        this.sendClientPacket(entityplayer);
    }

    private void refreshTrades() {
        LOTRTradeable theTrader = (LOTRTradeable)((Object)this.theEntity);
        Random rand = this.theEntity.func_70681_au();
        this.setBuyTrades(theTrader.getBuyPool().getRandomTrades(rand));
        this.setSellTrades(theTrader.getSellPool().getRandomTrades(rand));
        this.valueSinceRefresh = 0;
        for (int i = 0; i < this.theEntity.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)this.theEntity.field_70170_p.field_73010_i.get(i);
            Container container = entityplayer.field_71070_bA;
            if (!(container instanceof LOTRContainerTrade) || ((LOTRContainerTrade)container).theTraderNPC != this.theEntity) continue;
            ((LOTRContainerTrade)container).updateAllTradeSlots();
        }
    }

    private void setAllTradesDelayed() {
        int delay = this.lockTicksAfterRefresh;
        for (LOTRTradeEntry trade : this.buyTrades) {
            if (trade == null) continue;
            trade.setLockedForTicks(delay);
        }
        for (LOTRTradeEntry trade : this.sellTrades) {
            if (trade == null) continue;
            trade.setLockedForTicks(delay);
        }
    }

    public void onUpdate() {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            if (this.timeUntilAdvertisement > 0) {
                --this.timeUntilAdvertisement;
            }
            ++this.timeSinceTrade;
            int ticksExisted = this.theEntity.field_70173_aa;
            boolean sendUpdate = false;
            for (LOTRTradeEntry trade : this.buyTrades) {
                if (trade == null || !trade.updateAvailability(ticksExisted)) continue;
                sendUpdate = true;
            }
            for (LOTRTradeEntry trade : this.sellTrades) {
                if (trade == null || !trade.updateAvailability(ticksExisted)) continue;
                sendUpdate = true;
            }
            if (this.shouldRefresh && this.valueSinceRefresh >= this.refreshAtValue) {
                this.refreshTrades();
                this.setAllTradesDelayed();
                sendUpdate = true;
            }
            if (sendUpdate) {
                for (int i = 0; i < this.theEntity.field_70170_p.field_73010_i.size(); ++i) {
                    EntityPlayer entityplayer = (EntityPlayer)this.theEntity.field_70170_p.field_73010_i.get(i);
                    Container container = entityplayer.field_71070_bA;
                    if (!(container instanceof LOTRContainerTrade) || ((LOTRContainerTrade)container).theTraderNPC != this.theEntity) continue;
                    this.sendClientPacket(entityplayer);
                }
            }
            if (this.theEntity.func_70089_S() && this.theEntity.func_70638_az() == null && this.timeUntilAdvertisement == 0 && this.timeSinceTrade > 600) {
                double range = 10.0;
                List players = this.theEntity.field_70170_p.func_72872_a(EntityPlayer.class, this.theEntity.field_70121_D.func_72314_b(range, range, range));
                for (Object obj : players) {
                    String speechBank;
                    EntityPlayer entityplayer = (EntityPlayer)obj;
                    if (!entityplayer.func_70089_S() || entityplayer.field_71075_bZ.field_75098_d || entityplayer.field_71070_bA != null && entityplayer.field_71070_bA != entityplayer.field_71069_bz || (speechBank = this.theEntity.getSpeechBank(entityplayer)) == null || this.theEntity.func_70681_au().nextInt(3) != 0) continue;
                    this.theEntity.sendSpeechBank(entityplayer, speechBank);
                }
                this.timeUntilAdvertisement = 20 * MathHelper.func_76136_a((Random)this.theEntity.func_70681_au(), (int)5, (int)20);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagCompound nbt;
        if (this.buyTrades != null) {
            NBTTagList buyTradesTags = new NBTTagList();
            for (LOTRTradeEntry trade : this.buyTrades) {
                if (trade == null) continue;
                nbt = new NBTTagCompound();
                trade.writeToNBT(nbt);
                buyTradesTags.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound buyTradesData = new NBTTagCompound();
            buyTradesData.func_74782_a("Trades", (NBTBase)buyTradesTags);
            data.func_74782_a("LOTRBuyTrades", (NBTBase)buyTradesData);
        }
        if (this.sellTrades != null) {
            NBTTagList sellTradesTags = new NBTTagList();
            for (LOTRTradeEntry trade : this.sellTrades) {
                if (trade == null) continue;
                nbt = new NBTTagCompound();
                trade.writeToNBT(nbt);
                sellTradesTags.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound sellTradesData = new NBTTagCompound();
            sellTradesData.func_74782_a("Trades", (NBTBase)sellTradesTags);
            data.func_74782_a("LOTRSellTrades", (NBTBase)sellTradesData);
        }
        data.func_74768_a("TimeSinceTrade", this.timeSinceTrade);
        data.func_74757_a("ShouldLockTrades", this.shouldLockTrades);
        data.func_74768_a("LockTradeAtValue", this.lockTradeAtValue);
        data.func_74768_a("LockValueDecayTicks", this.lockValueDecayTicks);
        data.func_74757_a("ShouldRefresh", this.shouldRefresh);
        data.func_74768_a("RefreshAtValue", this.refreshAtValue);
        data.func_74768_a("LockTicksAfterRefresh", this.lockTicksAfterRefresh);
        data.func_74768_a("ValueSinceRefresh", this.valueSinceRefresh);
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTTagCompound sellTradesData;
        LOTRTradeEntry trade;
        NBTTagCompound nbt;
        int i;
        NBTTagCompound buyTradesData;
        if (data.func_74764_b("LOTRBuyTrades") && (buyTradesData = data.func_74775_l("LOTRBuyTrades")).func_74764_b("Trades")) {
            NBTTagList buyTradesTags = buyTradesData.func_150295_c("Trades", 10);
            this.buyTrades = new LOTRTradeEntry[buyTradesTags.func_74745_c()];
            for (i = 0; i < buyTradesTags.func_74745_c(); ++i) {
                nbt = buyTradesTags.func_150305_b(i);
                trade = LOTRTradeEntry.readFromNBT(nbt);
                trade.setOwningTrader(this);
                this.buyTrades[i] = trade;
            }
        }
        if (data.func_74764_b("LOTRSellTrades") && (sellTradesData = data.func_74775_l("LOTRSellTrades")).func_74764_b("Trades")) {
            NBTTagList sellTradesTags = sellTradesData.func_150295_c("Trades", 10);
            this.sellTrades = new LOTRTradeEntry[sellTradesTags.func_74745_c()];
            for (i = 0; i < sellTradesTags.func_74745_c(); ++i) {
                nbt = sellTradesTags.func_150305_b(i);
                trade = LOTRTradeEntry.readFromNBT(nbt);
                trade.setOwningTrader(this);
                this.sellTrades[i] = trade;
            }
        }
        this.timeSinceTrade = data.func_74762_e("TimeSinceTrade");
        if (data.func_74764_b("ShouldLockTrades")) {
            this.shouldLockTrades = data.func_74767_n("ShouldLockTrades");
        }
        if (data.func_74764_b("LockTradeAtValue")) {
            this.lockTradeAtValue = data.func_74762_e("LockTradeAtValue");
        }
        if (data.func_74764_b("LockValueDecayTicks")) {
            this.lockValueDecayTicks = data.func_74762_e("LockValueDecayTicks");
        }
        if (data.func_74764_b("ShouldRefresh")) {
            this.shouldRefresh = data.func_74767_n("ShouldRefresh");
        }
        if (data.func_74764_b("RefreshAtValue")) {
            this.refreshAtValue = data.func_74762_e("RefreshAtValue");
        }
        if (data.func_74764_b("LockTicksAfterRefresh")) {
            this.lockTicksAfterRefresh = data.func_74762_e("LockTicksAfterRefresh");
        }
        this.valueSinceRefresh = data.func_74762_e("ValueSinceRefresh");
    }

    public void sendClientPacket(EntityPlayer entityplayer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        LOTRPacketTraderInfo packet = new LOTRPacketTraderInfo(nbt);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
    }

    public void receiveClientPacket(LOTRPacketTraderInfo packet) {
        NBTTagCompound nbt = packet.traderData;
        this.readFromNBT(nbt);
    }
}

