/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fellowship;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRLevelData;
import lotr.common.fellowship.FellowshipUpdateType;
import lotr.common.fellowship.LOTRFellowshipData;
import lotr.common.network.LOTRPacketFellowshipNotification;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.StringUtils;

public class LOTRFellowship {
    private boolean needsSave = false;
    private UUID fellowshipUUID;
    private String fellowshipName;
    private boolean disbanded = false;
    private ItemStack fellowshipIcon;
    private UUID ownerUUID;
    private List<UUID> memberUUIDs = new ArrayList<UUID>();
    private Set<UUID> adminUUIDs = new HashSet<UUID>();
    private boolean preventPVP = true;
    private boolean preventHiredFF = true;
    private boolean showMapLocations = true;

    public LOTRFellowship() {
        this.fellowshipUUID = UUID.randomUUID();
    }

    public LOTRFellowship(UUID fsID) {
        this.fellowshipUUID = fsID;
    }

    public LOTRFellowship(UUID owner, String name) {
        this();
        this.ownerUUID = owner;
        this.fellowshipName = name;
    }

    public void createAndRegister() {
        LOTRFellowshipData.addFellowship(this);
        LOTRLevelData.getData(this.ownerUUID).addFellowship(this);
        this.updateForAllMembers(FellowshipUpdateType.FULL);
        this.markDirty();
    }

    public void validate() {
        if (this.fellowshipUUID == null) {
            this.fellowshipUUID = UUID.randomUUID();
        }
        if (this.ownerUUID == null) {
            this.ownerUUID = UUID.randomUUID();
        }
    }

    public void markDirty() {
        this.needsSave = true;
    }

    public boolean needsSave() {
        return this.needsSave;
    }

    public void save(NBTTagCompound fsData) {
        if (this.ownerUUID != null) {
            fsData.func_74778_a("Owner", this.ownerUUID.toString());
        }
        NBTTagList memberTags = new NBTTagList();
        for (UUID member : this.memberUUIDs) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Member", member.toString());
            if (this.adminUUIDs.contains(member)) {
                nbt.func_74757_a("Admin", true);
            }
            memberTags.func_74742_a((NBTBase)nbt);
        }
        fsData.func_74782_a("Members", (NBTBase)memberTags);
        if (this.fellowshipName != null) {
            fsData.func_74778_a("Name", this.fellowshipName);
        }
        if (this.fellowshipIcon != null) {
            NBTTagCompound itemData = new NBTTagCompound();
            this.fellowshipIcon.func_77955_b(itemData);
            fsData.func_74782_a("Icon", (NBTBase)itemData);
        }
        fsData.func_74757_a("PreventPVP", this.preventPVP);
        fsData.func_74757_a("PreventHiredFF", this.preventHiredFF);
        fsData.func_74757_a("ShowMap", this.showMapLocations);
        this.needsSave = false;
    }

    public void load(NBTTagCompound fsData) {
        if (fsData.func_74764_b("Owner")) {
            this.ownerUUID = UUID.fromString(fsData.func_74779_i("Owner"));
        }
        this.memberUUIDs.clear();
        this.adminUUIDs.clear();
        NBTTagList memberTags = fsData.func_150295_c("Members", 10);
        for (int i = 0; i < memberTags.func_74745_c(); ++i) {
            boolean isAdmin;
            NBTTagCompound nbt = memberTags.func_150305_b(i);
            UUID member = UUID.fromString(nbt.func_74779_i("Member"));
            if (member == null) continue;
            this.memberUUIDs.add(member);
            if (!nbt.func_74764_b("Admin") || !(isAdmin = nbt.func_74767_n("Admin"))) continue;
            this.adminUUIDs.add(member);
        }
        if (fsData.func_74764_b("Name")) {
            this.fellowshipName = fsData.func_74779_i("Name");
        }
        if (fsData.func_74764_b("Icon")) {
            NBTTagCompound itemData = fsData.func_74775_l("Icon");
            this.fellowshipIcon = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
        if (fsData.func_74764_b("PreventPVP")) {
            this.preventPVP = fsData.func_74767_n("PreventPVP");
        }
        if (fsData.func_74764_b("PreventPVP")) {
            this.preventHiredFF = fsData.func_74767_n("PreventHiredFF");
        }
        if (fsData.func_74764_b("ShowMap")) {
            this.showMapLocations = fsData.func_74767_n("ShowMap");
        }
        this.validate();
    }

    public UUID getFellowshipID() {
        return this.fellowshipUUID;
    }

    public UUID getOwner() {
        return this.ownerUUID;
    }

    public boolean isOwner(UUID player) {
        return this.ownerUUID.equals(player);
    }

    public void setOwner(UUID owner) {
        UUID prevOwner = this.ownerUUID;
        if (prevOwner != null && !this.memberUUIDs.contains(prevOwner)) {
            this.memberUUIDs.add(0, prevOwner);
        }
        this.ownerUUID = owner;
        if (this.memberUUIDs.contains(owner)) {
            this.memberUUIDs.remove(owner);
        }
        if (this.adminUUIDs.contains(owner)) {
            this.adminUUIDs.remove(owner);
        }
        LOTRLevelData.getData(this.ownerUUID).addFellowship(this);
        this.updateForAllMembers(FellowshipUpdateType.FULL);
        this.markDirty();
    }

    public String getName() {
        return this.fellowshipName;
    }

    public void setName(String name) {
        this.fellowshipName = name;
        this.updateForAllMembers(FellowshipUpdateType.RENAME);
        this.markDirty();
    }

    public boolean containsPlayer(UUID player) {
        return this.isOwner(player) || this.hasMember(player);
    }

    public boolean hasMember(UUID player) {
        return this.memberUUIDs.contains(player);
    }

    public void addMember(UUID player) {
        if (!this.isOwner(player) && !this.memberUUIDs.contains(player)) {
            this.memberUUIDs.add(player);
            LOTRLevelData.getData(player).addFellowship(this);
            this.updateForAllMembers(FellowshipUpdateType.FULL);
            this.markDirty();
        }
    }

    public void removeMember(UUID player) {
        if (this.memberUUIDs.contains(player)) {
            this.memberUUIDs.remove(player);
            if (this.adminUUIDs.contains(player)) {
                this.adminUUIDs.remove(player);
            }
            LOTRLevelData.getData(player).removeFellowship(this);
            this.updateForAllMembers(FellowshipUpdateType.FULL);
            this.markDirty();
        }
    }

    public List<UUID> getMemberUUIDs() {
        return this.memberUUIDs;
    }

    public List<UUID> getAllPlayerUUIDs() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        list.add(this.ownerUUID);
        list.addAll(this.memberUUIDs);
        return list;
    }

    public boolean isAdmin(UUID player) {
        return this.hasMember(player) && this.adminUUIDs.contains(player);
    }

    public void setAdmin(UUID player, boolean flag) {
        if (this.memberUUIDs.contains(player)) {
            if (flag && !this.adminUUIDs.contains(player)) {
                this.adminUUIDs.add(player);
                this.updateForAllMembers(FellowshipUpdateType.FULL);
                this.markDirty();
            } else if (!flag && this.adminUUIDs.contains(player)) {
                this.adminUUIDs.remove(player);
                this.updateForAllMembers(FellowshipUpdateType.FULL);
                this.markDirty();
            }
        }
    }

    public ItemStack getIcon() {
        return this.fellowshipIcon;
    }

    public void setIcon(ItemStack itemstack) {
        this.fellowshipIcon = itemstack;
        this.updateForAllMembers(FellowshipUpdateType.CHANGE_ICON);
        this.markDirty();
    }

    public boolean getPreventPVP() {
        return this.preventPVP;
    }

    public void setPreventPVP(boolean flag) {
        this.preventPVP = flag;
        this.updateForAllMembers(FellowshipUpdateType.TOGGLE_PVP);
        this.markDirty();
    }

    public boolean getPreventHiredFriendlyFire() {
        return this.preventHiredFF;
    }

    public void setPreventHiredFriendlyFire(boolean flag) {
        this.preventHiredFF = flag;
        this.updateForAllMembers(FellowshipUpdateType.TOGGLE_HIRED_FRIENDLY_FIRE);
        this.markDirty();
    }

    public boolean getShowMapLocations() {
        return this.showMapLocations;
    }

    public void setShowMapLocations(boolean flag) {
        this.showMapLocations = flag;
        this.updateForAllMembers(FellowshipUpdateType.TOGGLE_SHOW_MAP_LOCATIONS);
        this.markDirty();
    }

    public void updateForAllMembers(FellowshipUpdateType updateType) {
        for (UUID player : this.getAllPlayerUUIDs()) {
            LOTRLevelData.getData(player).updateFellowship(this, updateType);
        }
    }

    public void disband() {
        this.disbanded = true;
        ArrayList<UUID> copyMemberIDs = new ArrayList<UUID>(this.memberUUIDs);
        for (UUID player : copyMemberIDs) {
            this.removeMember(player);
        }
    }

    public boolean isDisbanded() {
        return this.disbanded;
    }

    public void sendFellowshipMessage(EntityPlayerMP sender, String message) {
        if (sender.func_147096_v() == EntityPlayer.EnumChatVisibility.HIDDEN) {
            ChatComponentTranslation msgCannotSend = new ChatComponentTranslation("chat.cannotSend", new Object[0]);
            msgCannotSend.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            sender.field_71135_a.func_147359_a((Packet)new S02PacketChat((IChatComponent)msgCannotSend));
        } else {
            sender.func_143004_u();
            message = StringUtils.normalizeSpace((String)message);
            if (StringUtils.isBlank((CharSequence)message)) {
                return;
            }
            for (int i = 0; i < message.length(); ++i) {
                if (ChatAllowedCharacters.func_71566_a((char)message.charAt(i))) continue;
                sender.field_71135_a.func_147360_c("Illegal characters in chat");
                return;
            }
            ClickEvent fMsgClickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/fmsg \"" + this.getName() + "\" ");
            IChatComponent msgComponent = ForgeHooks.newChatWithLinks((String)message);
            msgComponent.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            IChatComponent senderComponent = sender.func_145748_c_();
            senderComponent.func_150256_b().func_150241_a(fMsgClickEvent);
            ChatComponentTranslation chatComponent = new ChatComponentTranslation("chat.type.text", new Object[]{senderComponent, ""});
            chatComponent = ForgeHooks.onServerChatEvent((NetHandlerPlayServer)sender.field_71135_a, (String)message, (ChatComponentTranslation)chatComponent);
            if (chatComponent == null) {
                return;
            }
            chatComponent.func_150257_a(msgComponent);
            ChatComponentTranslation fsComponent = new ChatComponentTranslation("commands.lotr.fmsg.fsPrefix", new Object[]{this.getName()});
            fsComponent.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            fsComponent.func_150256_b().func_150241_a(fMsgClickEvent);
            ChatComponentTranslation fullChatComponent = new ChatComponentTranslation("%s %s", new Object[]{fsComponent, chatComponent});
            MinecraftServer server = MinecraftServer.func_71276_C();
            server.func_145747_a((IChatComponent)fullChatComponent);
            S02PacketChat packetChat = new S02PacketChat((IChatComponent)fullChatComponent, false);
            for (Object player : server.func_71203_ab().field_72404_b) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                if (!this.containsPlayer(entityplayer.func_110124_au())) continue;
                entityplayer.field_71135_a.func_147359_a((Packet)packetChat);
            }
        }
    }

    public void sendNotification(EntityPlayer entityplayer, String key, Object ... args) {
        ChatComponentTranslation message = new ChatComponentTranslation(key, args);
        message.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
        entityplayer.func_145747_a((IChatComponent)message);
        LOTRPacketFellowshipNotification packet = new LOTRPacketFellowshipNotification((IChatComponent)message);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
    }
}

