/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lotr.client.render.LOTRDrinkIcons;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRReflection;
import lotr.common.block.LOTRBlockMug;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LOTRItemMug
extends Item {
    private static String[] strengthNames = new String[]{"weak", "light", "moderate", "strong", "potent"};
    private static float[] strengths = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 3.0f};
    private static float[] foodStrengths = new float[]{0.5f, 0.75f, 1.0f, 1.25f, 1.5f};
    public static int vesselMeta = 100;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] drinkIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon liquidIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon barrelGui_emptyBucketSlotIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon barrelGui_emptyMugSlotIcon;
    public final boolean isFullMug;
    public final boolean isFoodDrink;
    public final boolean isBrewable;
    public final float alcoholicity;
    protected int foodHealAmount;
    protected float foodSaturationAmount;
    protected List<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    protected int damageAmount;
    protected boolean curesEffects;

    public LOTRItemMug(boolean full, boolean food, boolean brew, float alc) {
        if (full) {
            this.func_77625_d(1);
            this.func_77627_a(true);
            this.func_77656_e(0);
        } else {
            this.func_77625_d(64);
        }
        this.func_77637_a(LOTRCreativeTabs.tabFood);
        this.isFullMug = full;
        this.isFoodDrink = food;
        this.isBrewable = brew;
        this.alcoholicity = alc;
    }

    public LOTRItemMug(boolean full, boolean food) {
        this(full, food, false, 0.0f);
    }

    public LOTRItemMug(float alc) {
        this(true, false, true, alc);
    }

    public LOTRItemMug setDrinkStats(int i, float f) {
        this.foodHealAmount = i;
        this.foodSaturationAmount = f;
        return this;
    }

    public LOTRItemMug addPotionEffect(int i, int j) {
        this.potionEffects.add(new PotionEffect(i, j * 20));
        return this;
    }

    public LOTRItemMug setDamageAmount(int i) {
        this.damageAmount = i;
        return this;
    }

    public LOTRItemMug setCuresEffects() {
        this.curesEffects = true;
        return this;
    }

    public static boolean isItemFullDrink(ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            if (item instanceof LOTRItemMug) {
                return ((LOTRItemMug)item).isFullMug;
            }
            if (item == Items.field_151068_bn && itemstack.func_77960_j() == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isItemEmptyDrink(ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            if (item instanceof LOTRItemMug) {
                return !((LOTRItemMug)item).isFullMug;
            }
            if (item == Items.field_151069_bo) {
                return true;
            }
        }
        return false;
    }

    public static ItemStack getEquivalentDrink(ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            if (item instanceof LOTRItemMug) {
                return itemstack;
            }
            if (item == Items.field_151068_bn && itemstack.func_77960_j() == 0) {
                ItemStack water = itemstack.func_77946_l();
                water.func_150996_a(LOTRMod.mugWater);
                LOTRItemMug.setVessel(water, Vessel.BOTTLE, false);
                return water;
            }
        }
        return itemstack;
    }

    public static ItemStack getRealDrink(ItemStack itemstack) {
        Item item;
        if (itemstack != null && (item = itemstack.func_77973_b()) == LOTRMod.mugWater && LOTRItemMug.getVessel(itemstack) == Vessel.BOTTLE) {
            ItemStack water = itemstack.func_77946_l();
            water.func_150996_a((Item)Items.field_151068_bn);
            water.func_77964_b(0);
            return water;
        }
        return itemstack;
    }

    private static int getStrengthMeta(int damage) {
        int i = damage % vesselMeta;
        if (i < 0 || i >= strengths.length) {
            i = 0;
        }
        return i;
    }

    public static int getStrengthMeta(ItemStack itemstack) {
        return LOTRItemMug.getStrengthMeta(itemstack.func_77960_j());
    }

    public static void setStrengthMeta(ItemStack itemstack, int i) {
        Vessel v = LOTRItemMug.getVessel(itemstack);
        itemstack.func_77964_b(i);
        LOTRItemMug.setVessel(itemstack, v, true);
    }

    public static float getStrength(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item instanceof LOTRItemMug && ((LOTRItemMug)item).isBrewable) {
            int i = LOTRItemMug.getStrengthMeta(itemstack);
            return strengths[i];
        }
        return 1.0f;
    }

    public static float getFoodStrength(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item instanceof LOTRItemMug && ((LOTRItemMug)item).isBrewable) {
            int i = LOTRItemMug.getStrengthMeta(itemstack);
            return foodStrengths[i];
        }
        return 1.0f;
    }

    public static Vessel getVessel(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item instanceof LOTRItemMug) {
            LOTRItemMug itemMug = (LOTRItemMug)item;
            if (itemMug.isFullMug) {
                return LOTRItemMug.getVessel(itemstack.func_77960_j());
            }
            return itemMug.getEmptyVesselType();
        }
        if (item == Items.field_151069_bo) {
            return Vessel.BOTTLE;
        }
        if (item == Items.field_151068_bn && itemstack.func_77960_j() == 0) {
            return Vessel.BOTTLE;
        }
        return null;
    }

    private static Vessel getVessel(int damage) {
        int i = damage / vesselMeta;
        return Vessel.forMeta(i);
    }

    public static void setVessel(ItemStack itemstack, Vessel v, boolean correctItem) {
        if (correctItem && itemstack.func_77973_b() == Items.field_151068_bn && itemstack.func_77960_j() == 0) {
            itemstack.func_150996_a(LOTRMod.mugWater);
            itemstack.func_77964_b(0);
        }
        int i = itemstack.func_77960_j();
        itemstack.func_77964_b(v.id * vesselMeta + (i %= vesselMeta));
        if (correctItem && itemstack.func_77973_b() == LOTRMod.mugWater && v == Vessel.BOTTLE) {
            itemstack.func_150996_a((Item)Items.field_151068_bn);
            itemstack.func_77964_b(0);
        }
    }

    public IIcon func_77617_a(int i) {
        if (this.isFullMug) {
            if (i == -1) {
                return this.liquidIcon;
            }
            int vessel = LOTRItemMug.getVessel((int)i).id;
            return this.drinkIcons[vessel];
        }
        return super.func_77617_a(i);
    }

    public void func_94581_a(IIconRegister iconregister) {
        if (this.isFullMug) {
            this.drinkIcons = new IIcon[Vessel.values().length];
            for (int i = 0; i < Vessel.values().length; ++i) {
                this.drinkIcons[i] = LOTRDrinkIcons.registerDrinkIcon(iconregister, this, this.func_111208_A(), Vessel.values()[i].name);
            }
            this.liquidIcon = LOTRDrinkIcons.registerLiquidIcon(iconregister, this, this.func_111208_A());
            barrelGui_emptyBucketSlotIcon = iconregister.func_94245_a("lotr:barrel_emptyBucketSlot");
            barrelGui_emptyMugSlotIcon = iconregister.func_94245_a("lotr:barrel_emptyMugSlot");
        } else {
            super.func_94581_a(iconregister);
        }
    }

    private List<PotionEffect> convertPotionEffectsForStrength(float strength) {
        ArrayList<PotionEffect> list = new ArrayList<PotionEffect>();
        for (int i = 0; i < this.potionEffects.size(); ++i) {
            PotionEffect base = this.potionEffects.get(i);
            PotionEffect modified = new PotionEffect(base.func_76456_a(), (int)((float)base.func_76459_b() * strength));
            list.add(modified);
        }
        return list;
    }

    public static String getStrengthSubtitle(ItemStack itemstack) {
        Item item;
        if (itemstack != null && (item = itemstack.func_77973_b()) instanceof LOTRItemMug && ((LOTRItemMug)item).isBrewable) {
            int i = LOTRItemMug.getStrengthMeta(itemstack);
            return StatCollector.func_74838_a((String)("item.lotr.drink." + strengthNames[i]));
        }
        return null;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (LOTRMod.isAprilFools() && this.isFullMug) {
            return "Hooch";
        }
        if (itemstack.func_77973_b() == LOTRMod.mugWater && LOTRItemMug.getVessel(itemstack) == Vessel.BOTTLE) {
            return "\u00c2\u00a7cMY DUDE YOU DONE MESSED UP";
        }
        return super.func_77653_i(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (this.isBrewable) {
            float strength = LOTRItemMug.getStrength(itemstack);
            list.add(LOTRItemMug.getStrengthSubtitle(itemstack));
            if (this.alcoholicity > 0.0f) {
                EnumChatFormatting c = EnumChatFormatting.GREEN;
                float f = this.alcoholicity * strength * 10.0f;
                c = f < 2.0f ? EnumChatFormatting.GREEN : (f < 5.0f ? EnumChatFormatting.YELLOW : (f < 10.0f ? EnumChatFormatting.GOLD : (f < 20.0f ? EnumChatFormatting.RED : EnumChatFormatting.DARK_RED)));
                list.add(c + StatCollector.func_74838_a((String)"item.lotr.drink.alcoholicity") + ": " + String.format("%.2f", Float.valueOf(f)) + "%");
            }
            LOTRItemMug.addPotionEffectsToTooltip(itemstack, entityplayer, list, flag, this.convertPotionEffectsForStrength(strength));
        }
    }

    public static void addPotionEffectsToTooltip(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag, List itemEffects) {
        if (!itemEffects.isEmpty()) {
            ItemStack potionEquivalent = new ItemStack((Item)Items.field_151068_bn);
            potionEquivalent.func_77964_b(69);
            NBTTagList effectsData = new NBTTagList();
            for (int l = 0; l < itemEffects.size(); ++l) {
                PotionEffect effect = (PotionEffect)itemEffects.get(l);
                NBTTagCompound nbt = new NBTTagCompound();
                effect.func_82719_a(nbt);
                effectsData.func_74742_a((NBTBase)nbt);
            }
            potionEquivalent.func_77982_d(new NBTTagCompound());
            potionEquivalent.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)effectsData);
            ArrayList effectTooltips = new ArrayList();
            potionEquivalent.func_77973_b().func_77624_a(potionEquivalent, entityplayer, effectTooltips, flag);
            list.addAll(effectTooltips);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.isFullMug) {
            Vessel[] vesselTypes = new Vessel[]{Vessel.MUG};
            if (tab == null || tab.hasSearchBar()) {
                vesselTypes = Vessel.values();
            }
            for (Vessel v : vesselTypes) {
                if (this.isBrewable) {
                    for (int str = 0; str < strengths.length; ++str) {
                        ItemStack drink = new ItemStack(item);
                        LOTRItemMug.setStrengthMeta(drink, str);
                        LOTRItemMug.setVessel(drink, v, true);
                        if (drink.func_77973_b() != item) continue;
                        list.add(drink);
                    }
                    continue;
                }
                ItemStack drink = new ItemStack(item);
                LOTRItemMug.setVessel(drink, v, true);
                if (drink.func_77973_b() != item) continue;
                list.add(drink);
            }
        } else {
            super.func_150895_a(item, tab, list);
        }
    }

    protected final Vessel getEmptyVesselType() {
        for (Vessel v : Vessel.values()) {
            if (v.getEmptyVesselItem() != this) continue;
            return v;
        }
        return Vessel.MUG;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float f, float f1, float f2) {
        return LOTRItemMug.tryPlaceMug(itemstack, entityplayer, world, i, j, k, side);
    }

    public static boolean tryPlaceMug(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side) {
        Vessel vessel = LOTRItemMug.getVessel(itemstack);
        if (vessel == null || !vessel.canPlace) {
            return false;
        }
        Block mugBlock = vessel.getBlock();
        Block block = world.func_147439_a(i += Facing.field_71586_b[side], j += Facing.field_71587_c[side], k += Facing.field_71585_d[side]);
        if (block != null && !block.isReplaceable((IBlockAccess)world, i, j, k)) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151586_h) {
            return false;
        }
        if (entityplayer.func_82247_a(i, j, k, side, itemstack)) {
            if (!mugBlock.func_149742_c(world, i, j, k)) {
                return false;
            }
            int l = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            world.func_147465_d(i, j, k, mugBlock, l, 3);
            ItemStack mugFill = itemstack.func_77946_l();
            mugFill.field_77994_a = 1;
            LOTRBlockMug.setMugItem(world, i, j, k, mugFill, vessel);
            world.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, mugBlock.field_149762_H.func_150496_b(), (mugBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, mugBlock.field_149762_H.func_150494_d() * 0.8f);
            --itemstack.field_77994_a;
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!this.isFullMug) {
            ItemStack filled = new ItemStack(LOTRMod.mugWater);
            LOTRItemMug.setVessel(filled, this.getEmptyVesselType(), true);
            MovingObjectPosition m = this.func_77621_a(world, entityplayer, true);
            if (m == null) {
                return itemstack;
            }
            if (m.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int i = m.field_72311_b;
                int j = m.field_72312_c;
                int k = m.field_72309_d;
                if (!world.func_72962_a(entityplayer, i, j, k)) {
                    return itemstack;
                }
                if (!entityplayer.func_82247_a(i, j, k, m.field_72310_e, itemstack)) {
                    return itemstack;
                }
                if (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h && world.func_72805_g(i, j, k) == 0) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                        return filled.func_77946_l();
                    }
                    if (!entityplayer.field_71071_by.func_70441_a(filled.func_77946_l())) {
                        entityplayer.func_71019_a(filled.func_77946_l(), false);
                    }
                    world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                    return itemstack;
                }
            }
            return itemstack;
        }
        if (this.canPlayerDrink(entityplayer)) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        Vessel vessel = LOTRItemMug.getVessel(itemstack);
        float strength = LOTRItemMug.getStrength(itemstack);
        float foodStrength = LOTRItemMug.getFoodStrength(itemstack);
        if (entityplayer.func_71043_e(false)) {
            entityplayer.func_71024_bL().func_75122_a(Math.round((float)this.foodHealAmount * foodStrength), this.foodSaturationAmount * foodStrength);
        }
        if (this.alcoholicity > 0.0f) {
            int duration;
            float alcoholPower = this.alcoholicity * strength;
            int tolerance = LOTRLevelData.getData(entityplayer).getAlcoholTolerance();
            if (tolerance > 0) {
                float f = (float)Math.pow(0.99, tolerance);
                alcoholPower *= f;
            }
            if (!world.field_72995_K && field_77697_d.nextFloat() < alcoholPower && (duration = (int)(60.0f * (1.0f + field_77697_d.nextFloat() * 0.5f) * alcoholPower)) >= 1) {
                int durationTicks = duration * 20;
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, durationTicks));
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.getDrunk);
                int toleranceAdd = Math.round((float)duration / 20.0f);
                LOTRLevelData.getData(entityplayer).setAlcoholTolerance(tolerance += toleranceAdd);
            }
        }
        if (!world.field_72995_K && this.shouldApplyPotionEffects(itemstack, entityplayer)) {
            List<PotionEffect> effects = this.convertPotionEffectsForStrength(strength);
            for (int i = 0; i < effects.size(); ++i) {
                PotionEffect effect = effects.get(i);
                entityplayer.func_70690_d(effect);
            }
        }
        if (this.damageAmount > 0) {
            entityplayer.func_70097_a(DamageSource.field_76376_m, (float)this.damageAmount * strength);
        }
        if (!world.field_72995_K && this.curesEffects) {
            entityplayer.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        if (!world.field_72995_K) {
            if (vessel == Vessel.SKULL) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkSkull);
            }
            if (this == LOTRMod.mugMangoJuice) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkMangoJuice);
            }
            if (this == LOTRMod.mugOrcDraught) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkOrcDraught);
            }
            if (this == LOTRMod.mugAthelasBrew) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkAthelasBrew);
                for (int i = 0; i < Potion.field_76425_a.length; ++i) {
                    Potion potion = Potion.field_76425_a[i];
                    if (potion == null || !LOTRReflection.isBadEffect(potion)) continue;
                    entityplayer.func_82170_o(potion.field_76415_H);
                }
            }
            if (this == LOTRMod.mugRedWine || this == LOTRMod.mugWhiteWine) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkWine);
            }
            if (this == LOTRMod.mugDwarvenTonic) {
                LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.drinkDwarvenTonic);
            }
        }
        return !entityplayer.field_71075_bZ.field_75098_d ? new ItemStack(vessel.getEmptyVesselItem()) : itemstack;
    }

    protected boolean shouldApplyPotionEffects(ItemStack itemstack, EntityPlayer entityplayer) {
        return true;
    }

    public void applyToNPC(LOTREntityNPC npc, ItemStack itemstack) {
        float strength = LOTRItemMug.getStrength(itemstack);
        npc.func_70691_i((float)this.foodHealAmount * strength);
        List<PotionEffect> effects = this.convertPotionEffectsForStrength(strength);
        for (int i = 0; i < effects.size(); ++i) {
            PotionEffect effect = effects.get(i);
            npc.func_70690_d(effect);
        }
        if (this.damageAmount > 0) {
            npc.func_70097_a(DamageSource.field_76376_m, (float)this.damageAmount * strength);
        }
        if (this.curesEffects) {
            npc.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
    }

    public boolean canPlayerDrink(EntityPlayer entityplayer) {
        if (!this.isFullMug) {
            return false;
        }
        return !this.isFoodDrink || entityplayer.func_71043_e(false);
    }

    public static enum Vessel {
        MUG(0, "mug", true, 0),
        MUG_CLAY(1, "clay", true, 1),
        GOBLET_GOLD(2, "gobletGold", true, 10),
        GOBLET_SILVER(3, "gobletSilver", true, 8),
        GOBLET_COPPER(4, "gobletCopper", true, 5),
        GOBLET_WOOD(5, "gobletWood", true, 0),
        SKULL(6, "skull", true, 3),
        GLASS(7, "glass", true, 3),
        BOTTLE(8, "bottle", true, 2),
        SKIN(9, "skin", false, 0),
        HORN(10, "horn", true, 5),
        HORN_GOLD(11, "hornGold", true, 8);

        public final String name;
        public final int id;
        public final boolean canPlace;
        public final int extraPrice;

        private Vessel(int i, String s, boolean flag, int p) {
            this.id = i;
            this.name = s;
            this.canPlace = flag;
            this.extraPrice = p;
        }

        public static Vessel forMeta(int i) {
            for (Vessel v : Vessel.values()) {
                if (v.id != i) continue;
                return v;
            }
            return MUG;
        }

        public Item getEmptyVesselItem() {
            if (this == MUG) {
                return LOTRMod.mug;
            }
            if (this == MUG_CLAY) {
                return LOTRMod.ceramicMug;
            }
            if (this == GOBLET_GOLD) {
                return LOTRMod.gobletGold;
            }
            if (this == GOBLET_SILVER) {
                return LOTRMod.gobletSilver;
            }
            if (this == GOBLET_COPPER) {
                return LOTRMod.gobletCopper;
            }
            if (this == GOBLET_WOOD) {
                return LOTRMod.gobletWood;
            }
            if (this == SKULL) {
                return LOTRMod.skullCup;
            }
            if (this == GLASS) {
                return LOTRMod.wineGlass;
            }
            if (this == BOTTLE) {
                return Items.field_151069_bo;
            }
            if (this == SKIN) {
                return LOTRMod.waterskin;
            }
            if (this == HORN) {
                return LOTRMod.aleHorn;
            }
            if (this == HORN_GOLD) {
                return LOTRMod.aleHornGold;
            }
            return LOTRMod.mug;
        }

        public ItemStack getEmptyVessel() {
            return new ItemStack(this.getEmptyVesselItem());
        }

        public Block getBlock() {
            if (this == MUG) {
                return LOTRMod.mugBlock;
            }
            if (this == MUG_CLAY) {
                return LOTRMod.ceramicMugBlock;
            }
            if (this == GOBLET_GOLD) {
                return LOTRMod.gobletGoldBlock;
            }
            if (this == GOBLET_SILVER) {
                return LOTRMod.gobletSilverBlock;
            }
            if (this == GOBLET_COPPER) {
                return LOTRMod.gobletCopperBlock;
            }
            if (this == GOBLET_WOOD) {
                return LOTRMod.gobletWoodBlock;
            }
            if (this == SKULL) {
                return LOTRMod.skullCupBlock;
            }
            if (this == GLASS) {
                return LOTRMod.wineGlassBlock;
            }
            if (this == BOTTLE) {
                return LOTRMod.glassBottleBlock;
            }
            if (this == SKIN) {
                return null;
            }
            if (this == HORN) {
                return LOTRMod.aleHornBlock;
            }
            if (this == HORN_GOLD) {
                return LOTRMod.aleHornGoldBlock;
            }
            return LOTRMod.mugBlock;
        }
    }
}

