/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.Random;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.quest.LOTRMiniQuest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public abstract class LOTRMiniQuestKill
extends LOTRMiniQuest {
    public int killTarget;
    public int killCount;

    public LOTRMiniQuestKill(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("Target", this.killTarget);
        nbt.func_74768_a("Count", this.killCount);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.killTarget = nbt.func_74762_e("Target");
        this.killCount = nbt.func_74762_e("Count");
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.killTarget > 0;
    }

    @Override
    public String getQuestObjective() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.kill", (Object[])new Object[]{this.killTarget, this.getKillTargetName()});
    }

    protected abstract String getKillTargetName();

    @Override
    public String getObjectiveInSpeech() {
        return this.killTarget + " " + this.getKillTargetName();
    }

    @Override
    public String getProgressedObjectiveInSpeech() {
        return this.killTarget - this.killCount + " " + this.getKillTargetName();
    }

    @Override
    public String getQuestProgress() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.kill.progress", (Object[])new Object[]{this.killCount, this.killTarget});
    }

    @Override
    public String getQuestProgressShorthand() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.progressShort", (Object[])new Object[]{this.killCount, this.killTarget});
    }

    @Override
    public float getCompletionFactor() {
        return (float)this.killCount / (float)this.killTarget;
    }

    @Override
    public ItemStack getQuestIcon() {
        return new ItemStack(Items.field_151040_l);
    }

    @Override
    public void onInteract(EntityPlayer entityplayer, LOTREntityNPC npc) {
        if (this.killCount >= this.killTarget) {
            this.complete(entityplayer, npc);
        } else {
            this.sendProgressSpeechbank(entityplayer, npc);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return (float)this.killTarget * this.rewardFactor;
    }

    @Override
    public int getCoinBonus() {
        return Math.round((float)this.killTarget * 2.0f * this.rewardFactor);
    }

    public static abstract class QFKill<Q extends LOTRMiniQuestKill>
    extends LOTRMiniQuest.QuestFactoryBase<Q> {
        private int minTarget;
        private int maxTarget;

        public QFKill(String name) {
            super(name);
        }

        public QFKill setKillTarget(int min, int max) {
            this.minTarget = min;
            this.maxTarget = max;
            return this;
        }

        @Override
        public Q createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuestKill quest = (LOTRMiniQuestKill)super.createQuest(npc, rand);
            quest.killTarget = MathHelper.func_76136_a((Random)rand, (int)this.minTarget, (int)this.maxTarget);
            return (Q)quest;
        }
    }
}

