/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemLeatherHat;
import lotr.common.quest.IPickpocketable;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestCollectBase;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;

public class LOTRMiniQuestPickpocket
extends LOTRMiniQuestCollectBase {
    public LOTRFaction pickpocketFaction;
    private Set<UUID> pickpocketedEntityIDs = new HashSet<UUID>();

    public LOTRMiniQuestPickpocket(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("PickpocketFaction", this.pickpocketFaction.codeName());
        NBTTagList ids = new NBTTagList();
        for (UUID id : this.pickpocketedEntityIDs) {
            ids.func_74742_a((NBTBase)new NBTTagString(id.toString()));
        }
        nbt.func_74782_a("PickpocketedIDs", (NBTBase)ids);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pickpocketFaction = LOTRFaction.forName(nbt.func_74779_i("PickpocketFaction"));
        this.pickpocketedEntityIDs.clear();
        NBTTagList ids = nbt.func_150295_c("PickpocketedIDs", 8);
        for (int i = 0; i < ids.func_74745_c(); ++i) {
            UUID id = UUID.fromString(ids.func_150307_f(i));
            if (id == null) continue;
            this.pickpocketedEntityIDs.add(id);
        }
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.pickpocketFaction != null;
    }

    @Override
    public String getQuestObjective() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.pickpocket", (Object[])new Object[]{this.collectTarget, this.pickpocketFaction.factionEntityName()});
    }

    @Override
    public String getObjectiveInSpeech() {
        return this.pickpocketFaction.factionEntityName();
    }

    @Override
    public String getProgressedObjectiveInSpeech() {
        return this.collectTarget - this.amountGiven + " " + this.pickpocketFaction.factionEntityName();
    }

    @Override
    public String getQuestProgress() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.pickpocket.progress", (Object[])new Object[]{this.amountGiven, this.collectTarget});
    }

    @Override
    public ItemStack getQuestIcon() {
        return LOTRMiniQuestPickpocket.createPickpocketIcon();
    }

    public static ItemStack createPickpocketIcon() {
        ItemStack hat = new ItemStack(LOTRMod.leatherHat);
        LOTRItemLeatherHat.setHatColor(hat, 0);
        LOTRItemLeatherHat.setFeatherColor(hat, 0xFFFFFF);
        return hat;
    }

    @Override
    protected boolean isQuestItem(ItemStack itemstack) {
        return IPickpocketable.Helper.isPickpocketed(itemstack) && this.entityUUID.equals(IPickpocketable.Helper.getWanterID(itemstack));
    }

    @Override
    public boolean onInteractOther(final EntityPlayer entityplayer, final LOTREntityNPC npc) {
        if (entityplayer.func_70093_af() && entityplayer.func_70694_bm() == null && npc.getFaction() == this.pickpocketFaction && npc instanceof IPickpocketable) {
            IPickpocketable ppable = (IPickpocketable)((Object)npc);
            UUID id = npc.getPersistentID();
            if (ppable.canPickpocket() && !this.pickpocketedEntityIDs.contains(id)) {
                boolean noticed;
                boolean success;
                if (npc.func_70638_az() != null) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.inCombat", new Object[0]));
                    return true;
                }
                if (this.isEntityWatching((EntityLiving)npc, (EntityLivingBase)entityplayer)) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.watched", new Object[0]));
                    return true;
                }
                Random rand = npc.func_70681_au();
                boolean bl = success = rand.nextInt(3) == 0;
                boolean anyoneNoticed = noticed = success ? rand.nextInt(3) == 0 : rand.nextInt(4) == 0;
                if (success) {
                    ItemStack picked = ppable.createPickpocketItem();
                    IPickpocketable.Helper.setPickpocketData(picked, npc.getNPCName(), this.entityNameFull, this.entityUUID);
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, picked);
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.success", new Object[]{picked.field_77994_a, picked.func_82833_r(), npc.getNPCName()}));
                    npc.func_85030_a("lotr:event.trade", 0.5f, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    npc.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
                    this.spawnPickingFX("pickpocket", 1.0, (EntityLivingBase)npc);
                    this.pickpocketedEntityIDs.add(id);
                    this.updateQuest();
                    LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.pickpocket);
                } else {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.missed", new Object[]{npc.getNPCName()}));
                    npc.func_85030_a(Blocks.field_150325_L.field_149762_H.func_150495_a(), 0.5f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.spawnPickingFX("pickpocketFail", 0.4, (EntityLivingBase)npc);
                }
                if (noticed) {
                    entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.noticed", new Object[]{npc.getNPCName()}));
                    npc.setAttackTarget((EntityLivingBase)entityplayer, true);
                    npc.func_70604_c((EntityLivingBase)entityplayer);
                    this.spawnAngryFX((EntityLivingBase)npc);
                }
                if (!noticed || rand.nextFloat() < 0.5f) {
                    double civilianRange = 8.0;
                    double guardRange = 16.0;
                    double fullAlertRange = 4.0;
                    List nearbyFriends = npc.field_70170_p.func_82733_a(LOTREntityNPC.class, npc.field_70121_D.func_72314_b(16.0, 16.0, 16.0), new IEntitySelector(){

                        public boolean func_82704_a(Entity entity) {
                            LOTREntityNPC otherNPC = (LOTREntityNPC)entity;
                            if (otherNPC.func_70089_S() && otherNPC.getFaction().isGoodRelation(npc.getFaction())) {
                                return otherNPC.hiredNPCInfo.getHiringPlayer() != entityplayer;
                            }
                            return false;
                        }
                    });
                    for (Object o : nearbyFriends) {
                        boolean otherNoticed;
                        double maxRange;
                        LOTREntityNPC otherNPC = (LOTREntityNPC)o;
                        if (otherNPC == npc) continue;
                        boolean civilian = otherNPC.isCivilianNPC();
                        double d = maxRange = civilian ? 8.0 : 16.0;
                        double dist = otherNPC.func_70032_d((Entity)npc);
                        if (!(dist <= maxRange) || otherNPC.func_70638_az() != null || !this.isEntityWatching((EntityLiving)otherNPC, (EntityLivingBase)entityplayer)) continue;
                        float distFactor = 1.0f - (float)((dist - 4.0) / (maxRange - 4.0));
                        float chance = 0.5f + distFactor * 0.5f;
                        if (civilian) {
                            chance *= 0.25f;
                        }
                        if (!(otherNoticed = rand.nextFloat() < chance)) continue;
                        entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.pickpocket.otherNoticed", new Object[]{otherNPC.getEntityClassName()}));
                        otherNPC.setAttackTarget((EntityLivingBase)entityplayer, true);
                        otherNPC.func_70604_c((EntityLivingBase)entityplayer);
                        this.spawnAngryFX((EntityLivingBase)otherNPC);
                        anyoneNoticed = true;
                    }
                }
                if (anyoneNoticed) {
                    LOTRLevelData.getData(entityplayer).addAlignment(entityplayer, LOTRAlignmentValues.PICKPOCKET_PENALTY, npc.getFaction(), (Entity)npc);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isEntityWatching(EntityLiving watcher, EntityLivingBase target) {
        float fov;
        float fovCos;
        Vec3 look = watcher.func_70040_Z();
        Vec3 watcherEyes = Vec3.func_72443_a((double)watcher.field_70165_t, (double)(watcher.field_70121_D.field_72338_b + (double)watcher.func_70047_e()), (double)watcher.field_70161_v);
        Vec3 targetEyes = Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70121_D.field_72338_b + (double)target.func_70047_e()), (double)target.field_70161_v);
        Vec3 disp = Vec3.func_72443_a((double)(targetEyes.field_72450_a - watcherEyes.field_72450_a), (double)(targetEyes.field_72448_b - watcherEyes.field_72448_b), (double)(targetEyes.field_72449_c - watcherEyes.field_72449_c));
        double dot = disp.func_72432_b().func_72430_b(look.func_72432_b());
        if (dot >= (double)(fovCos = MathHelper.func_76134_b((float)((fov = (float)Math.toRadians(130.0)) / 2.0f)))) {
            return watcher.func_70635_at().func_75522_a((Entity)target);
        }
        return false;
    }

    private void spawnPickingFX(String particle, double upSpeed, EntityLivingBase npc) {
        Random rand = npc.func_70681_au();
        int particles = 3 + rand.nextInt(8);
        for (int p = 0; p < particles; ++p) {
            double x = npc.field_70165_t;
            double y = npc.field_70121_D.field_72338_b + (double)(npc.field_70131_O * 0.5f);
            double z = npc.field_70161_v;
            float w = npc.field_70130_N * 0.1f;
            float ang = rand.nextFloat() * (float)Math.PI * 2.0f;
            double hSpeed = MathHelper.func_82716_a((Random)rand, (double)0.05, (double)0.08);
            double vx = (double)MathHelper.func_76134_b((float)ang) * hSpeed;
            double vz = (double)MathHelper.func_76126_a((float)ang) * hSpeed;
            double vy = MathHelper.func_82716_a((Random)rand, (double)0.1, (double)0.25) * upSpeed;
            LOTRMod.proxy.spawnParticle(particle, x += (double)(MathHelper.func_76134_b((float)ang) * w), y, z += (double)(MathHelper.func_76126_a((float)ang) * w), vx, vy, vz);
        }
    }

    private void spawnAngryFX(EntityLivingBase npc) {
        LOTRMod.proxy.spawnParticle("angry", npc.field_70165_t, npc.field_70121_D.field_72338_b + (double)(npc.field_70131_O * 2.0f), npc.field_70161_v, npc.field_70159_w, Math.max(0.0, npc.field_70181_x), npc.field_70179_y);
    }

    @Override
    public int getCoinBonus() {
        return Math.round(this.getAlignmentBonus() * 5.0f);
    }

    public static class QFPickpocket<Q extends LOTRMiniQuestPickpocket>
    extends LOTRMiniQuest.QuestFactoryBase<Q> {
        private LOTRFaction pickpocketFaction;
        private int minTarget;
        private int maxTarget;

        public QFPickpocket(String name) {
            super(name);
        }

        public QFPickpocket setPickpocketFaction(LOTRFaction f, int min, int max) {
            this.pickpocketFaction = f;
            this.minTarget = min;
            this.maxTarget = max;
            return this;
        }

        @Override
        public Class getQuestClass() {
            return LOTRMiniQuestPickpocket.class;
        }

        @Override
        public Q createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuestPickpocket quest = (LOTRMiniQuestPickpocket)super.createQuest(npc, rand);
            quest.pickpocketFaction = this.pickpocketFaction;
            quest.collectTarget = MathHelper.func_76136_a((Random)rand, (int)this.minTarget, (int)this.maxTarget);
            return (Q)quest;
        }
    }
}

