/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import com.google.common.math.IntMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.client.render.LOTRCloudRenderer;
import lotr.client.render.LOTRSkyRenderer;
import lotr.client.render.LOTRWeatherRenderer;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDate;
import lotr.common.LOTRDimension;
import lotr.common.LOTRMod;
import lotr.common.LOTRTime;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenOcean;
import lotr.common.world.biome.LOTRBiomeGenTundra;
import lotr.compatibility.LOTRModChecker;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.ForgeModContainer;

public abstract class LOTRWorldProvider
extends WorldProvider {
    public static int MOON_PHASES = 8;
    @SideOnly(value=Side.CLIENT)
    private IRenderHandler lotrSkyRenderer;
    @SideOnly(value=Side.CLIENT)
    private IRenderHandler lotrCloudRenderer;
    @SideOnly(value=Side.CLIENT)
    private IRenderHandler lotrWeatherRenderer;
    private boolean spawnHostiles = true;
    private boolean spawnPeacefuls = true;
    private double cloudsR;
    private double cloudsG;
    private double cloudsB;
    private double fogR;
    private double fogG;
    private double fogB;

    public abstract LOTRDimension getLOTRDimension();

    public void func_76572_b() {
        this.field_76578_c = new LOTRWorldChunkManager(this.field_76579_a, this.getLOTRDimension());
        this.field_76574_g = this.getLOTRDimension().dimensionID;
    }

    public String getWelcomeMessage() {
        return StatCollector.func_74837_a((String)"lotr.dimension.enter", (Object[])new Object[]{this.getLOTRDimension().getDimensionName()});
    }

    public String getDepartMessage() {
        return StatCollector.func_74837_a((String)"lotr.dimension.exit", (Object[])new Object[]{this.getLOTRDimension().getDimensionName()});
    }

    public String getSaveFolder() {
        return this.getLOTRDimension().dimensionName;
    }

    public String func_80007_l() {
        return this.getLOTRDimension().dimensionName;
    }

    public boolean func_76567_e() {
        return true;
    }

    public BiomeGenBase getBiomeGenForCoords(int i, int k) {
        Chunk chunk;
        if (this.field_76579_a.func_72899_e(i, 0, k) && (chunk = this.field_76579_a.func_72938_d(i, k)) != null) {
            int chunkX = i & 0xF;
            int chunkZ = k & 0xF;
            int biomeID = chunk.func_76605_m()[chunkZ << 4 | chunkX] & 0xFF;
            if (biomeID == 255) {
                BiomeGenBase biomegenbase = this.field_76578_c.func_76935_a((chunk.field_76635_g << 4) + chunkX, (chunk.field_76647_h << 4) + chunkZ);
                biomeID = biomegenbase.field_76756_M;
                chunk.func_76605_m()[chunkZ << 4 | chunkX] = (byte)(biomeID & 0xFF);
            }
            LOTRDimension dim = this.getLOTRDimension();
            return dim.biomeList[biomeID] == null ? dim.biomeList[0] : dim.biomeList[biomeID];
        }
        return this.field_76578_c.func_76935_a(i, k);
    }

    public boolean canBlockFreeze(int i, int j, int k, boolean isBlockUpdate) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenOcean) {
            return LOTRBiomeGenOcean.isFrozen(i, k) && this.canFreeze_ignoreTemp(i, j, k, isBlockUpdate);
        }
        if (biome instanceof LOTRBiome) {
            return this.field_76579_a.canBlockFreezeBody(i, j, k, isBlockUpdate);
        }
        return this.field_76579_a.canBlockFreezeBody(i, j, k, isBlockUpdate);
    }

    public boolean canSnowAt(int i, int j, int k, boolean checkLight) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenOcean) {
            return LOTRBiomeGenOcean.isFrozen(i, k) && this.canSnow_ignoreTemp(i, j, k, checkLight);
        }
        if (biome instanceof LOTRBiomeGenTundra) {
            boolean flag = this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
            return flag && LOTRBiomeGenTundra.isTundraSnowy(i, k);
        }
        if (biome instanceof LOTRBiome) {
            return j >= ((LOTRBiome)biome).getSnowHeight() && this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
        }
        return this.field_76579_a.canSnowAtBody(i, j, k, checkLight);
    }

    private boolean canFreeze_ignoreTemp(int i, int j, int k, boolean isBlockUpdate) {
        Block block;
        if (j >= 0 && j < this.field_76579_a.func_72800_K() && this.field_76579_a.func_72972_b(EnumSkyBlock.Block, i, j, k) < 10 && ((block = this.field_76579_a.func_147439_a(i, j, k)) == Blocks.field_150355_j || block == Blocks.field_150358_i) && this.field_76579_a.func_72805_g(i, j, k) == 0) {
            if (!isBlockUpdate) {
                return true;
            }
            boolean surroundWater = true;
            if (surroundWater && this.field_76579_a.func_147439_a(i - 1, j, k).func_149688_o() != Material.field_151586_h) {
                surroundWater = false;
            }
            if (surroundWater && this.field_76579_a.func_147439_a(i + 1, j, k).func_149688_o() != Material.field_151586_h) {
                surroundWater = false;
            }
            if (surroundWater && this.field_76579_a.func_147439_a(i, j, k - 1).func_149688_o() != Material.field_151586_h) {
                surroundWater = false;
            }
            if (surroundWater && this.field_76579_a.func_147439_a(i, j, k + 1).func_149688_o() != Material.field_151586_h) {
                surroundWater = false;
            }
            if (!surroundWater) {
                return true;
            }
        }
        return false;
    }

    private boolean canSnow_ignoreTemp(int i, int j, int k, boolean checkLight) {
        Block block;
        if (!checkLight) {
            return true;
        }
        return j >= 0 && j < this.field_76579_a.func_72800_K() && this.field_76579_a.func_72972_b(EnumSkyBlock.Block, i, j, k) < 10 && (block = this.field_76579_a.func_147439_a(i, j, k)).func_149688_o() == Material.field_151579_a && Blocks.field_150431_aC.func_149742_c(this.field_76579_a, i, j, k);
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return false;
    }

    public void resetRainAndThunder() {
        super.resetRainAndThunder();
        if (LOTRMod.doDayCycle(this.field_76579_a)) {
            LOTRTime.advanceToMorning();
        }
    }

    public float func_76563_a(long time, float partialTick) {
        float daytime = ((float)((int)(time % (long)LOTRTime.DAY_LENGTH)) + partialTick) / (float)LOTRTime.DAY_LENGTH - 0.25f;
        if (daytime < 0.0f) {
            daytime += 1.0f;
        }
        if (daytime > 1.0f) {
            daytime -= 1.0f;
        }
        float angle = 1.0f - (float)((Math.cos((double)daytime * Math.PI) + 1.0) / 2.0);
        angle = daytime + (angle - daytime) / 3.0f;
        return angle;
    }

    public int func_76559_b(long time) {
        return LOTRWorldProvider.getLOTRMoonPhase();
    }

    public static int getLOTRMoonPhase() {
        int day = LOTRDate.ShireReckoning.currentDay;
        return IntMath.mod((int)day, (int)MOON_PHASES);
    }

    public static boolean isLunarEclipse() {
        int day = LOTRDate.ShireReckoning.currentDay;
        return LOTRWorldProvider.getLOTRMoonPhase() == 0 && IntMath.mod((int)(day / MOON_PHASES), (int)4) == 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (!LOTRModChecker.hasShaders() && LOTRConfig.enableLOTRSky) {
            if (this.lotrSkyRenderer == null) {
                this.lotrSkyRenderer = new LOTRSkyRenderer(this);
            }
            return this.lotrSkyRenderer;
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (this.lotrWeatherRenderer == null) {
            this.lotrWeatherRenderer = new LOTRWeatherRenderer();
        }
        return this.lotrWeatherRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (!LOTRModChecker.hasShaders() && LOTRConfig.cloudRange > 0) {
            if (this.lotrCloudRenderer == null) {
                this.lotrCloudRenderer = new LOTRCloudRenderer();
            }
            return this.lotrCloudRenderer;
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 192.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawClouds(float f) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_71451_h.field_70165_t;
        int k = (int)mc.field_71451_h.field_70161_v;
        Vec3 clouds = super.drawClouds(f);
        this.cloudsB = 0.0;
        this.cloudsG = 0.0;
        this.cloudsR = 0.0;
        GameSettings settings = mc.field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int l = 0;
        for (int i1 = -distance; i1 <= distance; ++i1) {
            for (int k1 = -distance; k1 <= distance; ++k1) {
                Vec3 tempClouds = Vec3.func_72443_a((double)clouds.field_72450_a, (double)clouds.field_72448_b, (double)clouds.field_72449_c);
                BiomeGenBase biome = this.field_76579_a.func_72807_a(i + i1, k + k1);
                if (biome instanceof LOTRBiome) {
                    ((LOTRBiome)biome).getCloudColor(tempClouds);
                }
                this.cloudsR += tempClouds.field_72450_a;
                this.cloudsG += tempClouds.field_72448_b;
                this.cloudsB += tempClouds.field_72449_c;
                ++l;
            }
        }
        this.cloudsR /= (double)l;
        this.cloudsG /= (double)l;
        this.cloudsB /= (double)l;
        return Vec3.func_72443_a((double)this.cloudsR, (double)this.cloudsG, (double)this.cloudsB);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float f, float f1) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_71451_h.field_70165_t;
        int k = (int)mc.field_71451_h.field_70161_v;
        Vec3 fog = super.func_76562_b(f, f1);
        this.fogB = 0.0;
        this.fogG = 0.0;
        this.fogR = 0.0;
        GameSettings settings = mc.field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int l = 0;
        for (int i1 = -distance; i1 <= distance; ++i1) {
            for (int k1 = -distance; k1 <= distance; ++k1) {
                Vec3 tempFog = Vec3.func_72443_a((double)fog.field_72450_a, (double)fog.field_72448_b, (double)fog.field_72449_c);
                BiomeGenBase biome = this.field_76579_a.func_72807_a(i + i1, k + k1);
                if (biome instanceof LOTRBiome) {
                    ((LOTRBiome)biome).getFogColor(tempFog);
                }
                this.fogR += tempFog.field_72450_a;
                this.fogG += tempFog.field_72448_b;
                this.fogB += tempFog.field_72449_c;
                ++l;
            }
        }
        this.fogR /= (double)l;
        this.fogG /= (double)l;
        this.fogB /= (double)l;
        return Vec3.func_72443_a((double)this.fogR, (double)this.fogG, (double)this.fogB);
    }

    public float[] modifyFogIntensity(float farPlane, int fogMode) {
        Minecraft mc = Minecraft.func_71410_x();
        int i = (int)mc.field_71451_h.field_70165_t;
        int k = (int)mc.field_71451_h.field_70161_v;
        float fogStart = 0.0f;
        float fogEnd = 0.0f;
        GameSettings settings = mc.field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        int l = 0;
        for (int i1 = -distance; i1 <= distance; ++i1) {
            for (int k1 = -distance; k1 <= distance; ++k1) {
                float thisFogStart = 0.0f;
                float thisFogEnd = 0.0f;
                boolean foggy = this.func_76568_b(i + i1, k + k1);
                if (foggy) {
                    thisFogStart = farPlane * 0.05f;
                    thisFogEnd = Math.min(farPlane, 192.0f) * 0.5f;
                } else if (fogMode < 0) {
                    thisFogStart = 0.0f;
                    thisFogEnd = farPlane;
                } else {
                    thisFogStart = farPlane * 0.75f;
                    thisFogEnd = farPlane;
                }
                fogStart += thisFogStart;
                fogEnd += thisFogEnd;
                ++l;
            }
        }
        return new float[]{fogStart /= (float)l, fogEnd /= (float)l};
    }

    public float[] handleFinalFogColors(EntityLivingBase viewer, double tick, float[] rgb) {
        return rgb;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int i, int k) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a(i, k);
        if (biome instanceof LOTRBiome) {
            return ((LOTRBiome)biome).hasFog();
        }
        return super.func_76568_b(i, k);
    }
}

