/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import lotr.common.LOTRDimension;
import lotr.common.network.LOTRPacketBlockFX;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.world.LOTRChunkProviderUtumno;
import lotr.common.world.LOTRUtumnoLevel;
import lotr.common.world.LOTRWorldProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class LOTRWorldProviderUtumno
extends LOTRWorldProvider {
    public LOTRWorldProviderUtumno() {
        this.field_76576_e = true;
    }

    @Override
    public LOTRDimension getLOTRDimension() {
        return LOTRDimension.UTUMNO;
    }

    public IChunkProvider func_76555_c() {
        return new LOTRChunkProviderUtumno(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    protected void func_76556_a() {
        for (int i = 0; i <= 15; ++i) {
            float f = (float)i / 15.0f;
            this.field_76573_f[i] = (float)Math.pow(f, 4.0);
        }
    }

    @Override
    public float func_76563_a(long time, float f) {
        return 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        return 1.0;
    }

    @Override
    public float[] handleFinalFogColors(EntityLivingBase viewer, double tick, float[] rgb) {
        double y = viewer.field_70167_r + (viewer.field_70163_u - viewer.field_70167_r) * tick;
        LOTRUtumnoLevel level = LOTRUtumnoLevel.forY((int)y);
        if (level == LOTRUtumnoLevel.FIRE) {
            int min = level.getLowestCorridorFloor();
            int max = level.getHighestCorridorRoof();
            max = (int)((double)max - (double)(max - min) * 0.3);
            double yFactor = (y - (double)min) / (double)(max - min);
            yFactor = MathHelper.func_151237_a((double)yFactor, (double)0.0, (double)1.0);
            yFactor = 1.0 - yFactor;
            Color clr = new Color(rgb[0], rgb[1], rgb[2]);
            float[] hsb = Color.RGBtoHSB(clr.getRed(), clr.getGreen(), clr.getBlue(), null);
            float br = hsb[2];
            if ((double)br > 0.0) {
                hsb[2] = br = (float)((double)br + (double)(1.0f - br) * yFactor);
            }
            rgb = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2])).getRGBComponents(null);
        }
        return rgb;
    }

    @Override
    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP entityplayer) {
        return LOTRDimension.MIDDLE_EARTH.dimensionID;
    }

    public boolean func_76569_d() {
        return false;
    }

    public int getActualHeight() {
        return this.getHeight();
    }

    public void setSpawnPoint(int i, int j, int k) {
    }

    public static void doEvaporateFX(World world, int i, int j, int k) {
        if (!world.field_72995_K) {
            world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            LOTRPacketBlockFX pkt = new LOTRPacketBlockFX(LOTRPacketBlockFX.Type.UTUMNO_EVAPORATE, i, j, k);
            LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)pkt, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, 32.0));
        }
    }

    public static interface UtumnoBlock {
    }
}

