/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.LOTRChunkProvider;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenMordor;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.feature.LOTRTreeType;
import lotr.common.world.feature.LOTRWorldGenBerryBush;
import lotr.common.world.feature.LOTRWorldGenBiomeFlowers;
import lotr.common.world.feature.LOTRWorldGenBushes;
import lotr.common.world.feature.LOTRWorldGenCaveCobwebs;
import lotr.common.world.feature.LOTRWorldGenCorn;
import lotr.common.world.feature.LOTRWorldGenFallenLeaves;
import lotr.common.world.feature.LOTRWorldGenLogs;
import lotr.common.world.feature.LOTRWorldGenReeds;
import lotr.common.world.feature.LOTRWorldGenSand;
import lotr.common.world.feature.LOTRWorldGenStalactites;
import lotr.common.world.feature.LOTRWorldGenStreams;
import lotr.common.world.feature.LOTRWorldGenSurfaceGravel;
import lotr.common.world.feature.LOTRWorldGenTrollHoard;
import lotr.common.world.map.LOTRRoads;
import lotr.common.world.structure.LOTRWorldGenMarshHut;
import lotr.common.world.structure.LOTRWorldGenOrcDungeon;
import lotr.common.world.structure2.LOTRWorldGenGrukHouse;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import lotr.common.world.structure2.LOTRWorldGenTicketBooth;
import lotr.common.world.village.LOTRVillageGen;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeDecorator {
    private World worldObj;
    private Random rand;
    private int chunkX;
    private int chunkZ;
    private LOTRBiome biome;
    private List<OreGenerant> biomeSoils = new ArrayList<OreGenerant>();
    private List<OreGenerant> biomeOres = new ArrayList<OreGenerant>();
    private List<OreGenerant> biomeGems = new ArrayList<OreGenerant>();
    public float biomeOreFactor = 1.0f;
    public float biomeGemFactor = 0.5f;
    protected WorldGenerator clayGen = new LOTRWorldGenSand(Blocks.field_150435_aG, 5, 1);
    private WorldGenerator sandGen = new LOTRWorldGenSand((Block)Blocks.field_150354_m, 7, 2);
    private WorldGenerator whiteSandGen = new LOTRWorldGenSand(LOTRMod.whiteSand, 7, 2);
    private WorldGenerator quagmireGen = new LOTRWorldGenSand(LOTRMod.quagmire, 7, 2);
    private WorldGenerator surfaceGravelGen = new LOTRWorldGenSurfaceGravel();
    private WorldGenerator flowerGen = new LOTRWorldGenBiomeFlowers();
    private WorldGenerator logGen = new LOTRWorldGenLogs();
    private WorldGenerator mushroomBrownGen = new WorldGenFlowers((Block)Blocks.field_150338_P);
    private WorldGenerator mushroomRedGen = new WorldGenFlowers((Block)Blocks.field_150337_Q);
    private WorldGenerator caneGen = new WorldGenReed();
    private WorldGenerator reedGen = new LOTRWorldGenReeds(LOTRMod.reeds);
    private WorldGenerator dryReedGen = new LOTRWorldGenReeds(LOTRMod.driedReeds);
    private WorldGenerator cornGen = new LOTRWorldGenCorn();
    private WorldGenerator pumpkinGen = new WorldGenPumpkin();
    private WorldGenerator waterlilyGen = new WorldGenWaterlily();
    private WorldGenerator cobwebGen = new LOTRWorldGenCaveCobwebs();
    private WorldGenerator stalactiteGen = new LOTRWorldGenStalactites();
    private WorldGenerator vinesGen = new WorldGenVines();
    private WorldGenerator cactusGen = new WorldGenCactus();
    private WorldGenerator melonGen = new WorldGenMelon();
    public int sandPerChunk = 4;
    public int clayPerChunk = 3;
    public int quagmirePerChunk = 0;
    public int treesPerChunk = 0;
    public int willowPerChunk = 0;
    public int logsPerChunk = 0;
    public int vinesPerChunk = 0;
    public int flowersPerChunk = 2;
    public int doubleFlowersPerChunk = 0;
    public int grassPerChunk = 1;
    public int doubleGrassPerChunk = 0;
    public boolean enableFern = false;
    public boolean enableSpecialGrasses = true;
    public int deadBushPerChunk = 0;
    public int waterlilyPerChunk = 0;
    public int mushroomsPerChunk = 0;
    public boolean enableRandomMushroom = true;
    public int canePerChunk = 0;
    public int reedPerChunk = 1;
    public float dryReedChance = 0.1f;
    public int cornPerChunk = 0;
    public int cactiPerChunk = 0;
    public float melonPerChunk = 0.0f;
    public boolean generateWater = true;
    public boolean generateLava = true;
    public boolean generateCobwebs = true;
    public boolean generateAthelas = false;
    public boolean whiteSand = false;
    private int treeClusterSize;
    private int treeClusterChance = -1;
    private WorldGenerator orcDungeonGen = new LOTRWorldGenOrcDungeon(false);
    private WorldGenerator trollHoardGen = new LOTRWorldGenTrollHoard();
    public boolean generateOrcDungeon = false;
    public boolean generateTrollHoard = false;
    private List<LOTRTreeType.WeightedTreeType> treeTypes = new ArrayList<LOTRTreeType.WeightedTreeType>();
    private Random structureRand = new Random();
    private List<RandomStructure> randomStructures = new ArrayList<RandomStructure>();
    private List<LOTRVillageGen> villages = new ArrayList<LOTRVillageGen>();

    public void addSoil(WorldGenerator gen, float f, int min, int max) {
        this.biomeSoils.add(new OreGenerant(gen, f, min, max));
    }

    public void addOre(WorldGenerator gen, float f, int min, int max) {
        this.biomeOres.add(new OreGenerant(gen, f, min, max));
    }

    public void addGem(WorldGenerator gen, float f, int min, int max) {
        this.biomeGems.add(new OreGenerant(gen, f, min, max));
    }

    public void clearOres() {
        this.biomeSoils.clear();
        this.biomeOres.clear();
        this.biomeGems.clear();
    }

    private void addDefaultOres() {
        this.addSoil((WorldGenerator)new WorldGenMinable(Blocks.field_150346_d, 32), 40.0f, 0, 256);
        this.addSoil((WorldGenerator)new WorldGenMinable(Blocks.field_150351_n, 32), 20.0f, 0, 256);
        this.addOre((WorldGenerator)new WorldGenMinable(Blocks.field_150365_q, 16), 40.0f, 0, 128);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreCopper, 8), 16.0f, 0, 128);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreTin, 8), 16.0f, 0, 128);
        this.addOre((WorldGenerator)new WorldGenMinable(Blocks.field_150366_p, 8), 20.0f, 0, 64);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreSulfur, 8), 2.0f, 0, 64);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreSaltpeter, 8), 2.0f, 0, 64);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreSalt, 12), 2.0f, 0, 64);
        this.addOre((WorldGenerator)new WorldGenMinable(Blocks.field_150352_o, 8), 2.0f, 0, 32);
        this.addOre((WorldGenerator)new WorldGenMinable(LOTRMod.oreSilver, 8), 3.0f, 0, 32);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 1, 6, Blocks.field_150348_b), 2.0f, 0, 64);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 0, 6, Blocks.field_150348_b), 2.0f, 0, 64);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 4, 5, Blocks.field_150348_b), 1.5f, 0, 48);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 6, 5, Blocks.field_150348_b), 1.5f, 0, 48);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 2, 4, Blocks.field_150348_b), 1.0f, 0, 32);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 3, 4, Blocks.field_150348_b), 1.0f, 0, 32);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 7, 4, Blocks.field_150348_b), 0.75f, 0, 24);
        this.addGem((WorldGenerator)new WorldGenMinable(LOTRMod.oreGem, 5, 4, Blocks.field_150348_b), 0.5f, 0, 16);
    }

    public LOTRBiomeDecorator(LOTRBiome lotrbiome) {
        this.biome = lotrbiome;
        this.addDefaultOres();
    }

    public void addTree(LOTRTreeType type, int weight) {
        this.treeTypes.add(new LOTRTreeType.WeightedTreeType(type, weight));
    }

    public void clearTrees() {
        this.treeTypes.clear();
    }

    public LOTRTreeType getRandomTree(Random random) {
        if (this.treeTypes.isEmpty()) {
            return LOTRTreeType.OAK;
        }
        WeightedRandom.Item item = WeightedRandom.func_76271_a((Random)random, this.treeTypes);
        return ((LOTRTreeType.WeightedTreeType)item).treeType;
    }

    public LOTRTreeType getRandomTreeForVariant(Random random, LOTRBiomeVariant variant) {
        if (variant.treeTypes.isEmpty()) {
            return this.getRandomTree(random);
        }
        float f = variant.variantTreeChance;
        if (random.nextFloat() < f) {
            return variant.getRandomTree(random);
        }
        return this.getRandomTree(random);
    }

    public void genTree(World world, Random random, int i, int j, int k) {
        WorldGenAbstractTree treeGen = this.biome.getTreeGen(world, random, i, j, k);
        treeGen.func_76484_a(world, random, i, j, k);
    }

    public void setTreeCluster(int size, int chance) {
        this.treeClusterSize = size;
        this.treeClusterChance = chance;
    }

    public void resetTreeCluster() {
        this.setTreeCluster(0, -1);
    }

    public void addRandomStructure(WorldGenerator structure, int chunkChance) {
        this.randomStructures.add(new RandomStructure(structure, chunkChance));
    }

    public void clearRandomStructures() {
        this.randomStructures.clear();
    }

    public void addVillage(LOTRVillageGen village) {
        this.villages.add(village);
    }

    public void clearVillages() {
        this.villages.clear();
    }

    public void checkForVillages(World world, int i, int k, LOTRChunkProvider.ChunkFlags chunkFlags) {
        chunkFlags.isVillage = false;
        chunkFlags.isFlatVillage = false;
        for (LOTRVillageGen village : this.villages) {
            List<LOTRVillageGen.AbstractInstance<?>> instances = village.getNearbyVillagesAtPosition(world, i, k);
            if (instances.isEmpty()) continue;
            chunkFlags.isVillage = true;
            for (LOTRVillageGen.AbstractInstance<?> inst : instances) {
                if (!inst.isFlat()) continue;
                chunkFlags.isFlatVillage = true;
            }
        }
    }

    public boolean anyFixedVillagesAt(World world, int i, int k) {
        for (LOTRVillageGen village : this.villages) {
            if (!village.anyFixedVillagesAt(world, i, k)) continue;
            return true;
        }
        return false;
    }

    public int getVariantTreesPerChunk(LOTRBiomeVariant variant) {
        int trees = this.treesPerChunk;
        if (variant.treeFactor > 1.0f) {
            trees = Math.max(trees, 1);
        }
        trees = Math.round((float)trees * variant.treeFactor);
        return trees;
    }

    public void decorate(World world, Random random, int i, int k) {
        this.worldObj = world;
        this.rand = random;
        this.chunkX = i;
        this.chunkZ = k;
        this.decorate();
    }

    private void decorate() {
        int i;
        int l;
        int j;
        int l2;
        int k;
        int i2;
        int k2;
        int l3;
        float reciprocalTreeFactor;
        int cluster;
        int j2;
        int k3;
        int j3;
        int i3;
        int l4;
        int k4;
        int i4;
        LOTRBiomeVariant biomeVariant = ((LOTRWorldChunkManager)this.worldObj.func_72959_q()).getBiomeVariantAt(this.chunkX + 8, this.chunkZ + 8);
        this.generateOres();
        biomeVariant.decorateVariant(this.worldObj, this.rand, this.chunkX, this.chunkZ, this.biome);
        if (this.rand.nextBoolean() && this.generateCobwebs) {
            i4 = this.chunkX + this.rand.nextInt(16) + 8;
            int j4 = this.rand.nextInt(60);
            k4 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.cobwebGen.func_76484_a(this.worldObj, this.rand, i4, j4, k4);
        }
        for (l4 = 0; l4 < 3; ++l4) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            j3 = this.rand.nextInt(60);
            int k5 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.stalactiteGen.func_76484_a(this.worldObj, this.rand, i3, j3, k5);
        }
        for (l4 = 0; l4 < this.quagmirePerChunk; ++l4) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k4 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.quagmireGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k4), k4);
        }
        for (l4 = 0; l4 < this.sandPerChunk; ++l4) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k4 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator biomeSandGenerator = this.sandGen;
            if (this.whiteSand) {
                biomeSandGenerator = this.whiteSandGen;
            }
            biomeSandGenerator.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k4), k4);
        }
        for (l4 = 0; l4 < this.clayPerChunk; ++l4) {
            i3 = this.chunkX + this.rand.nextInt(16) + 8;
            k4 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.clayGen.func_76484_a(this.worldObj, this.rand, i3, this.worldObj.func_72825_h(i3, k4), k4);
        }
        if (this.rand.nextInt(60) == 0) {
            i4 = this.chunkX + this.rand.nextInt(16) + 8;
            k3 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.surfaceGravelGen.func_76484_a(this.worldObj, this.rand, i4, 0, k3);
        }
        if (!biomeVariant.disableStructures && Math.abs(this.chunkX) > 32 && Math.abs(this.chunkZ) > 32) {
            boolean roadNear;
            long seed = (long)(this.chunkX * 1879267) ^ (long)this.chunkZ * 67209689L;
            seed = seed * seed * 5829687L + seed * 2876L;
            this.structureRand.setSeed(seed);
            boolean bl = roadNear = LOTRRoads.isRoadNear(this.chunkX + 8, this.chunkZ + 8, 16) >= 0.0f;
            if (!roadNear) {
                for (RandomStructure randomstructure : this.randomStructures) {
                    if (this.structureRand.nextInt(randomstructure.chunkChance) != 0) continue;
                    int i5 = this.chunkX + this.rand.nextInt(16) + 8;
                    int k6 = this.chunkZ + this.rand.nextInt(16) + 8;
                    j2 = this.worldObj.func_72825_h(i5, k6);
                    randomstructure.structureGen.func_76484_a(this.worldObj, this.rand, i5, j2, k6);
                }
            }
            for (LOTRVillageGen village : this.villages) {
                village.generateInChunk(this.worldObj, this.chunkX, this.chunkZ);
            }
        }
        if (LOTRWorldGenMarshHut.generatesAt(this.worldObj, this.chunkX, this.chunkZ)) {
            int i6 = this.chunkX + 8;
            k3 = this.chunkZ + 8;
            j3 = this.worldObj.func_72825_h(i6, k3);
            LOTRWorldGenMarshHut house = new LOTRWorldGenMarshHut();
            house.restrictions = false;
            house.func_76484_a(this.worldObj, this.rand, i6, j3, k3);
        }
        if (LOTRWorldGenGrukHouse.generatesAt(this.worldObj, this.chunkX, this.chunkZ)) {
            int i7 = this.chunkX + 8;
            k3 = this.chunkZ + 8;
            j3 = this.worldObj.func_72825_h(i7, k3);
            LOTRWorldGenGrukHouse house = new LOTRWorldGenGrukHouse(false);
            house.restrictions = false;
            ((LOTRWorldGenStructureBase2)house).generateWithSetRotation(this.worldObj, this.rand, i7, j3, k3, 2);
        }
        if (LOTRWorldGenTicketBooth.generatesAt(this.worldObj, this.chunkX, this.chunkZ)) {
            int i8 = this.chunkX + 8;
            k3 = this.chunkZ + 8;
            j3 = this.worldObj.func_72825_h(i8, k3);
            LOTRWorldGenTicketBooth booth = new LOTRWorldGenTicketBooth(false);
            booth.restrictions = false;
            ((LOTRWorldGenStructureBase2)booth).generateWithSetRotation(this.worldObj, this.rand, i8, j3, k3, 3);
        }
        int trees = this.getVariantTreesPerChunk(biomeVariant);
        if (this.rand.nextFloat() < this.biome.getTreeIncreaseChance() * biomeVariant.treeFactor) {
            ++trees;
        }
        if ((cluster = Math.round((float)this.treeClusterChance * (reciprocalTreeFactor = 1.0f / Math.max(biomeVariant.treeFactor, 0.001f)))) > 0) {
            Random chunkRand = new Random();
            long seed = (long)(this.chunkX / this.treeClusterSize * 3129871) ^ (long)(this.chunkZ / this.treeClusterSize) * 116129781L;
            seed = seed * seed * 42317861L + seed * 11L;
            chunkRand.setSeed(seed);
            if (chunkRand.nextInt(cluster) == 0) {
                trees += 6 + this.rand.nextInt(5);
            }
        }
        for (l3 = 0; l3 < trees; ++l3) {
            int i9 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenAbstractTree treeGen = this.getRandomTreeForVariant(this.rand, biomeVariant).create(false, this.rand);
            treeGen.func_76484_a(this.worldObj, this.rand, i9, this.worldObj.func_72976_f(i9, k2), k2);
        }
        for (l3 = 0; l3 < this.willowPerChunk; ++l3) {
            int i10 = this.chunkX + this.rand.nextInt(16) + 8;
            k2 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenAbstractTree treeGen = LOTRTreeType.WILLOW_WATER.create(false, this.rand);
            treeGen.func_76484_a(this.worldObj, this.rand, i10, this.worldObj.func_72976_f(i10, k2), k2);
        }
        if (trees > 0) {
            float fallenLeaves = (float)trees / 2.0f;
            int fallenLeavesI = (int)fallenLeaves;
            float fallenLeavesR = fallenLeaves - (float)fallenLeavesI;
            if (this.rand.nextFloat() < fallenLeavesR) {
                ++fallenLeavesI;
            }
            int l5 = 0;
            while ((float)l5 < fallenLeaves) {
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                k = this.chunkZ + this.rand.nextInt(16) + 8;
                new LOTRWorldGenFallenLeaves().func_76484_a(this.worldObj, this.rand, i2, this.worldObj.func_72825_h(i2, k), k);
                ++l5;
            }
        }
        if (trees > 0) {
            float bushes = (float)trees / 3.0f;
            int bushesI = (int)bushes;
            float bushesR = bushes - (float)bushesI;
            if (this.rand.nextFloat() < bushesR) {
                ++bushesI;
            }
            int l6 = 0;
            while ((float)l6 < bushes) {
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                k = this.chunkZ + this.rand.nextInt(16) + 8;
                new LOTRWorldGenBushes().func_76484_a(this.worldObj, this.rand, i2, this.worldObj.func_72825_h(i2, k), k);
                ++l6;
            }
        }
        for (l2 = 0; l2 < this.logsPerChunk; ++l2) {
            int i11 = this.chunkX + this.rand.nextInt(16) + 8;
            int k7 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.logGen.func_76484_a(this.worldObj, this.rand, i11, this.worldObj.func_72976_f(i11, k7), k7);
        }
        for (l2 = 0; l2 < this.vinesPerChunk; ++l2) {
            int i12 = this.chunkX + this.rand.nextInt(16) + 8;
            int j5 = 64;
            int k8 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.vinesGen.func_76484_a(this.worldObj, this.rand, i12, j5, k8);
        }
        int flowers = this.flowersPerChunk;
        flowers = Math.round((float)flowers * biomeVariant.flowerFactor);
        for (int l7 = 0; l7 < flowers; ++l7) {
            int i13 = this.chunkX + this.rand.nextInt(16) + 8;
            int j6 = this.rand.nextInt(128);
            int k9 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.flowerGen.func_76484_a(this.worldObj, this.rand, i13, j6, k9);
        }
        int doubleFlowers = this.doubleFlowersPerChunk;
        doubleFlowers = Math.round((float)doubleFlowers * biomeVariant.flowerFactor);
        for (int l8 = 0; l8 < doubleFlowers; ++l8) {
            int i14 = this.chunkX + this.rand.nextInt(16) + 8;
            j2 = this.rand.nextInt(128);
            k = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator doubleFlowerGen = this.biome.getRandomWorldGenForDoubleFlower(this.rand);
            doubleFlowerGen.func_76484_a(this.worldObj, this.rand, i14, j2, k);
        }
        int grasses = this.grassPerChunk;
        grasses = Math.round((float)grasses * biomeVariant.grassFactor);
        for (int l9 = 0; l9 < grasses; ++l9) {
            i2 = this.chunkX + this.rand.nextInt(16) + 8;
            j = this.rand.nextInt(128);
            int k10 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator grassGen = this.biome.func_76730_b(this.rand);
            grassGen.func_76484_a(this.worldObj, this.rand, i2, j, k10);
        }
        int doubleGrasses = this.doubleGrassPerChunk;
        doubleGrasses = Math.round((float)doubleGrasses * biomeVariant.grassFactor);
        for (l = 0; l < doubleGrasses; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j7 = this.rand.nextInt(128);
            int k11 = this.chunkZ + this.rand.nextInt(16) + 8;
            WorldGenerator grassGen = this.biome.getRandomWorldGenForDoubleGrass(this.rand);
            grassGen.func_76484_a(this.worldObj, this.rand, i, j7, k11);
        }
        for (l = 0; l < this.deadBushPerChunk; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j8 = this.rand.nextInt(128);
            int k12 = this.chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(this.worldObj, this.rand, i, j8, k12);
        }
        for (l = 0; l < this.waterlilyPerChunk; ++l) {
            int j9;
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int k13 = this.chunkZ + this.rand.nextInt(16) + 8;
            for (j9 = this.rand.nextInt(128); j9 > 0 && this.worldObj.func_147439_a(i, j9 - 1, k13) == Blocks.field_150350_a; --j9) {
            }
            this.waterlilyGen.func_76484_a(this.worldObj, this.rand, i, j9, k13);
        }
        for (l = 0; l < this.mushroomsPerChunk; ++l) {
            int j10;
            int k14;
            if (this.rand.nextInt(4) == 0) {
                i = this.chunkX + this.rand.nextInt(16) + 8;
                k14 = this.chunkZ + this.rand.nextInt(16) + 8;
                j10 = this.worldObj.func_72976_f(i, k14);
                this.mushroomBrownGen.func_76484_a(this.worldObj, this.rand, i, j10, k14);
            }
            if (this.rand.nextInt(8) != 0) continue;
            i = this.chunkX + this.rand.nextInt(16) + 8;
            k14 = this.chunkZ + this.rand.nextInt(16) + 8;
            j10 = this.worldObj.func_72976_f(i, k14);
            this.mushroomRedGen.func_76484_a(this.worldObj, this.rand, i, j10, k14);
        }
        if (this.enableRandomMushroom) {
            if (this.rand.nextInt(4) == 0) {
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                j = this.rand.nextInt(128);
                int k15 = this.chunkZ + this.rand.nextInt(16) + 8;
                this.mushroomBrownGen.func_76484_a(this.worldObj, this.rand, i2, j, k15);
            }
            if (this.rand.nextInt(8) == 0) {
                i2 = this.chunkX + this.rand.nextInt(16) + 8;
                j = this.rand.nextInt(128);
                int k16 = this.chunkZ + this.rand.nextInt(16) + 8;
                this.mushroomRedGen.func_76484_a(this.worldObj, this.rand, i2, j, k16);
            }
        }
        for (l = 0; l < this.canePerChunk; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j11 = this.rand.nextInt(128);
            int k17 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.caneGen.func_76484_a(this.worldObj, this.rand, i, j11, k17);
        }
        for (l = 0; l < 10; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j12 = this.rand.nextInt(128);
            int k18 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.caneGen.func_76484_a(this.worldObj, this.rand, i, j12, k18);
        }
        for (l = 0; l < this.reedPerChunk; ++l) {
            int j13;
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int k19 = this.chunkZ + this.rand.nextInt(16) + 8;
            for (j13 = this.rand.nextInt(128); j13 > 0 && this.worldObj.func_147439_a(i, j13 - 1, k19) == Blocks.field_150350_a; --j13) {
            }
            if (this.rand.nextFloat() < this.dryReedChance) {
                this.dryReedGen.func_76484_a(this.worldObj, this.rand, i, j13, k19);
                continue;
            }
            this.reedGen.func_76484_a(this.worldObj, this.rand, i, j13, k19);
        }
        for (l = 0; l < this.cornPerChunk; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j14 = this.rand.nextInt(128);
            int k20 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.cornGen.func_76484_a(this.worldObj, this.rand, i, j14, k20);
        }
        for (l = 0; l < this.cactiPerChunk; ++l) {
            i = this.chunkX + this.rand.nextInt(16) + 8;
            int j15 = this.rand.nextInt(128);
            int k21 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.cactusGen.func_76484_a(this.worldObj, this.rand, i, j15, k21);
        }
        if (this.melonPerChunk > 0.0f) {
            int melonInt = MathHelper.func_76128_c((double)this.melonPerChunk);
            float melonF = this.melonPerChunk - (float)melonInt;
            for (int l10 = 0; l10 < melonInt; ++l10) {
                int i15 = this.chunkX + this.rand.nextInt(16) + 8;
                int k22 = this.chunkZ + this.rand.nextInt(16) + 8;
                int j16 = this.worldObj.func_72976_f(i15, k22);
                this.melonGen.func_76484_a(this.worldObj, this.rand, i15, j16, k22);
            }
            if (this.rand.nextFloat() < melonF) {
                int i16 = this.chunkX + this.rand.nextInt(16) + 8;
                int k23 = this.chunkZ + this.rand.nextInt(16) + 8;
                int j17 = this.worldObj.func_72976_f(i16, k23);
                this.melonGen.func_76484_a(this.worldObj, this.rand, i16, j17, k23);
            }
        }
        if (this.flowersPerChunk > 0 && this.rand.nextInt(32) == 0) {
            i2 = this.chunkX + this.rand.nextInt(16) + 8;
            int j18 = this.rand.nextInt(128);
            int k24 = this.chunkZ + this.rand.nextInt(16) + 8;
            this.pumpkinGen.func_76484_a(this.worldObj, this.rand, i2, j18, k24);
        }
        if (this.flowersPerChunk > 0 && this.rand.nextInt(4) == 0) {
            i2 = this.chunkX + this.rand.nextInt(16) + 8;
            int j19 = this.rand.nextInt(128);
            int k25 = this.chunkZ + this.rand.nextInt(16) + 8;
            new LOTRWorldGenBerryBush().func_76484_a(this.worldObj, this.rand, i2, j19, k25);
        }
        if (this.generateAthelas && this.rand.nextInt(30) == 0) {
            i2 = this.chunkX + this.rand.nextInt(16) + 8;
            int j20 = this.rand.nextInt(128);
            int k26 = this.chunkZ + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(LOTRMod.athelas).func_76484_a(this.worldObj, this.rand, i2, j20, k26);
        }
        if (this.generateWater) {
            int l11;
            LOTRWorldGenStreams waterGen = new LOTRWorldGenStreams((Block)Blocks.field_150358_i);
            for (l11 = 0; l11 < 50; ++l11) {
                int i17 = this.chunkX + this.rand.nextInt(16) + 8;
                int j21 = this.rand.nextInt(this.rand.nextInt(120) + 8);
                int k27 = this.chunkZ + this.rand.nextInt(16) + 8;
                waterGen.func_76484_a(this.worldObj, this.rand, i17, j21, k27);
            }
            if (this.biome.field_76748_D > 1.0f) {
                for (l11 = 0; l11 < 50; ++l11) {
                    int i18 = this.chunkX + this.rand.nextInt(16) + 8;
                    int j22 = 100 + this.rand.nextInt(150);
                    int k28 = this.chunkZ + this.rand.nextInt(16) + 8;
                    waterGen.func_76484_a(this.worldObj, this.rand, i18, j22, k28);
                }
            }
        }
        if (this.generateLava) {
            LOTRWorldGenStreams lavaGen = new LOTRWorldGenStreams((Block)Blocks.field_150356_k);
            int lava = 20;
            if (this.biome instanceof LOTRBiomeGenMordor) {
                lava = 50;
            }
            for (int l12 = 0; l12 < lava; ++l12) {
                int i19 = this.chunkX + this.rand.nextInt(16) + 8;
                int j23 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
                int k29 = this.chunkZ + this.rand.nextInt(16) + 8;
                lavaGen.func_76484_a(this.worldObj, this.rand, i19, j23, k29);
            }
        }
        if (this.generateOrcDungeon) {
            for (int l13 = 0; l13 < 6; ++l13) {
                int i20 = this.chunkX + this.rand.nextInt(16) + 8;
                int j24 = this.rand.nextInt(128);
                int k30 = this.chunkZ + this.rand.nextInt(16) + 8;
                this.orcDungeonGen.func_76484_a(this.worldObj, this.rand, i20, j24, k30);
            }
        }
        if (this.generateTrollHoard) {
            for (int l14 = 0; l14 < 2; ++l14) {
                int i21 = this.chunkX + this.rand.nextInt(16) + 8;
                int j25 = MathHelper.func_76136_a((Random)this.rand, (int)36, (int)90);
                int k31 = this.chunkZ + this.rand.nextInt(16) + 8;
                this.trollHoardGen.func_76484_a(this.worldObj, this.rand, i21, j25, k31);
            }
        }
        if (biomeVariant.boulderGen != null && this.rand.nextInt(biomeVariant.boulderChance) == 0) {
            int boulders = MathHelper.func_76136_a((Random)this.rand, (int)1, (int)biomeVariant.boulderMax);
            for (int l15 = 0; l15 < boulders; ++l15) {
                int i22 = this.chunkX + this.rand.nextInt(16) + 8;
                int k32 = this.chunkZ + this.rand.nextInt(16) + 8;
                biomeVariant.boulderGen.func_76484_a(this.worldObj, this.rand, i22, this.worldObj.func_72976_f(i22, k32), k32);
            }
        }
    }

    private void generateOres() {
        float f;
        for (OreGenerant soil : this.biomeSoils) {
            this.genStandardOre(soil.oreChance, soil.oreGen, soil.minHeight, soil.maxHeight);
        }
        for (OreGenerant ore : this.biomeOres) {
            f = ore.oreChance * this.biomeOreFactor;
            this.genStandardOre(f, ore.oreGen, ore.minHeight, ore.maxHeight);
        }
        for (OreGenerant gem : this.biomeGems) {
            f = gem.oreChance * this.biomeGemFactor;
            this.genStandardOre(f, gem.oreGen, gem.minHeight, gem.maxHeight);
        }
    }

    private void genStandardOre(float ores, WorldGenerator oreGen, int minHeight, int maxHeight) {
        while (ores > 0.0f) {
            boolean generate = ores >= 1.0f ? true : this.rand.nextFloat() < ores;
            ores -= 1.0f;
            if (!generate) continue;
            int i = this.chunkX + this.rand.nextInt(16);
            int j = MathHelper.func_76136_a((Random)this.rand, (int)minHeight, (int)maxHeight);
            int k = this.chunkZ + this.rand.nextInt(16);
            oreGen.func_76484_a(this.worldObj, this.rand, i, j, k);
        }
    }

    private class RandomStructure {
        public WorldGenerator structureGen;
        public int chunkChance;

        public RandomStructure(WorldGenerator w, int i) {
            this.structureGen = w;
            this.chunkChance = i;
        }
    }

    private class OreGenerant {
        private WorldGenerator oreGen;
        private float oreChance;
        private int minHeight;
        private int maxHeight;

        public OreGenerant(WorldGenerator gen, float f, int min, int max) {
            this.oreGen = gen;
            this.oreChance = f;
            this.minHeight = min;
            this.maxHeight = max;
        }
    }
}

