/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.item.LOTRItemBanner;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure2.LOTRWorldGenHobbitStructure;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRWorldGenHobbitHole
extends LOTRWorldGenHobbitStructure {
    public LOTRWorldGenHobbitHole(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int j1;
        int k1;
        int k12;
        int i1;
        int k13;
        int j12;
        int j13;
        int i12;
        int k14;
        int signMeta;
        int i13;
        int j14;
        int k15;
        boolean grass;
        int j15;
        int k16;
        int i14;
        int i15;
        this.setOriginAndRotation(world, i, j, k, rotation, 17);
        this.setupRandomBlocks(random);
        int radius = 16;
        int height = 7;
        int extraRadius = 2;
        if (this.restrictions) {
            int minHeight = 0;
            int maxHeight = 0;
            for (i15 = -radius; i15 <= radius; ++i15) {
                for (int k17 = -radius; k17 <= radius; ++k17) {
                    if (i15 * i15 + k17 * k17 > radius * radius) continue;
                    int j16 = this.getTopBlock(world, i15, k17) - 1;
                    if (!this.isSurface(world, i15, j16, k17)) {
                        return false;
                    }
                    if (j16 < minHeight) {
                        minHeight = j16;
                    }
                    if (j16 <= maxHeight) continue;
                    maxHeight = j16;
                }
            }
            if (maxHeight - minHeight > 8) {
                return false;
            }
        }
        for (i14 = -radius; i14 <= radius; ++i14) {
            for (k16 = -radius; k16 <= radius; ++k16) {
                for (j15 = height; j15 >= 0; --j15) {
                    int i2 = i14;
                    int j2 = j15 + (radius - height);
                    int k2 = k16;
                    if (i2 * i2 + j2 * j2 + k2 * k2 >= (radius + extraRadius) * (radius + extraRadius)) continue;
                    boolean grass2 = !this.isOpaque(world, i14, j15 + 1, k16);
                    this.setBlockAndMetadata(world, i14, j15, k16, (Block)(grass2 ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                    this.setGrassToDirt(world, i14, j15 - 1, k16);
                }
            }
        }
        for (i14 = -radius; i14 <= radius; ++i14) {
            for (k16 = -radius; k16 <= radius; ++k16) {
                if (i14 * i14 + k16 * k16 >= radius * radius) continue;
                j15 = -1;
                while (!this.isOpaque(world, i14, j15, k16) && this.getY(j15) >= 0) {
                    grass = !this.isOpaque(world, i14, j15 + 1, k16);
                    this.setBlockAndMetadata(world, i14, j15, k16, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                    this.setGrassToDirt(world, i14, j15 - 1, k16);
                    --j15;
                }
            }
        }
        this.setGrassToDirt(world, 0, 7, 0);
        this.setBlockAndMetadata(world, 0, 8, 0, Blocks.field_150336_V, 0);
        this.setBlockAndMetadata(world, 0, 9, 0, Blocks.field_150336_V, 0);
        this.setBlockAndMetadata(world, 0, 10, 0, Blocks.field_150457_bL, 0);
        for (k15 = -16; k15 <= -13; ++k15) {
            for (j14 = 1; j14 <= 4; ++j14) {
                for (i15 = -3; i15 <= 3; ++i15) {
                    this.setAir(world, i15, j14, k15);
                }
            }
        }
        for (int j17 = 1; j17 <= 3; ++j17) {
            for (i13 = -2; i13 <= 2; ++i13) {
                this.setAir(world, i13, j17, -12);
            }
        }
        for (k15 = -17; k15 <= -13; ++k15) {
            for (i13 = -5; i13 <= 5; ++i13) {
                for (j15 = 0; j15 == 0 || !this.isOpaque(world, i13, j15, k15) && this.getY(j15) >= 0; --j15) {
                    grass = j15 == 0;
                    this.setBlockAndMetadata(world, i13, j15, k15, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                }
                for (j15 = 1; j15 <= 3; ++j15) {
                    this.setAir(world, i13, j15, k15);
                }
            }
        }
        for (k15 = -16; k15 <= -13; ++k15) {
            this.setBlockAndMetadata(world, 4, 1, k15, this.outFenceBlock, this.outFenceMeta);
            this.setBlockAndMetadata(world, -4, 1, k15, this.outFenceBlock, this.outFenceMeta);
            this.setBlockAndMetadata(world, 0, 0, k15, this.pathBlock, this.pathMeta);
        }
        for (i14 = -1; i14 <= 1; ++i14) {
            this.setBlockAndMetadata(world, i14, 0, -12, this.pathBlock, this.pathMeta);
            this.setBlockAndMetadata(world, i14, 0, -11, this.pathBlock, this.pathMeta);
        }
        for (i14 = -3; i14 <= 3; ++i14) {
            this.setBlockAndMetadata(world, i14, 1, -16, this.outFenceBlock, this.outFenceMeta);
        }
        this.setBlockAndMetadata(world, 0, 1, -16, this.outFenceGateBlock, 0);
        if (random.nextInt(5) == 0) {
            String[] signLines = LOTRNames.getHobbitSign(random);
            int[] signPos = new int[]{-3, -2, -1, 1, 2, 3};
            i15 = signPos[random.nextInt(signPos.length)];
            signMeta = MathHelper.func_76136_a((Random)random, (int)6, (int)10) & 0xF;
            this.placeSign(world, i15, 2, -16, Blocks.field_150472_an, signMeta, signLines);
        }
        for (k14 = -15; k14 <= -13; ++k14) {
            int[] signPos = new int[]{-1, 1};
            i15 = signPos.length;
            for (signMeta = 0; signMeta < i15; ++signMeta) {
                i12 = signPos[signMeta];
                int j18 = 1;
                this.plantFlower(world, random, i12, j18, k14);
            }
        }
        if (random.nextInt(3) == 0) {
            for (k14 = -14; k14 <= -13; ++k14) {
                int[] signPos = new int[]{-2, 2};
                i15 = signPos.length;
                for (signMeta = 0; signMeta < i15; ++signMeta) {
                    i12 = signPos[signMeta];
                    this.setBlockAndMetadata(world, i12, 1, k14, this.hedgeBlock, this.hedgeMeta);
                }
            }
        }
        for (int i16 = -2; i16 <= 2; ++i16) {
            for (j14 = 1; j14 <= 3; ++j14) {
                this.setBlockAndMetadata(world, i16, j14, -10, Blocks.field_150336_V, 0);
            }
        }
        boolean gateFlip = random.nextBoolean();
        if (gateFlip) {
            for (i13 = 0; i13 <= 1; ++i13) {
                this.setBlockAndMetadata(world, i13, 0, -10, this.floorBlock, this.floorMeta);
                for (j15 = 1; j15 <= 2; ++j15) {
                    this.setAir(world, i13, j15, -11);
                    this.setBlockAndMetadata(world, i13, j15, -10, this.gateBlock, 2);
                }
            }
            this.setBlockAndMetadata(world, -2, 1, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -2, 2, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -2, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -2, 1, -12, this.plank2StairBlock, 2);
            this.setBlockAndMetadata(world, -2, 3, -12, this.plank2StairBlock, 6);
            this.setBlockAndMetadata(world, -1, 3, -12, this.plank2StairBlock, 4);
            this.setBlockAndMetadata(world, -1, 1, -11, this.plank2StairBlock, 0);
            this.setBlockAndMetadata(world, -1, 2, -11, this.plank2StairBlock, 4);
            this.setBlockAndMetadata(world, -1, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 0, 3, -11, this.plank2StairBlock, 4);
            this.setBlockAndMetadata(world, 0, 3, -12, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, 1, 3, -11, this.plank2StairBlock, 5);
            this.setBlockAndMetadata(world, 1, 3, -12, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, 2, 1, -11, this.plank2StairBlock, 1);
            this.setBlockAndMetadata(world, 2, 2, -11, this.plank2StairBlock, 5);
            this.setBlockAndMetadata(world, 2, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 2, 1, -12, this.plank2StairBlock, 2);
            this.setBlockAndMetadata(world, 2, 3, -12, this.plank2StairBlock, 6);
            this.placeSign(world, -2, 2, -12, Blocks.field_150444_as, 2, new String[]{"", this.homeName1, this.homeName2, ""});
        } else {
            for (i13 = -1; i13 <= 0; ++i13) {
                this.setBlockAndMetadata(world, i13, 0, -10, this.floorBlock, this.floorMeta);
                for (j15 = 1; j15 <= 2; ++j15) {
                    this.setAir(world, i13, j15, -11);
                    this.setBlockAndMetadata(world, i13, j15, -10, this.gateBlock, 2);
                }
            }
            this.setBlockAndMetadata(world, 2, 1, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 2, 2, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 2, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 2, 1, -12, this.plank2StairBlock, 2);
            this.setBlockAndMetadata(world, 2, 3, -12, this.plank2StairBlock, 6);
            this.setBlockAndMetadata(world, 1, 3, -12, this.plank2StairBlock, 5);
            this.setBlockAndMetadata(world, 1, 1, -11, this.plank2StairBlock, 1);
            this.setBlockAndMetadata(world, 1, 2, -11, this.plank2StairBlock, 5);
            this.setBlockAndMetadata(world, 1, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 0, 3, -11, this.plank2StairBlock, 5);
            this.setBlockAndMetadata(world, 0, 3, -12, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, -1, 3, -11, this.plank2StairBlock, 4);
            this.setBlockAndMetadata(world, -1, 3, -12, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, -2, 1, -11, this.plank2StairBlock, 0);
            this.setBlockAndMetadata(world, -2, 2, -11, this.plank2StairBlock, 4);
            this.setBlockAndMetadata(world, -2, 3, -11, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -2, 1, -12, this.plank2StairBlock, 2);
            this.setBlockAndMetadata(world, -2, 3, -12, this.plank2StairBlock, 6);
            this.placeSign(world, 2, 2, -12, Blocks.field_150444_as, 2, new String[]{"", this.homeName1, this.homeName2, ""});
        }
        for (j14 = 1; j14 <= 3; ++j14) {
            this.setBlockAndMetadata(world, -3, j14, -12, LOTRMod.woodBeamV1, 0);
            this.setBlockAndMetadata(world, 3, j14, -12, LOTRMod.woodBeamV1, 0);
        }
        for (i13 = -3; i13 <= 3; ++i13) {
            if (Math.abs(i13) <= 1) {
                this.setBlockAndMetadata(world, i13, 4, -13, LOTRMod.slabClayTileDyedSingle2, 5);
                continue;
            }
            this.setBlockAndMetadata(world, i13, 3, -13, LOTRMod.slabClayTileDyedSingle2, 13);
        }
        this.setBlockAndMetadata(world, -4, 3, -13, LOTRMod.slabClayTileDyedSingle2, 5);
        this.setBlockAndMetadata(world, 4, 3, -13, LOTRMod.slabClayTileDyedSingle2, 5);
        for (k16 = -9; k16 <= 1; ++k16) {
            for (i15 = -2; i15 <= 2; ++i15) {
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k16);
                }
            }
            this.setBlockAndMetadata(world, 1, 0, k16, this.floorBlock, this.floorMeta);
            this.setBlockAndMetadata(world, 0, 0, k16, this.plankBlock, this.plankMeta);
            this.setBlockAndMetadata(world, -1, 0, k16, this.floorBlock, this.floorMeta);
            this.setBlockAndMetadata(world, 2, 1, k16, this.plank2StairBlock, 1);
            this.setBlockAndMetadata(world, -2, 1, k16, this.plank2StairBlock, 0);
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, 3, j15, k16, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, -3, j15, k16, this.plank2Block, this.plank2Meta);
            }
            this.setBlockAndMetadata(world, 2, 3, k16, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -2, 3, k16, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 1, 3, k16, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, -1, 3, k16, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, 0, 4, k16, this.plank2Block, this.plank2Meta);
        }
        int[] k18 = new int[]{-8, -4, 0};
        j15 = k18.length;
        for (j13 = 0; j13 < j15; ++j13) {
            int k19 = k18[j13];
            this.setBlockAndMetadata(world, 0, 3, k19, this.chandelierBlock, this.chandelierMeta);
        }
        for (j12 = 1; j12 <= 3; ++j12) {
            for (i15 = -2; i15 <= 2; ++i15) {
                this.setBlockAndMetadata(world, i15, j12, 2, this.plank2Block, this.plank2Meta);
            }
        }
        this.setBlockAndMetadata(world, 0, 0, 2, this.plankBlock, this.plankMeta);
        this.setAir(world, 0, 1, 2);
        this.setAir(world, 0, 2, 2);
        this.setBlockAndMetadata(world, -1, 1, 2, this.plank2StairBlock, 0);
        this.setBlockAndMetadata(world, 1, 1, 2, this.plank2StairBlock, 1);
        this.setBlockAndMetadata(world, -1, 2, 2, this.plank2StairBlock, 4);
        this.setBlockAndMetadata(world, 1, 2, 2, this.plank2StairBlock, 5);
        for (k13 = 3; k13 <= 9; ++k13) {
            for (i15 = -3; i15 <= 3; ++i15) {
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 4, k13, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, i15, 0, k13, this.plankBlock, this.plankMeta);
            }
        }
        this.setBlockAndMetadata(world, 0, 3, 6, this.chandelierBlock, this.chandelierMeta);
        for (k13 = 5; k13 <= 7; ++k13) {
            for (i15 = -1; i15 <= 1; ++i15) {
                this.setBlockAndMetadata(world, i15, 1, k13, this.carpetBlock, this.carpetMeta);
            }
        }
        if (this.isWealthy && random.nextBoolean()) {
            this.placeChest(world, random, 0, 0, 6, 2, LOTRChestContents.HOBBIT_HOLE_TREASURE);
        }
        for (i1 = -3; i1 <= 3; ++i1) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, i1, j15, 10, this.plank2Block, this.plank2Meta);
            }
        }
        for (i1 = -1; i1 <= 1; ++i1) {
            this.setBlockAndMetadata(world, i1, 2, 10, LOTRMod.glassPane, 0);
            this.setBlockAndMetadata(world, i1, 3, 10, LOTRMod.glassPane, 0);
            for (k12 = 11; k12 <= 14; ++k12) {
                this.setBlockAndMetadata(world, i1, 1, k12, (Block)Blocks.field_150349_c, 0);
                for (j13 = 2; j13 <= 3; ++j13) {
                    this.setAir(world, i1, j13, k12);
                }
            }
            this.setBlockAndMetadata(world, i1, 4, 10, this.plank2Block, this.plank2Meta);
        }
        for (j12 = 1; j12 <= 3; ++j12) {
            this.setBlockAndMetadata(world, -3, j12, 3, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 3, j12, 3, this.plank2Block, this.plank2Meta);
        }
        for (i1 = -2; i1 <= 2; ++i1) {
            this.setBlockAndMetadata(world, i1, 3, 3, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        }
        for (k13 = 4; k13 <= 9; ++k13) {
            this.setBlockAndMetadata(world, -3, 3, k13, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, 3, 3, k13, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        }
        for (i1 = -3; i1 <= 3; ++i1) {
            this.setBlockAndMetadata(world, i1, 1, 9, Blocks.field_150476_ad, 2);
        }
        this.setBlockAndMetadata(world, -3, 1, 8, Blocks.field_150476_ad, 0);
        this.setBlockAndMetadata(world, 3, 1, 8, Blocks.field_150476_ad, 1);
        for (k13 = 4; k13 <= 9; ++k13) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, -4, j15, k13, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, 4, j15, k13, this.plank2Block, this.plank2Meta);
            }
        }
        this.setAir(world, -4, 1, 6);
        this.setAir(world, -4, 2, 6);
        this.setBlockAndMetadata(world, -4, 1, 5, this.plank2StairBlock, 3);
        this.setBlockAndMetadata(world, -4, 1, 7, this.plank2StairBlock, 2);
        this.setBlockAndMetadata(world, -4, 2, 5, this.plank2StairBlock, 7);
        this.setBlockAndMetadata(world, -4, 2, 7, this.plank2StairBlock, 6);
        this.setAir(world, 4, 1, 6);
        this.setAir(world, 4, 2, 6);
        this.setBlockAndMetadata(world, 4, 1, 5, this.plank2StairBlock, 3);
        this.setBlockAndMetadata(world, 4, 1, 7, this.plank2StairBlock, 2);
        this.setBlockAndMetadata(world, 4, 2, 5, this.plank2StairBlock, 7);
        this.setBlockAndMetadata(world, 4, 2, 7, this.plank2StairBlock, 6);
        this.setBlockAndMetadata(world, -3, 2, 4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, 3, 2, 4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, -3, 2, 9, Blocks.field_150478_aa, 2);
        this.setBlockAndMetadata(world, 3, 2, 9, Blocks.field_150478_aa, 1);
        this.setAir(world, 2, 1, -6);
        this.setBlockAndMetadata(world, 2, 0, -6, this.floorBlock, this.floorMeta);
        this.setBlockAndMetadata(world, 3, 0, -6, this.floorBlock, this.floorMeta);
        this.setAir(world, 3, 1, -6);
        this.setAir(world, 3, 2, -6);
        this.setBlockAndMetadata(world, 3, 1, -7, this.plank2StairBlock, 3);
        this.setBlockAndMetadata(world, 3, 1, -5, this.plank2StairBlock, 2);
        this.setBlockAndMetadata(world, 3, 2, -7, this.plank2StairBlock, 7);
        this.setBlockAndMetadata(world, 3, 2, -5, this.plank2StairBlock, 6);
        for (k13 = -8; k13 <= -3; ++k13) {
            for (i15 = 4; i15 <= 8; ++i15) {
                if (i15 == 8 && k13 == -8) continue;
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 0, k13, this.floorBlock, this.floorMeta);
                if (i15 >= 7 && k13 <= -7) continue;
                this.setBlockAndMetadata(world, i15, 4, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (i1 = 4; i1 <= 7; ++i1) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, i1, j15, -2, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, i1, j15, -8, this.plank2Block, this.plank2Meta);
            }
            this.setBlockAndMetadata(world, i1, 3, -7, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, i1, 3, -3, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        }
        for (k13 = -7; k13 <= -3; ++k13) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, 8, j15, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (j12 = 1; j12 <= 2; ++j12) {
            for (i15 = 5; i15 <= 6; ++i15) {
                this.setAir(world, i15, j12, -8);
                this.setBlockAndMetadata(world, i15, j12, -9, Blocks.field_150342_X, 0);
            }
            for (k12 = -6; k12 <= -4; ++k12) {
                this.setAir(world, 8, j12, k12);
                this.setBlockAndMetadata(world, 9, j12, k12, Blocks.field_150342_X, 0);
            }
        }
        this.setBlockAndMetadata(world, 6, 3, -5, this.chandelierBlock, this.chandelierMeta);
        this.setBlockAndMetadata(world, 5, 1, -5, Blocks.field_150476_ad, 3);
        this.setBlockAndMetadata(world, 5, 1, -3, (Block)Blocks.field_150376_bx, 8);
        this.placeChest(world, random, 7, 1, -3, 2, LOTRChestContents.HOBBIT_HOLE_STUDY);
        if (random.nextBoolean()) {
            this.placeWallBanner(world, 3, 3, -4, LOTRItemBanner.BannerType.HOBBIT, 1);
        }
        this.setAir(world, -2, 1, -6);
        this.setBlockAndMetadata(world, -2, 0, -6, this.floorBlock, this.floorMeta);
        this.setBlockAndMetadata(world, -3, 0, -6, this.floorBlock, this.floorMeta);
        this.setAir(world, -3, 1, -6);
        this.setAir(world, -3, 2, -6);
        this.setBlockAndMetadata(world, -3, 1, -7, this.plank2StairBlock, 3);
        this.setBlockAndMetadata(world, -3, 1, -5, this.plank2StairBlock, 2);
        this.setBlockAndMetadata(world, -3, 2, -7, this.plank2StairBlock, 7);
        this.setBlockAndMetadata(world, -3, 2, -5, this.plank2StairBlock, 6);
        for (k13 = -7; k13 <= -4; ++k13) {
            for (i15 = -4; i15 >= -7; --i15) {
                this.setBlockAndMetadata(world, i15, 0, k13, this.floorBlock, this.floorMeta);
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 4, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (i1 = -4; i1 >= -7; --i1) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, i1, j15, -8, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, i1, j15, -3, this.plank2Block, this.plank2Meta);
            }
            this.setBlockAndMetadata(world, i1, 3, -7, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, i1, 3, -4, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        }
        for (k13 = -7; k13 <= -3; ++k13) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, -8, j15, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (k13 = -7; k13 <= -6; ++k13) {
            for (i15 = -5; i15 >= -6; --i15) {
                this.setBlockAndMetadata(world, i15, 1, k13, this.carpetBlock, this.carpetMeta);
            }
        }
        for (i1 = -5; i1 >= -6; --i1) {
            this.setBlockAndMetadata(world, i1, 0, -8, this.floorBlock, this.floorMeta);
            this.setBlockAndMetadata(world, i1, 1, -8, (Block)Blocks.field_150376_bx, 8);
            this.setBlockAndMetadata(world, i1, 2, -8, Blocks.field_150342_X, 0);
            this.setBlockAndMetadata(world, i1, 1, -9, this.plank2Block, this.plank2Meta);
        }
        this.setBlockAndMetadata(world, -4, 1, -4, Blocks.field_150344_f, 0);
        this.setBlockAndMetadata(world, -7, 1, -4, Blocks.field_150344_f, 0);
        this.setBlockAndMetadata(world, -4, 2, -4, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, -7, 2, -4, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, -5, 1, -5, this.bedBlock, 0);
        this.setBlockAndMetadata(world, -5, 1, -4, this.bedBlock, 8);
        this.setBlockAndMetadata(world, -6, 1, -5, this.bedBlock, 0);
        this.setBlockAndMetadata(world, -6, 1, -4, this.bedBlock, 8);
        this.spawnItemFrame(world, -8, 2, -6, 1, new ItemStack(Items.field_151113_aN));
        this.setBlockAndMetadata(world, 4, 0, 6, this.plankBlock, this.plankMeta);
        for (i1 = 5; i1 <= 6; ++i1) {
            this.setBlockAndMetadata(world, i1, 0, 7, this.floorBlock, this.floorMeta);
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setAir(world, i1, j15, 7);
            }
            this.setBlockAndMetadata(world, i1, 4, 7, this.plank2Block, this.plank2Meta);
        }
        for (i1 = 5; i1 <= 7; ++i1) {
            this.setBlockAndMetadata(world, i1, 0, 6, this.floorBlock, this.floorMeta);
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setAir(world, i1, j15, 6);
            }
            this.setBlockAndMetadata(world, i1, 4, 6, this.plank2Block, this.plank2Meta);
        }
        for (i1 = 5; i1 <= 8; ++i1) {
            this.setBlockAndMetadata(world, i1, 0, 5, this.floorBlock, this.floorMeta);
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setAir(world, i1, j15, 5);
            }
            this.setBlockAndMetadata(world, i1, 4, 5, this.plank2Block, this.plank2Meta);
        }
        for (j12 = 1; j12 <= 3; ++j12) {
            this.setBlockAndMetadata(world, 7, j12, 7, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 8, j12, 6, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, 9, j12, 5, this.plank2Block, this.plank2Meta);
        }
        this.setBlockAndMetadata(world, 7, 2, 6, Blocks.field_150478_aa, 4);
        this.setBlockAndMetadata(world, 8, 2, 5, Blocks.field_150478_aa, 1);
        for (k13 = 4; k13 >= -1; --k13) {
            for (i15 = 4; i15 <= 9; ++i15) {
                this.setBlockAndMetadata(world, i15, 0, k13, this.floorBlock, this.floorMeta);
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 4, k13, this.plank2Block, this.plank2Meta);
            }
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, 3, j15, k13, this.plank2Block, this.plank2Meta);
                this.setBlockAndMetadata(world, 10, j15, k13, this.plank2Block, this.plank2Meta);
            }
            this.setBlockAndMetadata(world, 4, 3, k13, this.plank2SlabBlock, this.plank2SlabMeta | 8);
            this.setBlockAndMetadata(world, 9, 3, k13, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        }
        for (k13 = 2; k13 >= 0; --k13) {
            this.setBlockAndMetadata(world, 4, 1, k13, Blocks.field_150476_ad, 0);
            this.setBlockAndMetadata(world, 9, 1, k13, Blocks.field_150476_ad, 1);
        }
        this.setBlockAndMetadata(world, 4, 1, -1, Blocks.field_150476_ad, 3);
        this.setBlockAndMetadata(world, 4, 1, 3, Blocks.field_150476_ad, 2);
        this.setBlockAndMetadata(world, 9, 1, -1, Blocks.field_150476_ad, 3);
        this.setBlockAndMetadata(world, 9, 1, 3, Blocks.field_150476_ad, 2);
        this.setBlockAndMetadata(world, 6, 3, 1, this.chandelierBlock, this.chandelierMeta);
        this.setBlockAndMetadata(world, 7, 3, 1, this.chandelierBlock, this.chandelierMeta);
        this.setBlockAndMetadata(world, 6, 1, 2, Blocks.field_150344_f, 1);
        this.setBlockAndMetadata(world, 7, 1, 2, Blocks.field_150344_f, 1);
        this.setBlockAndMetadata(world, 6, 1, 1, (Block)Blocks.field_150376_bx, 9);
        this.setBlockAndMetadata(world, 7, 1, 1, (Block)Blocks.field_150376_bx, 9);
        this.setBlockAndMetadata(world, 6, 1, 0, Blocks.field_150344_f, 1);
        this.setBlockAndMetadata(world, 7, 1, 0, Blocks.field_150344_f, 1);
        for (i1 = 6; i1 <= 7; ++i1) {
            for (k12 = 2; k12 >= 0; --k12) {
                if (random.nextInt(3) == 0) {
                    this.placeMug(world, random, i1, 2, k12, random.nextInt(4), LOTRFoods.HOBBIT_DRINK);
                    continue;
                }
                if (random.nextBoolean()) {
                    this.placePlateWithCertainty(world, random, i1, 2, k12, this.plateBlock, LOTRFoods.HOBBIT);
                    continue;
                }
                this.placePlate(world, random, i1, 2, k12, this.plateBlock, LOTRFoods.HOBBIT);
            }
        }
        this.setBlockAndMetadata(world, 5, 3, 7, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        this.setBlockAndMetadata(world, 6, 3, 7, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        this.setBlockAndMetadata(world, 7, 3, 6, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        this.setBlockAndMetadata(world, 8, 3, 5, this.plank2SlabBlock, this.plank2SlabMeta | 8);
        for (j12 = 1; j12 <= 3; ++j12) {
            for (i15 = 5; i15 <= 6; ++i15) {
                this.setBlockAndMetadata(world, i15, j12, 8, this.plank2Block, this.plank2Meta);
            }
            for (i15 = 8; i15 <= 9; ++i15) {
                this.setBlockAndMetadata(world, i15, j12, -2, this.plank2Block, this.plank2Meta);
            }
        }
        this.setBlockAndMetadata(world, -4, 0, 6, this.plankBlock, this.plankMeta);
        for (k13 = 7; k13 >= 3; --k13) {
            for (i15 = -5; i15 >= -7; --i15) {
                this.setBlockAndMetadata(world, i15, 0, k13, (Block)Blocks.field_150334_T, 0);
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 4, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (k13 = 6; k13 >= 3; --k13) {
            for (i15 = -5; i15 >= -6; --i15) {
                this.setBlockAndMetadata(world, i15, 0, k13, this.floorBlock, this.floorMeta);
            }
        }
        this.setBlockAndMetadata(world, -5, 1, 8, Blocks.field_150462_ai, 0);
        this.setBlockAndMetadata(world, -6, 1, 8, Blocks.field_150462_ai, 0);
        this.setBlockAndMetadata(world, -7, 1, 8, this.tableBlock, 0);
        for (i1 = -7; i1 <= -5; ++i1) {
            this.setAir(world, i1, 2, 8);
            this.setBlockAndMetadata(world, i1, 2, 9, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, i1, 3, 8, (Block)Blocks.field_150334_T, 0);
        }
        this.setBlockAndMetadata(world, -8, 1, 8, this.plank2Block, this.plank2Meta);
        this.setBlockAndMetadata(world, -8, 2, 8, this.plank2Block, this.plank2Meta);
        for (k13 = 6; k13 <= 7; ++k13) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, -8, j15, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (k13 = 3; k13 <= 5; ++k13) {
            this.setBlockAndMetadata(world, -8, 0, k13, (Block)Blocks.field_150334_T, 0);
            this.setAir(world, -8, 2, k13);
            this.setBlockAndMetadata(world, -9, 2, k13, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -8, 3, k13, (Block)Blocks.field_150334_T, 0);
        }
        this.setBlockAndMetadata(world, -8, 1, 4, this.plank2Block, this.plank2Meta);
        this.setBlockAndMetadata(world, -8, 1, 5, LOTRMod.hobbitOven, 4);
        this.setBlockAndMetadata(world, -8, 1, 3, LOTRMod.hobbitOven, 4);
        this.setBlockAndMetadata(world, -8, 1, 4, (Block)Blocks.field_150383_bp, 3);
        this.setBlockAndMetadata(world, -6, 3, 5, this.chandelierBlock, this.chandelierMeta);
        for (i1 = -4; i1 >= -9; --i1) {
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, i1, j15, 2, this.plank2Block, this.plank2Meta);
            }
        }
        this.setBlockAndMetadata(world, -6, 0, 2, this.plankBlock, this.plankMeta);
        this.setAir(world, -6, 1, 2);
        this.setAir(world, -6, 2, 2);
        this.setBlockAndMetadata(world, -7, 1, 2, this.plank2StairBlock, 0);
        this.setBlockAndMetadata(world, -5, 1, 2, this.plank2StairBlock, 1);
        this.setBlockAndMetadata(world, -7, 2, 2, this.plank2StairBlock, 4);
        this.setBlockAndMetadata(world, -5, 2, 2, this.plank2StairBlock, 5);
        for (k13 = -2; k13 <= 1; ++k13) {
            for (i15 = -9; i15 <= -4; ++i15) {
                this.setBlockAndMetadata(world, i15, 0, k13, this.plankBlock, this.plankMeta);
                for (j13 = 1; j13 <= 3; ++j13) {
                    this.setAir(world, i15, j13, k13);
                }
                this.setBlockAndMetadata(world, i15, 4, k13, (Block)Blocks.field_150334_T, 0);
            }
            for (j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, -10, j15, k13, this.plank2Block, this.plank2Meta);
            }
        }
        for (i1 = -9; i1 <= -4; ++i1) {
            this.setBlockAndMetadata(world, i1, 1, -2, (Block)Blocks.field_150376_bx, 8);
            this.setBlockAndMetadata(world, i1, 3, -2, (Block)Blocks.field_150376_bx, 0);
        }
        for (k13 = -2; k13 <= 1; ++k13) {
            this.setBlockAndMetadata(world, -4, 1, k13, (Block)Blocks.field_150376_bx, 8);
            this.setBlockAndMetadata(world, -4, 3, k13, (Block)Blocks.field_150376_bx, 0);
            this.setBlockAndMetadata(world, -9, 1, k13, (Block)Blocks.field_150376_bx, 8);
            this.setBlockAndMetadata(world, -9, 3, k13, (Block)Blocks.field_150376_bx, 0);
        }
        this.setBlockAndMetadata(world, -8, 1, 1, (Block)Blocks.field_150376_bx, 8);
        this.setBlockAndMetadata(world, -8, 3, 1, (Block)Blocks.field_150376_bx, 0);
        this.setBlockAndMetadata(world, -6, 3, 1, Blocks.field_150478_aa, 4);
        for (k13 = -2; k13 <= 1; ++k13) {
            if (random.nextInt(3) == 0) continue;
            Block cakeBlock = LOTRWorldGenHobbitStructure.getRandomCakeBlock(random);
            this.setBlockAndMetadata(world, -4, 2, k13, cakeBlock, 0);
        }
        for (i1 = -7; i1 <= -6; ++i1) {
            this.placePlateWithCertainty(world, random, i1, 2, -2, this.plateBlock, LOTRFoods.HOBBIT);
        }
        this.placeBarrel(world, random, -5, 2, -2, 3, LOTRFoods.HOBBIT_DRINK);
        for (j12 = 1; j12 <= 3; ++j12) {
            this.setBlockAndMetadata(world, -9, j12, -3, this.plank2Block, this.plank2Meta);
            this.setBlockAndMetadata(world, -4, j12, 3, this.plank2Block, this.plank2Meta);
        }
        this.placeChest(world, random, -8, 2, -2, (Block)Blocks.field_150486_ae, 3, LOTRChestContents.HOBBIT_HOLE_LARDER);
        this.placeChest(world, random, -9, 2, -1, (Block)Blocks.field_150486_ae, 4, LOTRChestContents.HOBBIT_HOLE_LARDER);
        this.placeChest(world, random, -9, 2, 0, (Block)Blocks.field_150486_ae, 4, LOTRChestContents.HOBBIT_HOLE_LARDER);
        this.placeChest(world, random, -8, 2, 1, (Block)Blocks.field_150486_ae, 2, LOTRChestContents.HOBBIT_HOLE_LARDER);
        if (gateFlip) {
            this.setBlockAndMetadata(world, -1, 2, -9, (Block)Blocks.field_150479_bC, 0);
        } else {
            this.setBlockAndMetadata(world, 1, 2, -9, (Block)Blocks.field_150479_bC, 0);
        }
        int grassRadius = radius - 3;
        int grass3 = MathHelper.func_76136_a((Random)random, (int)80, (int)120);
        for (int l = 0; l < grass3; ++l) {
            i12 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            k1 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            j1 = this.getTopBlock(world, i12, k1);
            this.plantTallGrass(world, random, i12, j1, k1);
        }
        int flowers = MathHelper.func_76136_a((Random)random, (int)8, (int)16);
        for (int l = 0; l < flowers; ++l) {
            int i17 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            int k110 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            int j19 = this.getTopBlock(world, i17, k110);
            this.plantFlower(world, random, i17, j19, k110);
        }
        if (random.nextInt(4) == 0) {
            i12 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            k1 = MathHelper.func_76136_a((Random)random, (int)(-grassRadius), (int)grassRadius);
            j1 = this.getTopBlock(world, i12, k1);
            WorldGenAbstractTree treeGen = LOTRBiome.shire.func_150567_a(random);
            treeGen.func_76484_a(world, random, this.getX(i12, k1), this.getY(j1), this.getZ(i12, k1));
        }
        int homeRadius = MathHelper.func_76128_c((double)((double)radius * 1.5));
        this.spawnHobbitCouple(world, 0, 1, 0, homeRadius);
        return true;
    }
}

